/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.fs;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.detail.FileSystemAPI;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.fs.Label;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.server.fs.FileSystem;
import li.cil.oc.server.fs.FileSystem$;
import li.cil.oc.server.fs.InputStreamFileSystem;
import li.cil.oc.server.fs.ReadOnlyWrapper;
import li.cil.oc.server.fs.ZipFileInputStreamFileSystem$;
import net.minecraftforge.common.DimensionManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class FileSystem$
implements FileSystemAPI {
    public static final FileSystem$ MODULE$;
    private boolean isCaseInsensitive;
    private final Set<Object> li$cil$oc$server$fs$FileSystem$$invalidChars;
    private volatile boolean bitmap$0;

    static {
        new FileSystem$();
    }

    private boolean isCaseInsensitive$lzycompute() {
        FileSystem$ fileSystem$ = this;
        synchronized (fileSystem$) {
            if (!this.bitmap$0) {
                this.isCaseInsensitive = Settings$.MODULE$.get().forceCaseInsensitive() || this.liftedTree1$1();
                this.bitmap$0 = true;
            }
            return this.isCaseInsensitive;
        }
    }

    public boolean isCaseInsensitive() {
        return this.bitmap$0 ? this.isCaseInsensitive : this.isCaseInsensitive$lzycompute();
    }

    public Set<Object> li$cil$oc$server$fs$FileSystem$$invalidChars() {
        return this.li$cil$oc$server$fs$FileSystem$$invalidChars;
    }

    public boolean isValidFilename(String name) {
        return !new StringOps(Predef$.MODULE$.augmentString(name)).exists((Function1)new Serializable(){

            public final boolean apply(char elem) {
                return FileSystem$.MODULE$.li$cil$oc$server$fs$FileSystem$$invalidChars().contains((Object)BoxesRunTime.boxToCharacter((char)elem));
            }
        });
    }

    public String validatePath(String path) {
        if (this.isValidFilename(path)) {
            return path;
        }
        throw new IOException("path contains invalid characters");
    }

    @Override
    public FileSystem fromClass(Class<?> clazz, String domain, String root) {
        Tuple2 tuple2;
        block2: {
            block5: {
                Option option;
                block10: {
                    InputStreamFileSystem inputStreamFileSystem;
                    block4: {
                        FileSystem.ReadOnlyFileSystem readOnlyFileSystem;
                        block7: {
                            FileSystem.ReadOnlyFileSystem readOnlyFileSystem2;
                            block9: {
                                String innerPath;
                                block8: {
                                    block6: {
                                        File file;
                                        block3: {
                                            Tuple2 tuple22;
                                            innerPath = new StringBuilder().append((Object)"/assets/").append((Object)domain).append((Object)"/").append((Object)new StringBuilder().append((Object)root.trim()).append((Object)"/").toString()).toString().replace("//", "/");
                                            String codeSource = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
                                            Tuple2 tuple23 = tuple2 = codeSource.contains(".zip!") || codeSource.contains(".jar!") ? new Tuple2((Object)codeSource.substring(0, codeSource.lastIndexOf(33)), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)codeSource, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                                            if (tuple2 == null) break block2;
                                            String codeUrl = (String)tuple2._1();
                                            boolean isArchive = tuple2._2$mcZ$sp();
                                            Tuple2 tuple24 = tuple22 = new Tuple2((Object)codeUrl, (Object)BoxesRunTime.boxToBoolean((boolean)isArchive));
                                            String codeUrl2 = (String)tuple24._1();
                                            boolean isArchive2 = tuple24._2$mcZ$sp();
                                            Try url = Try$.MODULE$.apply((Function0)new Serializable(codeUrl2){
                                                private final String codeUrl$1;

                                                public final URL apply() {
                                                    return new URL(this.codeUrl$1);
                                                }
                                                {
                                                    this.codeUrl$1 = codeUrl$1;
                                                }
                                            }).recoverWith((PartialFunction)new Serializable(codeUrl2){
                                                public final String codeUrl$1;

                                                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                                    A1 A1 = x1;
                                                    Object object = A1 instanceof MalformedURLException ? Try$.MODULE$.apply((Function0)new Serializable(this){
                                                        private final /* synthetic */ anonfun.1 $outer;

                                                        public final URL apply() {
                                                            return new URL(new StringBuilder().append((Object)"file://").append((Object)this.$outer.codeUrl$1).toString());
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    }) : function1.apply(x1);
                                                    return (B1)object;
                                                }

                                                public final boolean isDefinedAt(Throwable x1) {
                                                    Throwable throwable = x1;
                                                    boolean bl = throwable instanceof MalformedURLException;
                                                    return bl;
                                                }
                                                {
                                                    this.codeUrl$1 = codeUrl$1;
                                                }
                                            });
                                            file = (File)url.map((Function1)new Serializable(){

                                                public final File apply(URL url) {
                                                    return new File(url.toURI());
                                                }
                                            }).recoverWith((PartialFunction)new Serializable(url){
                                                private final Try url$1;

                                                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                                    A1 A1 = x2;
                                                    Object object = A1 instanceof URISyntaxException ? this.url$1.map((Function1)new Serializable(this){

                                                        public final File apply(URL url) {
                                                            return new File(url.getPath());
                                                        }
                                                    }) : function1.apply(x2);
                                                    return (B1)object;
                                                }

                                                public final boolean isDefinedAt(Throwable x2) {
                                                    Throwable throwable = x2;
                                                    boolean bl = throwable instanceof URISyntaxException;
                                                    return bl;
                                                }
                                                {
                                                    this.url$1 = url$1;
                                                }
                                            }).getOrElse((Function0)new Serializable(codeSource){
                                                private final String codeSource$1;

                                                public final File apply() {
                                                    return new File(this.codeSource$1);
                                                }
                                                {
                                                    this.codeSource$1 = codeSource$1;
                                                }
                                            });
                                            if (!isArchive2) break block3;
                                            inputStreamFileSystem = ZipFileInputStreamFileSystem$.MODULE$.fromFile(file, innerPath.substring(1));
                                            break block4;
                                        }
                                        if (!file.exists() || file.isDirectory()) break block5;
                                        File file2 = new File(new File(file.getParent()), innerPath);
                                        if (!file2.exists() || !file2.isDirectory()) break block6;
                                        readOnlyFileSystem = new FileSystem.ReadOnlyFileSystem(file2);
                                        break block7;
                                    }
                                    option = Predef$.MODULE$.refArrayOps((Object[])System.getProperty("java.class.path").split(System.getProperty("path.separator"))).find((Function1)new anonfun.6(innerPath));
                                    if (!None$.MODULE$.equals(option)) break block8;
                                    readOnlyFileSystem2 = null;
                                    break block9;
                                }
                                if (!(option instanceof Some)) break block10;
                                Some some = (Some)option;
                                String dir = (String)some.x();
                                readOnlyFileSystem2 = new FileSystem.ReadOnlyFileSystem(new File(new File(dir), innerPath));
                            }
                            readOnlyFileSystem = readOnlyFileSystem2;
                        }
                        inputStreamFileSystem = readOnlyFileSystem;
                    }
                    return inputStreamFileSystem;
                }
                throw new MatchError((Object)option);
            }
            return null;
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public FileSystem fromSaveDirectory(String root, long capacity, boolean buffered) {
        File path = new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)root).toString());
        Object object = path.isDirectory() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)path.delete());
        path.mkdirs();
        return path.exists() && path.isDirectory() ? (buffered ? new FileSystem.BufferedFileSystem(path, capacity) : new FileSystem.ReadWriteFileSystem(path, capacity)) : null;
    }

    @Override
    public FileSystem fromMemory(long capacity) {
        return new FileSystem.RamFileSystem(capacity);
    }

    @Override
    public FileSystem asReadOnly(FileSystem fileSystem) {
        return fileSystem.isReadOnly() ? fileSystem : new ReadOnlyWrapper(fileSystem);
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, Label label, EnvironmentHost host, String accessSound, int speed) {
        return (ManagedEnvironment)Option$.MODULE$.apply((Object)fileSystem).flatMap((Function1)new Serializable(label, host, accessSound, speed){
            private final Label label$1;
            private final EnvironmentHost host$1;
            private final String accessSound$1;
            private final int speed$1;

            public final Some<li.cil.oc.server.component.FileSystem> apply(FileSystem fs) {
                return new Some((Object)new li.cil.oc.server.component.FileSystem(fs, this.label$1, (Option<EnvironmentHost>)Option$.MODULE$.apply((Object)this.host$1), (Option<String>)Option$.MODULE$.apply((Object)this.accessSound$1), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.speed$1 - 1), 0)), 5)));
            }
            {
                this.label$1 = label$1;
                this.host$1 = host$1;
                this.accessSound$1 = accessSound$1;
                this.speed$1 = speed$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, String label, EnvironmentHost host, String accessSound, int speed) {
        return this.asManagedEnvironment(fileSystem, new FileSystem.ReadOnlyLabel(label), host, accessSound, speed);
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, Label label, EnvironmentHost host, String sound) {
        return this.asManagedEnvironment(fileSystem, label, host, sound, 1);
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, String label, EnvironmentHost host, String sound) {
        return this.asManagedEnvironment(fileSystem, new FileSystem.ReadOnlyLabel(label), host, sound, 1);
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, Label label) {
        return this.asManagedEnvironment(fileSystem, label, null, null, 1);
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, String label) {
        return this.asManagedEnvironment(fileSystem, new FileSystem.ReadOnlyLabel(label), null, null, 1);
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem) {
        return this.asManagedEnvironment(fileSystem, (Label)null, (EnvironmentHost)null, (String)null, 1);
    }

    private final boolean liftedTree1$1() {
        boolean bl;
        try {
            String uuid = UUID.randomUUID().toString();
            File lowerCase = new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)uuid).append((Object)"oc_rox").toString());
            File upperCase = new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)uuid).append((Object)"OC_ROX").toString());
            boolean bl2 = lowerCase.exists() && lowerCase.delete();
            boolean bl3 = upperCase.exists() && upperCase.delete();
            lowerCase.createNewFile();
            boolean insensitive = upperCase.exists();
            lowerCase.delete();
            bl = insensitive;
        }
        catch (Throwable throwable) {
            OpenComputers$.MODULE$.log().warn("Couldn't determine if file system is case sensitive, falling back to insensitive.", throwable);
            bl = true;
        }
        return bl;
    }

    private FileSystem$() {
        MODULE$ = this;
        this.li$cil$oc$server$fs$FileSystem$$invalidChars = new StringOps(Predef$.MODULE$.augmentString("\\:*?\"<>|")).toSet();
    }
}

