/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.ItemStackListOredicted;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackList
implements IItemStackList {
    private ArrayListMultimap<Item, ItemStack> stacks = ArrayListMultimap.create();
    private List<ItemStack> removeTracker = new LinkedList<ItemStack>();

    @Override
    public void add(@Nonnull ItemStack stack, int size) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            otherStack.field_77994_a = (long)otherStack.field_77994_a + (long)size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (otherStack.field_77994_a += size);
            return;
        }
        this.stacks.put((Object)stack.func_77973_b(), (Object)(size == 0 ? stack.func_77946_l() : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size)));
    }

    @Override
    public boolean remove(@Nonnull ItemStack stack, int size, boolean removeIfReachedZero) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            boolean success;
            if (otherStack.field_77994_a <= 0 || !API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            otherStack.field_77994_a -= size;
            boolean bl = success = otherStack.field_77994_a >= 0;
            if (otherStack.field_77994_a <= 0 && removeIfReachedZero) {
                this.stacks.remove((Object)otherStack.func_77973_b(), (Object)otherStack);
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean trackedRemove(@Nonnull ItemStack stack, int size, boolean removeIfReachedZero) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            boolean success;
            if (otherStack.field_77994_a <= 0 || !API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            ItemStack removed = ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)Math.min(size, otherStack.field_77994_a));
            this.removeTracker.add(removed);
            otherStack.field_77994_a -= size;
            boolean bl = success = otherStack.field_77994_a >= 0;
            if (otherStack.field_77994_a <= 0 && removeIfReachedZero) {
                this.stacks.remove((Object)otherStack.func_77973_b(), (Object)otherStack);
            }
            return success;
        }
        return false;
    }

    @Override
    public List<ItemStack> getRemoveTracker() {
        return this.removeTracker;
    }

    @Override
    public void undo() {
        this.removeTracker.forEach(this::add);
        this.removeTracker.clear();
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        for (ItemStack otherStack : (flags & 8) == 8 ? this.stacks.values() : this.stacks.get((Object)stack.func_77973_b())) {
            if (otherStack.field_77994_a <= 0 || !API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack get(int hash) {
        for (ItemStack stack : this.stacks.values()) {
            if (API.instance().getItemStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void clear() {
        this.stacks.clear();
    }

    @Override
    public void clean() {
        List<ItemStack> toRemove = this.stacks.values().stream().filter(stack -> stack.field_77994_a <= 0).collect(Collectors.toList());
        toRemove.forEach(stack -> this.stacks.remove((Object)stack.func_77973_b(), stack));
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public IItemStackList copy() {
        ItemStackList list = new ItemStackList();
        for (ItemStack stack : this.stacks.values()) {
            list.stacks.put((Object)stack.func_77973_b(), (Object)stack.func_77946_l());
        }
        return list;
    }

    @Override
    @Nonnull
    public IItemStackList getOredicted() {
        return new ItemStackListOredicted(this);
    }

    public String toString() {
        return this.stacks.toString();
    }

    public static ItemStack[] toCraftingGrid(IItemStackList list, List<ItemStack> grid, int compare) {
        ItemStack[] took = new ItemStack[9];
        for (int i = 0; i < grid.size(); ++i) {
            ItemStack taken;
            ItemStack input = grid.get(i);
            if (input == null) continue;
            compare = input.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
            ItemStack actualInput = list.get(input, compare);
            took[i] = taken = ItemHandlerHelper.copyStackWithSize((ItemStack)actualInput, (int)input.field_77994_a);
            list.remove(taken, true);
        }
        return took;
    }
}

