/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.ctm;

import mekanism.client.render.ctm.CTM;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public enum Dir {
    TOP(EnumFacing.UP),
    TOP_RIGHT(EnumFacing.UP, EnumFacing.EAST),
    RIGHT(EnumFacing.EAST),
    BOTTOM_RIGHT(EnumFacing.DOWN, EnumFacing.EAST),
    BOTTOM(EnumFacing.DOWN),
    BOTTOM_LEFT(EnumFacing.DOWN, EnumFacing.WEST),
    LEFT(EnumFacing.WEST),
    TOP_LEFT(EnumFacing.UP, EnumFacing.WEST);

    public static final Dir[] VALUES;
    private static final EnumFacing NORMAL;
    private EnumFacing[] dirs;
    private static final int[] FACING_LOOKUP;

    private Dir(EnumFacing ... dirs) {
        this.dirs = dirs;
    }

    public boolean isConnected(CTM ctm, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ctm.isConnected(world, pos, this.getConnection(pos, side), side);
    }

    public boolean isConnected(CTM ctm, IBlockAccess world, BlockPos pos, EnumFacing side, IBlockState state) {
        return ctm.isConnected(world, pos, this.getConnection(pos, side), side, state);
    }

    private BlockPos getConnection(BlockPos pos, EnumFacing side) {
        EnumFacing[] dirs = this.getNormalizedDirs(side);
        BlockPos connection = pos;
        for (EnumFacing dir : dirs) {
            connection = connection.func_177972_a(dir);
        }
        return connection;
    }

    public EnumFacing[] getNormalizedDirs(EnumFacing normal) {
        if (normal == NORMAL) {
            return this.dirs;
        }
        if (normal == NORMAL.func_176734_d()) {
            EnumFacing[] ret = new EnumFacing[this.dirs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.dirs[i].func_96559_d() != 0 ? this.dirs[i] : this.dirs[i].func_176734_d();
            }
            return ret;
        }
        EnumFacing axis = null;
        axis = normal.func_96559_d() == 0 ? (normal == NORMAL.func_176746_e() ? EnumFacing.UP : EnumFacing.DOWN) : (normal == EnumFacing.UP ? NORMAL.func_176735_f() : NORMAL.func_176746_e());
        EnumFacing[] ret = new EnumFacing[this.dirs.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.rotate(this.dirs[i], axis);
        }
        return ret;
    }

    private EnumFacing rotate(EnumFacing facing, EnumFacing axisFacing) {
        EnumFacing.Axis axis = axisFacing.func_176740_k();
        EnumFacing.AxisDirection axisDir = axisFacing.func_176743_c();
        if (axisDir == EnumFacing.AxisDirection.POSITIVE) {
            return facing.func_176732_a(axis);
        }
        if (facing.func_176740_k() != axis) {
            switch (axis) {
                case X: {
                    switch (FACING_LOOKUP[facing.ordinal()]) {
                        case 1: {
                            return EnumFacing.NORTH;
                        }
                        default: {
                            return facing;
                        }
                        case 3: {
                            return EnumFacing.SOUTH;
                        }
                        case 5: {
                            return EnumFacing.SOUTH;
                        }
                        case 6: 
                    }
                    return EnumFacing.NORTH;
                }
                case Y: {
                    return facing.func_176735_f();
                }
                case Z: {
                    switch (FACING_LOOKUP[facing.ordinal()]) {
                        case 2: {
                            return EnumFacing.EAST;
                        }
                        default: {
                            return facing;
                        }
                        case 4: {
                            return EnumFacing.WEST;
                        }
                        case 5: {
                            return EnumFacing.DOWN;
                        }
                        case 6: 
                    }
                    return EnumFacing.UP;
                }
            }
        }
        return facing;
    }

    static {
        VALUES = Dir.values();
        NORMAL = EnumFacing.SOUTH;
        FACING_LOOKUP = new int[EnumFacing.values().length];
        Dir.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 1;
        Dir.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 2;
        Dir.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 3;
        Dir.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 4;
        Dir.FACING_LOOKUP[EnumFacing.UP.ordinal()] = 5;
        Dir.FACING_LOOKUP[EnumFacing.DOWN.ordinal()] = 6;
    }
}

