/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class GasTransmission {
    public static IGasHandler[] getConnectedAcceptors(TileEntity tileEntity, Collection<EnumFacing> sides) {
        return GasTransmission.getConnectedAcceptors(tileEntity.func_174877_v(), tileEntity.func_145831_w(), sides);
    }

    public static IGasHandler[] getConnectedAcceptors(BlockPos pos, World world, Collection<EnumFacing> sides) {
        IGasHandler[] acceptors = new IGasHandler[]{null, null, null, null, null, null};
        for (EnumFacing orientation : sides) {
            TileEntity acceptor = world.func_175625_s(pos.func_177972_a(orientation));
            if (!CapabilityUtils.hasCapability((ICapabilityProvider)acceptor, Capabilities.GAS_HANDLER_CAPABILITY, orientation.func_176734_d())) continue;
            acceptors[orientation.ordinal()] = CapabilityUtils.getCapability((ICapabilityProvider)acceptor, Capabilities.GAS_HANDLER_CAPABILITY, orientation.func_176734_d());
        }
        return acceptors;
    }

    public static IGasHandler[] getConnectedAcceptors(TileEntity tileEntity) {
        return GasTransmission.getConnectedAcceptors(tileEntity.func_174877_v(), tileEntity.func_145831_w(), Arrays.asList(EnumFacing.field_82609_l));
    }

    public static IGasHandler[] getConnectedAcceptors(BlockPos pos, World world) {
        return GasTransmission.getConnectedAcceptors(pos, world, Arrays.asList(EnumFacing.field_82609_l));
    }

    public static boolean isValidAcceptorOnSide(TileEntity tile, EnumFacing side) {
        ITubeConnection connection;
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        return CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.TUBE_CONNECTION_CAPABILITY, side.func_176734_d()) && (connection = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.TUBE_CONNECTION_CAPABILITY, side.func_176734_d())).canTubeConnect(side.func_176734_d());
    }

    public static GasStack removeGas(ItemStack itemStack, Gas type, int amount) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IGasItem) {
            IGasItem item = (IGasItem)itemStack.func_77973_b();
            if (type != null && item.getGas(itemStack) != null && item.getGas(itemStack).getGas() != type || !item.canProvideGas(itemStack, type)) {
                return null;
            }
            return item.removeGas(itemStack, amount);
        }
        return null;
    }

    public static int addGas(ItemStack itemStack, GasStack stack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof IGasItem && ((IGasItem)itemStack.func_77973_b()).canReceiveGas(itemStack, stack.getGas())) {
            return ((IGasItem)itemStack.func_77973_b()).addGas(itemStack, stack.copy());
        }
        return 0;
    }

    public static int emit(GasStack stack, TileEntity from, Collection<EnumFacing> sides) {
        int toSend;
        if (stack == null) {
            return 0;
        }
        ArrayList<IGasHandler> availableAcceptors = new ArrayList<IGasHandler>();
        IGasHandler[] possibleAcceptors = GasTransmission.getConnectedAcceptors(from, sides);
        for (int i = 0; i < possibleAcceptors.length; ++i) {
            IGasHandler handler = possibleAcceptors[i];
            if (handler == null || !handler.canReceiveGas(EnumFacing.func_82600_a((int)i).func_176734_d(), stack.getGas())) continue;
            availableAcceptors.add(handler);
        }
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            for (IGasHandler acceptor : availableAcceptors) {
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                EnumFacing dir = EnumFacing.func_82600_a((int)Arrays.asList(possibleAcceptors).indexOf(acceptor)).func_176734_d();
                toSend -= acceptor.receiveGas(dir, new GasStack(stack.getGas(), currentSending), true);
            }
        }
        return prevSending - toSend;
    }
}

