/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail;

import com.google.common.collect.Iterables;
import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketSyncStationNames;
import com.minemaarten.signals.rail.NetworkController;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.BlockEvent;

public class RailCacheManager {
    private static Map<Integer, RailCacheManager> INSTANCES = new HashMap<Integer, RailCacheManager>();
    private final Map<Long, Map<BlockPos, RailWrapper>> railCache = new HashMap<Long, Map<BlockPos, RailWrapper>>();
    private final Set<TileEntityStationMarker> stations = new HashSet<TileEntityStationMarker>();
    private String[] allStationNames = new String[0];

    public static RailCacheManager getInstance(World world) {
        if (world.field_72995_K) {
            Log.warning("Can't be called client side!");
            new Throwable().printStackTrace();
            return new RailCacheManager();
        }
        return RailCacheManager.getInstance(world.field_73011_w.getDimension());
    }

    public static RailCacheManager getInstance(int dimension) {
        RailCacheManager cache = INSTANCES.get(dimension);
        if (cache == null) {
            cache = new RailCacheManager();
            INSTANCES.put(dimension, cache);
        }
        return cache;
    }

    public RailWrapper getRail(World world, BlockPos pos) {
        return this.getRail(world, pos, true);
    }

    private RailWrapper getRail(World world, BlockPos pos, boolean shouldLoadRail) {
        RailWrapper rail;
        long chunkHash = this.getChunkHashFromBlockPos(pos);
        Map<BlockPos, RailWrapper> cache = this.railCache.get(chunkHash);
        if (cache != null && (rail = cache.get(pos)) != null) {
            return rail;
        }
        if (shouldLoadRail && (rail = new RailWrapper(world, pos)).isRail()) {
            if (cache == null) {
                cache = new HashMap<BlockPos, RailWrapper>();
                this.railCache.put(chunkHash, cache);
            }
            cache.put(pos, rail);
            for (RailWrapper neighbor : rail.getNeighbors().keySet()) {
                neighbor.updateNeighborCache();
            }
            NetworkController.getInstance(world).updateColor(rail, pos);
            return rail;
        }
        return null;
    }

    private long getChunkHashFromBlockPos(BlockPos pos) {
        return ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
    }

    public void onChunkLoad(Chunk chunk) {
        for (EnumFacing d : EnumFacing.field_176754_o) {
            ChunkPos intPair = chunk.func_76632_l();
            BlockPos offsetBlock = intPair.func_180331_a(0, 0, 0).func_177967_a(d, 16);
            if (!chunk.func_177412_p().func_175667_e(offsetBlock)) continue;
            Chunk neighbor = chunk.func_177412_p().func_72964_e(chunk.field_76635_g + d.func_82601_c(), chunk.field_76647_h + d.func_82599_e());
            Map<BlockPos, RailWrapper> chunkCache = this.railCache.get(ChunkPos.func_77272_a((int)neighbor.field_76635_g, (int)neighbor.field_76647_h));
            if (chunkCache == null) continue;
            if (d.func_176740_k() == EnumFacing.Axis.X) {
                int borderX = (d.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : 15) + offsetBlock.func_177958_n();
                for (RailWrapper rail : chunkCache.values()) {
                    if (rail.func_177958_n() != borderX) continue;
                    rail.updateNeighborCache();
                }
                continue;
            }
            int borderZ = (d.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : 15) + offsetBlock.func_177952_p();
            for (RailWrapper rail : chunkCache.values()) {
                if (rail.func_177952_p() != borderZ) continue;
                rail.updateNeighborCache();
            }
        }
    }

    public void onChunkUnload(Chunk chunk) {
        long chunkHash = ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
        Map<BlockPos, RailWrapper> cache = this.railCache.get(chunkHash);
        if (cache != null) {
            for (RailWrapper rail : cache.values()) {
                rail.invalidate();
            }
            this.railCache.remove(chunkHash);
        }
    }

    public void onWorldUnload(World world) {
        INSTANCES.remove(world.field_73011_w.getDimension());
    }

    public void onNeighborChanged(BlockEvent.NeighborNotifyEvent event) {
        RailWrapper rail;
        RailWrapper removedWrapper;
        Map<BlockPos, RailWrapper> cache = this.railCache.get(this.getChunkHashFromBlockPos(event.getPos()));
        if (cache != null && (removedWrapper = cache.remove(event.getPos())) != null) {
            removedWrapper.invalidate();
        }
        if ((rail = new RailWrapper(event.getWorld(), event.getPos(), event.getState())).isRail()) {
            for (EnumFacing d : EnumFacing.field_176754_o) {
                BlockPos neighborPos = event.getPos().func_177972_a(d);
                for (int i = -1; i <= 1; ++i) {
                    RailWrapper neighbor = this.getRail(event.getWorld(), neighborPos.func_177982_a(0, i, 0), false);
                    if (neighbor == null) continue;
                    neighbor.updateNeighborCache();
                }
            }
        }
    }

    public void addStationMarker(TileEntityStationMarker marker) {
        this.stations.add(marker);
        NetworkController.getInstance(marker.func_145831_w()).updateColor(marker, marker.func_174877_v());
    }

    public void removeStationMarker(TileEntityStationMarker marker) {
        this.stations.remove(marker);
        NetworkController.getInstance(marker.func_145831_w()).updateColor((TileEntityStationMarker)null, marker.func_174877_v());
    }

    public Collection<RailWrapper> getStationRails(EntityMinecart cart, Pattern destinationRegex) {
        HashSet<RailWrapper> rails = new HashSet<RailWrapper>();
        HashSet<String> validNames = new HashSet<String>();
        for (TileEntityStationMarker station : this.stations) {
            if (!station.isCartApplicable(cart, destinationRegex)) continue;
            rails.addAll(station.getNeighborRails());
            validNames.add(station.getStationName());
        }
        for (TileEntityStationMarker station : this.stations) {
            if (!validNames.contains(station.getStationName())) continue;
            rails.addAll(station.getNeighborRails());
        }
        return rails;
    }

    public Iterable<RailWrapper> getAllRails() {
        Iterable<RailWrapper> iterable = Collections.emptyList();
        for (Map<BlockPos, RailWrapper> map : this.railCache.values()) {
            iterable = Iterables.concat(iterable, map.values());
        }
        return iterable;
    }

    public static String[] getAllStationNames() {
        return RailCacheManager.getInstance((int)0).allStationNames;
    }

    public static void setAllStationNames(String[] stationNames) {
        RailCacheManager.getInstance((int)0).allStationNames = stationNames;
    }

    public static void syncStationNames(EntityPlayerMP player) {
        HashSet<String> stationNames = new HashSet<String>();
        stationNames.add("ITEM");
        for (RailCacheManager manager : INSTANCES.values()) {
            for (TileEntityStationMarker station : manager.stations) {
                if (station.getStationName().equals("")) continue;
                stationNames.add(station.getStationName());
            }
        }
        Object[] array = stationNames.toArray(new String[stationNames.size()]);
        Arrays.sort(array);
        NetworkHandler.sendTo(new PacketSyncStationNames((String[])array), player);
    }
}

