/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.minemaarten.signals.network.LocationIntPacket;
import com.minemaarten.signals.tileentity.IGUITextFieldSensitive;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateTextfield
extends LocationIntPacket<PacketUpdateTextfield> {
    private int textFieldID;
    private String text;

    public PacketUpdateTextfield() {
    }

    public PacketUpdateTextfield(TileEntity te, int textfieldID) {
        super(te.func_174877_v());
        this.textFieldID = textfieldID;
        this.text = ((IGUITextFieldSensitive)te).getText(textfieldID);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.textFieldID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.text);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.textFieldID = buffer.readInt();
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        TileEntity te = this.getTileEntity(player.func_130014_f_());
        if (te instanceof IGUITextFieldSensitive) {
            ((IGUITextFieldSensitive)te).setText(this.textFieldID, this.text);
        }
    }
}

