/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.loader;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import elec332.core.ElecCore;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IAPIHandler;
import elec332.core.api.annotations.StaticLoad;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.mod.IElecCoreMod;
import elec332.core.api.mod.IElecCoreModHandler;
import elec332.core.loader.ModuleManager;
import elec332.core.util.FMLUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

@StaticLoad
enum ElecModHandler implements IElecCoreModHandler
{
    INSTANCE;

    @APIHandlerInject(weight=32767)
    private IASMDataHelper asmData = null;
    private Map<Class<? extends Annotation>, Function<ModContainer, Object>> reg = Maps.newHashMap();
    private Set<BiConsumer<ModContainer, IElecCoreMod>> handlers = Sets.newHashSet();
    private List<Pair<ModContainer, IElecCoreMod>> mods;

    void afterConstruct() {
        this.identifyMods();
        this.initAnnotations(this.asmData.getASMDataTable());
        this.init(this.mods);
    }

    void latePreInit() {
        this.init(ModuleManager.INSTANCE.getActiveModules().stream().filter(mc -> mc.getModule() instanceof IElecCoreMod).map(moduleContainer -> Pair.of((Object)moduleContainer.getOwnerMod(), (Object)((IElecCoreMod)moduleContainer.getModule()))).collect(Collectors.toList()));
    }

    private void identifyMods() {
        this.mods = FMLUtil.getLoader().getActiveModList().stream().filter(o -> o.getMod() instanceof IElecCoreMod).sorted((o1, o2) -> o1.getMod() instanceof ElecCore ? 1 : (o2.getMod() instanceof ElecCore ? -1 : Integer.compare(o1.hashCode(), o2.hashCode()))).map(modContainer -> Pair.of((Object)modContainer, (Object)((IElecCoreMod)modContainer.getMod()))).collect(Collectors.toList());
    }

    private void init(List<Pair<ModContainer, IElecCoreMod>> mods) {
        mods.forEach(mod -> this.handlers.forEach(handler -> handler.accept(mod.getLeft(), mod.getRight())));
    }

    private void initAnnotations(ASMDataTable dataTable) {
        for (Map.Entry<Class<? extends Annotation>, Function<ModContainer, Object>> entry : this.reg.entrySet()) {
            for (ModContainer mc : FMLUtil.getLoader().getActiveModList()) {
                this.parseSimpleFieldAnnotation(mc, (SetMultimap<String, ASMDataTable.ASMData>)dataTable.getAnnotationsFor(mc), entry.getKey().getName(), entry.getValue());
            }
        }
    }

    private void parseSimpleFieldAnnotation(ModContainer mc_, SetMultimap<String, ASMDataTable.ASMData> annotations, String annotationClassName, Function<ModContainer, Object> retriever) {
        try {
            String[] annName = annotationClassName.split("\\.");
            String annotationName = annName[annName.length - 1];
            for (ASMDataTable.ASMData targets : annotations.get((Object)annotationClassName)) {
                String targetMod = (String)targets.getAnnotationInfo().get("value");
                Field f = null;
                Object injectedMod = null;
                Object mc = mc_;
                boolean isStatic = false;
                Class<?> clz = mc_.getMod().getClass();
                if (!Strings.isNullOrEmpty((String)targetMod)) {
                    mc = Loader.isModLoaded((String)targetMod) ? (ModContainer)Loader.instance().getIndexedModList().get(targetMod) : null;
                }
                if (mc != null) {
                    try {
                        clz = Class.forName(targets.getClassName(), true, (ClassLoader)Loader.instance().getModClassLoader());
                        f = clz.getDeclaredField(targets.getObjectName());
                        f.setAccessible(true);
                        isStatic = Modifier.isStatic(f.getModifiers());
                        injectedMod = retriever.apply((ModContainer)mc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Throwables.propagateIfPossible((Throwable)e);
                        FMLLog.log((String)mc_.getModId(), (Level)Level.WARN, (Throwable)e, (String)"Attempting to load @%s in class %s for %s and failing", (Object[])new Object[]{annotationName, targets.getClassName(), mc.getModId()});
                    }
                }
                if (f == null) continue;
                Object target = null;
                if (!isStatic && !(target = mc_.getMod()).getClass().equals(clz)) {
                    FMLLog.log((String)mc_.getModId(), (Level)Level.WARN, (String)"Unable to inject @%s in non-static field %s.%s for %s as it is NOT the primary mod instance", (Object[])new Object[]{annotationName, targets.getClassName(), targets.getObjectName(), mc.getModId()});
                    continue;
                }
                f.set(target, injectedMod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void registerSimpleFieldHandler(Class<? extends Annotation> annotation, Function<ModContainer, Object> func) {
        this.reg.put(annotation, func);
    }

    @Override
    public void registerModHandler(BiConsumer<ModContainer, IElecCoreMod> handler) {
        this.handlers.add(handler);
    }

    @APIHandlerInject(weight=32767)
    public void injectModHandler(IAPIHandler apiHandler) {
        apiHandler.inject(INSTANCE, IElecCoreModHandler.class);
    }
}

