/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import com.google.common.base.Predicate;
import forestry.api.apiculture.hives.IHiveGen;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenHiveNether
implements IHiveGen {
    private boolean embedInWall(World world, Block blockID, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != blockID) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing.func_176740_k() == EnumFacing.Axis.Y && world.func_180495_p(pos.func_177984_a()).func_177230_c() != blockID) {
                return false;
            }
            if (!world.func_175623_d(pos.func_177972_a(facing))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public BlockPos getPosForHive(World world, int x, int z) {
        Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return null;
        }
        int maxHeight = world.func_72800_K();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(new BlockPos(x, maxHeight, z));
        for (int i = 0; i < 10; ++i) {
            pos.func_185336_p(world.field_73012_v.nextInt(maxHeight));
            if (!this.isValidLocation(world, (BlockPos)pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean isValidLocation(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block.isReplaceableOreGen(blockState, (IBlockAccess)world, pos, (Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150424_aL))) {
            return this.embedInWall(world, Blocks.field_150424_aL, pos);
        }
        return false;
    }

    public boolean canReplace(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        return block.isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150424_aL));
    }
}

