/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.recipes.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockBasic;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SemiBlockHeatFrame
extends SemiBlockBasic<TileEntity>
implements IHeatExchanger {
    public static final String ID = "heat_frame";
    private final IHeatExchangerLogic logic = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    private int lastValidSlot;
    private int cookingProgress;
    private int coolingProgress;
    @DescSynced
    private int heatLevel = 10;

    public SemiBlockHeatFrame(Class<TileEntity> tileClass) {
        super(tileClass);
    }

    public SemiBlockHeatFrame() {
        super(TileEntity.class);
    }

    @Override
    public boolean canPlace(EnumFacing facing) {
        return this.getTileEntity() != null && this.getTileEntity().hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public int getHeatLevel() {
        return this.heatLevel;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.heatLevel = HeatUtil.getHeatLevelForTemperature(this.logic.getTemperature());
            if (this.logic.getTemperature() > 374.0) {
                IItemHandler handler;
                if (this.cookingProgress < 100) {
                    int progress = Math.max(0, ((int)this.logic.getTemperature() - 343) / 30);
                    progress = Math.min(5, progress);
                    this.logic.addHeat(-progress);
                    this.cookingProgress += progress;
                }
                if (this.cookingProgress >= 100 && (handler = IOHelper.getInventoryForTE(this.getTileEntity())) != null) {
                    if (!this.tryCookSlot(handler, this.lastValidSlot)) {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            if (!this.tryCookSlot(handler, i)) continue;
                            this.cookingProgress -= 100;
                            break;
                        }
                    } else {
                        this.cookingProgress -= 100;
                    }
                }
            } else if (this.logic.getTemperature() < 273.0) {
                IItemHandler handler;
                if (this.coolingProgress < 100) {
                    int progress = Math.max(0, ((int)this.logic.getTemperature() - 243) / 30);
                    progress = 6 - Math.min(5, progress);
                    this.logic.addHeat(progress);
                    this.coolingProgress += progress;
                }
                if (this.coolingProgress >= 100 && (handler = IOHelper.getInventoryForTE(this.getTileEntity())) != null) {
                    if (!this.tryCoolSlot(handler, this.lastValidSlot)) {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            if (!this.tryCoolSlot(handler, i)) continue;
                            this.coolingProgress -= 100;
                            break;
                        }
                    } else {
                        this.coolingProgress -= 100;
                    }
                }
            }
        }
    }

    private boolean tryCookSlot(IItemHandler handler, int slot) {
        ItemStack remainder;
        ItemStack result;
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.func_190926_b() && !(result = FurnaceRecipes.func_77602_a().func_151395_a(stack)).func_190926_b() && (remainder = IOHelper.insert(this.getTileEntity(), result, true)).func_190926_b()) {
            IOHelper.insert(this.getTileEntity(), result, false);
            handler.extractItem(slot, 1, false);
            this.lastValidSlot = slot;
            return true;
        }
        return false;
    }

    private boolean tryCoolSlot(IItemHandler handler, int slot) {
        ItemStack stack = handler.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            for (HeatFrameCoolingRecipe recipe : HeatFrameCoolingRecipe.recipes) {
                if (!recipe.input.isItemEqual(stack) || stack.func_190916_E() < recipe.input.getItemAmount()) continue;
                ItemStack containerItem = stack.func_77973_b().getContainerItem(stack);
                boolean canStoreContainerItem = false;
                boolean canStoreOutput = false;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack s = handler.getStackInSlot(i);
                    if (s.func_190926_b()) {
                        if (canStoreOutput) {
                            canStoreContainerItem = true;
                            continue;
                        }
                        canStoreOutput = true;
                        continue;
                    }
                    if (s.func_77969_a(recipe.output) && ItemStack.func_77970_a((ItemStack)s, (ItemStack)recipe.output) && s.func_77976_d() >= s.func_190916_E() + recipe.output.func_190916_E()) {
                        canStoreOutput = true;
                    }
                    if (containerItem.func_190926_b() || !s.func_77969_a(containerItem) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)containerItem) || s.func_77976_d() < s.func_190916_E() + containerItem.func_190916_E()) continue;
                    canStoreContainerItem = true;
                }
                if (!canStoreOutput || !containerItem.func_190926_b() && !canStoreContainerItem) continue;
                handler.extractItem(slot, 1, false);
                IOHelper.insert(this.getTileEntity(), recipe.output.func_77946_l(), false);
                if (!containerItem.func_190926_b()) {
                    IOHelper.insert(this.getTileEntity(), containerItem.func_77946_l(), false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.logic.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.logic.readFromNBT(tag);
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack, EnumFacing facing) {
        super.onPlaced(player, stack, facing);
        this.getWorld().func_175685_c(this.getPos(), this.getBlockState().func_177230_c(), true);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.logic;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getWorld().func_175685_c(this.getPos(), this.getBlockState().func_177230_c(), true);
    }

    @Override
    public void addWailaInfoToTag(NBTTagCompound tag) {
        super.addWailaInfoToTag(tag);
        tag.func_74768_a("temp", (int)this.logic.getTemperature());
    }

    @Override
    public void addWailaTooltip(List<String> curInfo, NBTTagCompound tag, boolean extended) {
        super.addWailaTooltip(curInfo, tag, extended);
        int temp = tag.func_74764_b("temp") ? tag.func_74762_e("temp") : (int)this.logic.getTemperature();
        curInfo.add(I18n.func_135052_a((String)"waila.temperature", (Object[])new Object[]{temp - 273}));
    }
}

