/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPressurizable
extends ItemPneumatic
implements IPressurizable {
    private final int volume;
    private final float maxPressure;

    public ItemPressurizable(String registryName, int maxAir, int volume) {
        super(registryName);
        this.func_77625_d(1);
        this.func_77656_e(maxAir);
        this.volume = volume;
        this.maxPressure = maxAir / volume;
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> par3List) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            ItemStack stack2 = new ItemStack((Item)this, 1, stack.func_77958_k());
            par3List.add((Object)stack);
            par3List.add((Object)stack2);
        }
    }

    @Override
    public float getPressure(ItemStack iStack) {
        return (float)(iStack.func_77958_k() - iStack.func_77952_i()) / (float)this.volume;
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        iStack.func_77964_b(iStack.func_77952_i() - amount);
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return this.maxPressure;
    }

    @Override
    public int getVolume(ItemStack itemStack) {
        return this.volume;
    }

    static void addPressureTooltip(ItemStack stack, List<String> textList) {
        IPressurizable p = IPressurizable.of(stack);
        if (p != null) {
            float f = p.getPressure(stack) / p.maxPressure(stack);
            TextFormatting color = f < 0.1f ? TextFormatting.RED : (f < 0.5f ? TextFormatting.GOLD : TextFormatting.DARK_GREEN);
            textList.add(color + I18n.func_135052_a((String)"gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(p.getPressure(stack), 1)}));
        }
    }
}

