/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.IKeyListener;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.LauncherTracker;
import me.desht.pneumaticcraft.client.gui.GuiUtils;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiHelmetMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.GuiKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.HackUpgradeRenderHandler;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPneumaticKick;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HUDHandler
implements IKeyListener {
    private static final int PROGRESS_BAR_HEIGHT = 17;
    private long lastArmorInitSound;
    private final List<ArmorMessage> messageList = new ArrayList<ArmorMessage>();
    private final boolean[] gaveEmptyWarning = new boolean[4];
    private final boolean[] gaveNearlyEmptyWarning = new boolean[4];
    private static final HUDHandler INSTANCE = new HUDHandler();

    public static HUDHandler instance() {
        return INSTANCE;
    }

    public <T extends IUpgradeRenderHandler> T getSpecificRenderer(Class<T> clazz) {
        return UpgradeRenderHandlerList.instance().getRenderHandler(clazz);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (!GuiKeybindCheckBox.getCoreComponents().checked) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        ItemStack helmetStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        CommonHUDHandler comHudHandler = CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player);
        if (helmetStack.func_77973_b() instanceof ItemPneumaticArmor && comHudHandler.getArmorPressure(EntityEquipmentSlot.HEAD) > 0.0f) {
            for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                if (!comHudHandler.isArmorReady(slot)) continue;
                GlStateManager.func_179090_x();
                List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
                for (int i = 0; i < renderHandlers.size(); ++i) {
                    if (!comHudHandler.isUpgradeRendererInserted(slot, i) || !GuiKeybindCheckBox.fromKeyBindingName((String)new StringBuilder().append((String)"pneumaticHelmet.upgrade.").append((String)renderHandlers.get((int)i).getUpgradeName()).toString()).checked) continue;
                    renderHandlers.get(i).render3D(event.getPartialTicks());
                }
                GlStateManager.func_179098_w();
            }
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc;
        if (event.phase == TickEvent.Phase.END && (mc = FMLClientHandler.instance().getClient()) != null && mc.field_71439_g != null) {
            this.render2D(event.renderTickTime);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            EntityPlayer player = event.player;
            if (player == mc.field_71439_g && player.field_70170_p.field_72995_K) {
                boolean armorEquipped = false;
                for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                    if (!(player.func_184582_a(slot).func_77973_b() instanceof ItemPneumaticArmor)) continue;
                    this.update((EntityPlayer)mc.field_71439_g, slot);
                    armorEquipped = true;
                }
                if (armorEquipped) {
                    this.messageList.forEach(message -> message.getStat().update());
                    this.messageList.removeIf(message -> message == null || --message.lifeSpan <= 0);
                } else {
                    this.messageList.clear();
                }
                if (LauncherTracker.INSTANCE.getLauncherProgress() > 0) {
                    if (!KeyHandler.getInstance().keybindLauncher.func_151470_d()) {
                        LauncherTracker.INSTANCE.trigger();
                    } else {
                        LauncherTracker.INSTANCE.chargeLauncher();
                    }
                }
            }
        }
    }

    private void render2D(float partialTicks) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        if (mc.field_71415_G && ItemPneumaticArmor.isPlayerWearingAnyPneumaticArmor((EntityPlayer)player)) {
            ItemStack armorStack;
            ScaledResolution sr = new ScaledResolution(mc);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179129_p();
            GlStateManager.func_179090_x();
            GlStateManager.func_179094_E();
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.8f);
            CommonHUDHandler comHudHandler = CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player);
            boolean anyArmorInInit = false;
            for (Object slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                armorStack = player.func_184582_a(slot);
                if (!(armorStack.func_77973_b() instanceof ItemPneumaticArmor) || comHudHandler.isArmorReady((EntityEquipmentSlot)slot)) continue;
                anyArmorInInit = true;
                break;
            }
            for (Object slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                armorStack = player.func_184582_a(slot);
                if (!(armorStack.func_77973_b() instanceof ItemPneumaticArmor) || comHudHandler.getArmorPressure((EntityEquipmentSlot)slot) < 1.0E-4f) continue;
                if (anyArmorInInit) {
                    this.gaveEmptyWarning[slot.func_188454_b()] = false;
                    this.gaveNearlyEmptyWarning[slot.func_188454_b()] = false;
                    if (comHudHandler.isArmorEnabled()) {
                        int xLeft = sr.func_78326_a() / 2;
                        int yOffset = 10 + (3 - slot.func_188454_b()) * 17;
                        float progress = (float)comHudHandler.getTicksSinceEquipped((EntityEquipmentSlot)slot) * 100.0f / (float)comHudHandler.getStartupTime((EntityEquipmentSlot)slot);
                        progress = Math.min(100.0f, progress + partialTicks);
                        RenderProgressBar.render(sr.func_78327_c() / 2.0, yOffset, sr.func_78326_a() - 10, yOffset + 17 - 1, -90.0, progress, -1426079744, -1442775296);
                        GlStateManager.func_179098_w();
                        GuiUtils.drawItemStack(armorStack, xLeft + 2, yOffset);
                    }
                }
                if (!comHudHandler.isArmorReady((EntityEquipmentSlot)slot)) continue;
                String itemName = armorStack.func_82833_r();
                float pressure = comHudHandler.armorPressure[slot.func_188454_b()];
                if (pressure < 0.05f && !this.gaveEmptyWarning[slot.func_188454_b()]) {
                    this.addMessage(new ArmorMessage("Your " + itemName + " is out of air!", new ArrayList<String>(), 100, 0x70FF0000));
                    this.gaveEmptyWarning[slot.func_188454_b()] = true;
                }
                if (pressure > 0.2f && pressure < 0.5f && !this.gaveNearlyEmptyWarning[slot.func_188454_b()]) {
                    this.addMessage(new ArmorMessage("Your " + itemName + " is almost out of air!", new ArrayList<String>(), 60, 1895792640));
                    this.gaveNearlyEmptyWarning[slot.func_188454_b()] = true;
                }
                if (!GuiKeybindCheckBox.getCoreComponents().checked) continue;
                List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot((EntityEquipmentSlot)slot);
                for (int i = 0; i < renderHandlers.size(); ++i) {
                    IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                    if (!comHudHandler.isUpgradeRendererInserted((EntityEquipmentSlot)slot, i) || !comHudHandler.isUpgradeRendererEnabled((EntityEquipmentSlot)slot, i)) continue;
                    IGuiAnimatedStat stat = upgradeRenderHandler.getAnimatedStat();
                    if (stat != null) {
                        stat.render(-1, -1, partialTicks);
                    }
                    upgradeRenderHandler.render2D(partialTicks, pressure > 0.0f);
                }
            }
            if (LauncherTracker.INSTANCE.getLauncherProgress() > 0) {
                LauncherTracker.INSTANCE.render(sr, partialTicks);
            }
            for (ArmorMessage message : this.messageList) {
                message.renderMessage(mc.field_71466_p, partialTicks);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            if (comHudHandler.isArmorEnabled() && anyArmorInInit) {
                for (Object slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                    if (!(player.func_184582_a(slot).func_77973_b() instanceof ItemPneumaticArmor) || !(comHudHandler.getArmorPressure((EntityEquipmentSlot)slot) > 0.0f)) continue;
                    String text = Math.min(100, comHudHandler.getTicksSinceEquipped((EntityEquipmentSlot)slot) * 100 / comHudHandler.getStartupTime((EntityEquipmentSlot)slot)) + "%";
                    mc.field_71466_p.func_175063_a(text, (float)sr.func_78326_a() * 0.75f - 8.0f, (float)(14 + 17 * (3 - slot.func_188454_b())), 0xFFFF40);
                }
            }
        }
    }

    private void update(EntityPlayer player, EntityEquipmentSlot slot) {
        int i;
        CommonHUDHandler comHudHandler = CommonHUDHandler.getHandlerForPlayer(player);
        boolean armorEnabled = GuiKeybindCheckBox.getCoreComponents().checked;
        List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
        if (comHudHandler.getTicksSinceEquipped(slot) == 0) {
            for (IUpgradeRenderHandler handler : UpgradeRenderHandlerList.instance().getHandlersForSlot(slot)) {
                handler.reset();
            }
            for (i = 0; i < renderHandlers.size(); ++i) {
                boolean state = armorEnabled && GuiKeybindCheckBox.fromKeyBindingName((String)new StringBuilder().append((String)"pneumaticHelmet.upgrade.").append((String)renderHandlers.get((int)i).getUpgradeName()).toString()).checked;
                comHudHandler.setUpgradeRenderEnabled(slot, (byte)i, state);
                NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, state, slot));
            }
        }
        if (slot == EntityEquipmentSlot.HEAD && comHudHandler.getTicksSinceEquipped(slot) > comHudHandler.getStartupTime(slot) && armorEnabled) {
            for (i = 0; i < renderHandlers.size(); ++i) {
                IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                if (!comHudHandler.isUpgradeRendererInserted(slot, i) || !GuiKeybindCheckBox.fromKeyBindingName((String)new StringBuilder().append((String)"pneumaticHelmet.upgrade.").append((String)upgradeRenderHandler.getUpgradeName()).toString()).checked) continue;
                IGuiAnimatedStat stat = upgradeRenderHandler.getAnimatedStat();
                if (stat != null) {
                    if (comHudHandler.armorPressure[slot.func_188454_b()] > upgradeRenderHandler.getMinimumPressure()) {
                        stat.openWindow();
                    } else {
                        stat.closeWindow();
                    }
                    stat.update();
                }
                upgradeRenderHandler.update(player, comHudHandler.getUpgradeCount(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.RANGE));
            }
        }
        for (i = 0; i < renderHandlers.size(); ++i) {
            if (comHudHandler.getTicksSinceEquipped(slot) != comHudHandler.getStartupTime(slot) / (renderHandlers.size() + 2) * (i + 1)) continue;
            this.playArmorInitSound(player, Sounds.HUD_INIT, 0.5f + (float)(i + 1) / (float)(renderHandlers.size() + 2) * 0.5f);
            boolean upgradeEnabled = comHudHandler.isUpgradeRendererInserted(slot, i);
            this.addMessage(new ArmorMessage(I18n.func_135052_a((String)("pneumaticHelmet.upgrade." + renderHandlers.get(i).getUpgradeName()), (Object[])new Object[0]) + (upgradeEnabled ? " installed" : " not installed"), new ArrayList<String>(), 80, upgradeEnabled ? 0x7000AA00 : 1895792640));
        }
        ItemStack stack = player.func_184582_a(slot);
        if (comHudHandler.getTicksSinceEquipped(slot) == 1) {
            this.playArmorInitSound(player, Sounds.HUD_INIT, 0.5f);
            this.addMessage(new ArmorMessage("Initializing " + stack.func_82833_r() + "...", Collections.emptyList(), 50, 0x7000AA00));
        }
        if (comHudHandler.getTicksSinceEquipped(slot) == comHudHandler.getStartupTime(slot)) {
            this.playArmorInitSound(player, Sounds.HUD_INIT_COMPLETE, 1.0f);
            this.addMessage(new ArmorMessage(stack.func_82833_r() + " initialization complete!", Collections.emptyList(), 50, 0x7000AA00));
        }
    }

    private void playArmorInitSound(EntityPlayer player, SoundEvent sound, float pitch) {
        long when = player.field_70170_p.func_82737_E();
        if (when - this.lastArmorInitSound >= 30L) {
            player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, SoundCategory.PLAYERS, 0.2f, pitch, true);
        }
        this.lastArmorInitSound = when;
    }

    public void addFeatureToggleMessage(String key, boolean enabled) {
        HUDHandler.instance().addMessage(I18n.func_135052_a((String)("pneumaticHelmet.message." + (enabled ? "enable" : "disable") + "Setting"), (Object[])new Object[]{I18n.func_135052_a((String)key, (Object[])new Object[0])}), new ArrayList<String>(), 60, 0x7000AA00);
    }

    public void addFeatureToggleMessage(IUpgradeRenderHandler handler, String key, boolean enabled) {
        String msg = I18n.func_135052_a((String)("pneumaticHelmet.upgrade." + handler.getUpgradeName()), (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)key, (Object[])new Object[0]);
        HUDHandler.instance().addMessage(I18n.func_135052_a((String)("pneumaticHelmet.message." + (enabled ? "enable" : "disable") + "Setting"), (Object[])new Object[]{msg}), new ArrayList<String>(), 60, 0x7000AA00);
    }

    public void addMessage(String title, List<String> message, int duration, int backColor) {
        this.addMessage(new ArmorMessage(title, message, duration, backColor));
    }

    public void addMessage(ArmorMessage message) {
        if (this.messageList.size() > 0) {
            message.setDependingMessage(this.messageList.get(this.messageList.size() - 1).getStat());
        }
        this.messageList.add(message);
    }

    @Override
    public void onKeyPress(KeyBinding key) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71415_G) {
            if (key == KeyHandler.getInstance().keybindOpenOptions) {
                if (ItemPneumaticArmor.isPlayerWearingAnyPneumaticArmor((EntityPlayer)mc.field_71439_g)) {
                    FMLCommonHandler.instance().showGuiScreen((Object)GuiHelmetMainScreen.getInstance());
                }
            } else if (key == KeyHandler.getInstance().keybindHack && HackUpgradeRenderHandler.enabledForPlayer((EntityPlayer)mc.field_71439_g)) {
                this.getSpecificRenderer(BlockTrackUpgradeHandler.class).hack();
                this.getSpecificRenderer(EntityTrackUpgradeHandler.class).hack();
            } else if (key == KeyHandler.getInstance().keybindDebuggingDrone && DroneDebugUpgradeHandler.enabledForPlayer(PneumaticCraftRepressurized.proxy.getClientPlayer())) {
                this.getSpecificRenderer(EntityTrackUpgradeHandler.class).selectAsDebuggingTarget();
            } else if (key == KeyHandler.getInstance().keybindKick && CommonHUDHandler.getHandlerForPlayer().getUpgradeCount(EntityEquipmentSlot.FEET, IItemRegistry.EnumUpgrade.DISPENSER) > 0) {
                NetworkHandler.sendToServer(new PacketPneumaticKick());
            } else if (key == KeyHandler.getInstance().keybindLauncher && !mc.field_71439_g.func_184592_cb().func_190926_b() && LauncherTracker.INSTANCE.isPlayerOKToLaunch()) {
                LauncherTracker.INSTANCE.startCharging();
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        boolean isCaptured = this.getSpecificRenderer(BlockTrackUpgradeHandler.class).scroll(event);
        if (!isCaptured) {
            isCaptured = this.getSpecificRenderer(EntityTrackUpgradeHandler.class).scroll(event);
        }
        if (isCaptured) {
            event.setCanceled(true);
        }
    }
}

