/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CamoModel
implements IBakedModel {
    private final IBakedModel originalModel;

    public CamoModel(IBakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null || !(state.func_177230_c() instanceof BlockPneumaticCraftCamo)) {
            return this.originalModel.func_188616_a(state, side, rand);
        }
        IExtendedBlockState ext = (IExtendedBlockState)state;
        IBlockState camoState = (IBlockState)ext.getValue(BlockPneumaticCraftCamo.CAMO_STATE);
        IBlockAccess blockAccess = (IBlockAccess)ext.getValue(BlockPneumaticCraftCamo.BLOCK_ACCESS);
        BlockPos pos = (BlockPos)ext.getValue(BlockPneumaticCraftCamo.BLOCK_POS);
        if (blockAccess == null || pos == null) {
            return this.originalModel.func_188616_a(state, side, rand);
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            layer = BlockRenderLayer.SOLID;
        }
        if (camoState == null && layer == BlockRenderLayer.SOLID) {
            return this.originalModel.func_188616_a(state, side, rand);
        }
        if (camoState != null && camoState.func_177230_c().canRenderInLayer(camoState, layer)) {
            IBlockState actual = camoState.func_185899_b((IBlockAccess)new FakeBlockAccess(blockAccess), pos);
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(actual);
            IBlockState extended = camoState.func_177230_c().getExtendedState(actual, (IBlockAccess)new FakeBlockAccess(blockAccess), pos);
            return model.func_188616_a(extended, side, rand);
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return this.originalModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.originalModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.originalModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.originalModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.originalModel.func_188617_f();
    }

    private static class FakeBlockAccess
    implements IBlockAccess {
        private final IBlockAccess compose;

        private FakeBlockAccess(IBlockAccess compose) {
            this.compose = compose;
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return this.compose.func_175625_s(pos);
        }

        public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            TileEntity te;
            IBlockState state = this.compose.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockPneumaticCraftCamo && (te = this.compose.func_175625_s(pos)) instanceof ICamouflageableTE) {
                state = ((ICamouflageableTE)te).getCamouflage();
            }
            return state == null ? Blocks.field_150350_a.func_176223_P() : state;
        }

        public boolean func_175623_d(@Nonnull BlockPos pos) {
            return this.compose.func_175623_d(pos);
        }

        @Nonnull
        public Biome func_180494_b(@Nonnull BlockPos pos) {
            return this.compose.func_180494_b(pos);
        }

        public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            return this.compose.func_175627_a(pos, direction);
        }

        public WorldType func_175624_G() {
            return this.compose.func_175624_G();
        }

        public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
            return this.compose.isSideSolid(pos, side, _default);
        }
    }
}

