/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.SoundTools;
import mcjty.meecreeps.actions.MeeCreepActionType;
import mcjty.meecreeps.actions.PacketActionOptionToClient;
import mcjty.meecreeps.actions.PacketShowBalloonToClient;
import mcjty.meecreeps.actions.Stage;
import mcjty.meecreeps.api.IActionContext;
import mcjty.meecreeps.config.Config;
import mcjty.meecreeps.entities.EntityMeeCreeps;
import mcjty.meecreeps.network.MeeCreepsMessages;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class ActionOptions
implements IActionContext {
    private final List<MeeCreepActionType> actionOptions;
    private final List<MeeCreepActionType> maybeActionOptions;
    private final BlockPos targetPos;
    private final EnumFacing targetSide;
    private int dimension;
    private int failureCount;
    @Nullable
    private final UUID playerId;
    private final int actionId;
    private int timeout;
    private Stage stage;
    private MeeCreepActionType task;
    private String furtherQuestionId;
    private boolean paused;
    private List<Pair<BlockPos, ItemStack>> drops = new ArrayList<Pair<BlockPos, ItemStack>>();

    public ActionOptions(List<MeeCreepActionType> actionOptions, List<MeeCreepActionType> maybeActionOptions, BlockPos targetPos, EnumFacing targetSide, int dimension, @Nullable UUID playerId, int actionId) {
        this.actionOptions = actionOptions;
        this.maybeActionOptions = maybeActionOptions;
        this.targetPos = targetPos;
        this.targetSide = targetSide;
        this.dimension = dimension;
        this.failureCount = 60;
        this.playerId = playerId;
        this.actionId = actionId;
        this.timeout = 10;
        this.stage = Stage.WAITING_FOR_SPAWN;
        this.task = null;
        this.furtherQuestionId = null;
        this.paused = false;
    }

    public ActionOptions(ByteBuf buf) {
        int size;
        this.actionOptions = new ArrayList<MeeCreepActionType>();
        for (size = buf.readInt(); size > 0; --size) {
            this.actionOptions.add(new MeeCreepActionType(NetworkTools.readStringUTF8((ByteBuf)buf)));
        }
        this.maybeActionOptions = new ArrayList<MeeCreepActionType>();
        for (size = buf.readInt(); size > 0; --size) {
            this.maybeActionOptions.add(new MeeCreepActionType(NetworkTools.readStringUTF8((ByteBuf)buf)));
        }
        this.targetPos = NetworkTools.readPos((ByteBuf)buf);
        this.targetSide = EnumFacing.field_82609_l[buf.readByte()];
        this.dimension = buf.readInt();
        this.failureCount = buf.readInt();
        this.playerId = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
        this.actionId = buf.readInt();
        this.timeout = buf.readInt();
        this.stage = Stage.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.task = new MeeCreepActionType(NetworkTools.readStringUTF8((ByteBuf)buf));
        }
        this.furtherQuestionId = NetworkTools.readStringUTF8((ByteBuf)buf);
        this.paused = buf.readBoolean();
    }

    public ActionOptions(NBTTagCompound tagCompound) {
        int i;
        NBTTagList list = tagCompound.func_150295_c("options", 8);
        this.actionOptions = new ArrayList<MeeCreepActionType>();
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.actionOptions.add(new MeeCreepActionType(list.func_150307_f(i)));
        }
        list = tagCompound.func_150295_c("maybe", 8);
        this.maybeActionOptions = new ArrayList<MeeCreepActionType>();
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.maybeActionOptions.add(new MeeCreepActionType(list.func_150307_f(i)));
        }
        list = tagCompound.func_150295_c("drops", 10);
        this.drops = new ArrayList<Pair<BlockPos, ItemStack>>();
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            BlockPos p = BlockPos.func_177969_a((long)tc.func_74763_f("p"));
            NBTTagCompound itemTag = tc.func_74775_l("i");
            ItemStack stack = new ItemStack(itemTag);
            this.drops.add((Pair<BlockPos, ItemStack>)Pair.of((Object)p, (Object)stack));
        }
        this.dimension = tagCompound.func_74762_e("dim");
        this.failureCount = tagCompound.func_74762_e("failure");
        this.targetPos = BlockPos.func_177969_a((long)tagCompound.func_74763_f("pos"));
        this.targetSide = EnumFacing.field_82609_l[tagCompound.func_74771_c("targetSide")];
        this.playerId = tagCompound.func_186855_b("player") ? tagCompound.func_186857_a("player") : null;
        this.actionId = tagCompound.func_74762_e("actionId");
        this.timeout = tagCompound.func_74762_e("timeout");
        this.stage = Stage.getByCode(tagCompound.func_74779_i("stage"));
        if (tagCompound.func_74764_b("task")) {
            this.task = new MeeCreepActionType(tagCompound.func_74779_i("task"));
        }
        this.furtherQuestionId = tagCompound.func_74764_b("fqid") ? tagCompound.func_74779_i("fqid") : null;
        this.paused = tagCompound.func_74767_n("paused");
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.actionOptions.size());
        for (MeeCreepActionType option : this.actionOptions) {
            NetworkTools.writeStringUTF8((ByteBuf)buf, (String)option.getId());
        }
        buf.writeInt(this.maybeActionOptions.size());
        for (MeeCreepActionType option : this.maybeActionOptions) {
            NetworkTools.writeStringUTF8((ByteBuf)buf, (String)option.getId());
        }
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.targetPos);
        buf.writeByte(this.targetSide.ordinal());
        buf.writeInt(this.dimension);
        buf.writeInt(this.failureCount);
        if (this.playerId != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.playerId.getMostSignificantBits());
            buf.writeLong(this.playerId.getLeastSignificantBits());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.actionId);
        buf.writeInt(this.timeout);
        buf.writeByte(this.stage.ordinal());
        if (this.task != null) {
            buf.writeBoolean(true);
            NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.task.getId());
        } else {
            buf.writeBoolean(false);
        }
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.furtherQuestionId);
        buf.writeBoolean(this.paused);
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList list = new NBTTagList();
        for (MeeCreepActionType meeCreepActionType : this.actionOptions) {
            list.func_74742_a((NBTBase)new NBTTagString(meeCreepActionType.getId()));
        }
        tagCompound.func_74782_a("options", (NBTBase)list);
        list = new NBTTagList();
        for (MeeCreepActionType meeCreepActionType : this.maybeActionOptions) {
            list.func_74742_a((NBTBase)new NBTTagString(meeCreepActionType.getId()));
        }
        tagCompound.func_74782_a("maybe", (NBTBase)list);
        list = new NBTTagList();
        for (Pair pair : this.drops) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74772_a("p", ((BlockPos)pair.getKey()).func_177986_g());
            tc.func_74782_a("i", (NBTBase)((ItemStack)pair.getValue()).func_77955_b(new NBTTagCompound()));
            list.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("drops", (NBTBase)list);
        tagCompound.func_74768_a("dim", this.dimension);
        tagCompound.func_74768_a("failure", this.failureCount);
        tagCompound.func_74772_a("pos", this.targetPos.func_177986_g());
        tagCompound.func_74774_a("targetSide", (byte)this.targetSide.ordinal());
        if (this.playerId != null) {
            tagCompound.func_186854_a("player", this.playerId);
        }
        tagCompound.func_74768_a("actionId", this.actionId);
        tagCompound.func_74768_a("timeout", this.timeout);
        tagCompound.func_74778_a("stage", this.stage.getCode());
        if (this.task != null) {
            tagCompound.func_74778_a("task", this.task.getId());
        }
        if (this.furtherQuestionId != null) {
            tagCompound.func_74778_a("fqid", this.furtherQuestionId);
        }
        tagCompound.func_74757_a("paused", this.paused);
    }

    public void registerDrops(BlockPos pos, @Nonnull List<ItemStack> drops) {
        for (ItemStack drop : drops) {
            if (drop.func_190926_b()) continue;
            this.drops.add((Pair<BlockPos, ItemStack>)Pair.of((Object)pos, (Object)drop.func_77946_l()));
        }
    }

    public List<Pair<BlockPos, ItemStack>> getDrops() {
        return this.drops;
    }

    public void clearDrops() {
        this.drops.clear();
    }

    public List<MeeCreepActionType> getActionOptions() {
        return this.actionOptions;
    }

    public List<MeeCreepActionType> getMaybeActionOptions() {
        return this.maybeActionOptions;
    }

    @Override
    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    @Override
    public EnumFacing getTargetSide() {
        return this.targetSide;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public int getActionId() {
        return this.actionId;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
        this.timeout = stage.getTimeout();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public MeeCreepActionType getTask() {
        return this.task;
    }

    @Override
    @Nullable
    public String getFurtherQuestionId() {
        return this.furtherQuestionId;
    }

    public void setTask(MeeCreepActionType task, @Nullable String furtherQuestionId) {
        this.task = task;
        this.furtherQuestionId = furtherQuestionId;
    }

    public boolean tick(World world) {
        if (this.paused) {
            return true;
        }
        --this.timeout;
        if (this.timeout <= 0) {
            this.timeout = 20;
            switch (this.stage) {
                case WAITING_FOR_SPAWN: {
                    if (ActionOptions.spawn(world, this.getTargetPos(), this.getTargetSide(), this.getActionId(), true)) {
                        this.setStage(Stage.OPENING_GUI);
                        break;
                    }
                    EntityPlayer player = this.getPlayer();
                    if (player != null) {
                        MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.cant_spawn_meecreep", new String[0]), (EntityPlayerMP)player);
                    }
                    return false;
                }
                case OPENING_GUI: {
                    if (!this.openGui()) {
                        return false;
                    }
                    this.setStage(Stage.WAITING_FOR_PLAYER_INPUT);
                    break;
                }
                case WAITING_FOR_PLAYER_INPUT: {
                    EntityPlayerMP player;
                    MinecraftServer server = DimensionManager.getWorld((int)0).func_73046_m();
                    EntityPlayerMP entityPlayerMP = player = this.playerId == null ? null : server.func_184103_al().func_177451_a(this.playerId);
                    if (player != null) break;
                    return false;
                }
                case WORKING: {
                    this.setStage(Stage.TIME_IS_UP);
                    break;
                }
                case TIME_IS_UP: {
                    break;
                }
                case TASK_IS_DONE: {
                    break;
                }
                case DONE: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Nullable
    public EntityPlayer getPlayer() {
        if (this.playerId == null) {
            return null;
        }
        WorldServer world = DimensionManager.getWorld((int)0);
        MinecraftServer server = world.func_73046_m();
        return server.func_184103_al().func_177451_a(this.playerId);
    }

    @Nullable
    public UUID getPlayerId() {
        return this.playerId;
    }

    private boolean openGui() {
        if (this.playerId == null) {
            return false;
        }
        MinecraftServer server = DimensionManager.getWorld((int)0).func_73046_m();
        EntityPlayerMP player = server.func_184103_al().func_177451_a(this.playerId);
        if (player == null) {
            return false;
        }
        MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketActionOptionToClient(this, 1), player);
        return true;
    }

    private static boolean validSpawnPoint(World world, BlockPos p) {
        return world.func_175623_d(p) && (!world.func_175623_d(p.func_177977_b()) || !world.func_175623_d(p.func_177979_c(2))) && world.func_175623_d(p.func_177984_a());
    }

    public static boolean spawn(World world, BlockPos targetPos, EnumFacing targetSide, int actionId, boolean doSound) {
        BlockPos p;
        if (ActionOptions.validSpawnPoint(world, targetPos.func_177972_a(targetSide))) {
            p = targetPos.func_177972_a(targetSide);
        } else if (ActionOptions.validSpawnPoint(world, targetPos.func_177978_c())) {
            p = targetPos.func_177978_c();
        } else if (ActionOptions.validSpawnPoint(world, targetPos.func_177968_d())) {
            p = targetPos.func_177968_d();
        } else if (ActionOptions.validSpawnPoint(world, targetPos.func_177974_f())) {
            p = targetPos.func_177974_f();
        } else if (ActionOptions.validSpawnPoint(world, targetPos.func_177976_e())) {
            p = targetPos.func_177976_e();
        } else if (ActionOptions.validSpawnPoint(world, targetPos.func_177984_a())) {
            p = targetPos.func_177984_a();
        } else {
            return false;
        }
        EntityMeeCreeps entity = new EntityMeeCreeps(world);
        entity.func_70012_b((double)p.func_177958_n() + 0.5, p.func_177956_o(), (double)p.func_177952_p() + 0.5, 0.0f, 0.0f);
        entity.setActionId(actionId);
        world.func_72838_d((Entity)entity);
        if (doSound && Config.meeCreepVolume > 0.01f) {
            String snd = "intro1";
            switch (entity.getRandom().nextInt(4)) {
                case 0: {
                    snd = "intro1";
                    break;
                }
                case 1: {
                    snd = "intro2";
                    break;
                }
                case 2: {
                    snd = "intro3";
                    break;
                }
                case 3: {
                    snd = "intro4";
                }
            }
            SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("meecreeps", snd));
            SoundTools.playSound((World)world, (SoundEvent)sound, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)Config.meeCreepVolume, (double)1.0);
        }
        return true;
    }
}

