/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.item.crystal.ToolCrystalProperties;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public interface ChargedCrystalToolBase {
    public static final Random chRand = new Random();

    @Nonnull
    public Item getInertVariant();

    public static ItemStack getAsInertVariant(ItemStack stack) {
        ToolCrystalProperties prop = ChargedCrystalToolBase.getToolProperties(stack);
        ItemStack inert = new ItemStack(((ChargedCrystalToolBase)stack.func_77973_b()).getInertVariant());
        ChargedCrystalToolBase.applyToolProperties(inert, prop);
        if (stack.func_77942_o()) {
            inert.func_77982_d(stack.func_77978_p().func_74737_b());
        }
        return inert;
    }

    public static boolean shouldRevert(ItemStack stack) {
        if (!Config.shouldChargedToolsRevert) {
            return false;
        }
        NBTTagCompound tag = NBTHelper.getPersistentData(stack);
        if (!tag.func_74764_b("chCount")) {
            tag.func_74768_a("chCount", 0);
        }
        int c = tag.func_74762_e("chCount");
        tag.func_74768_a("chCount", ++c);
        if (c >= Config.revertStart) {
            return chRand.nextInt(Config.revertChance) == 0;
        }
        return false;
    }

    public static void removeChargeRevertCounter(ItemStack stack) {
        NBTHelper.getPersistentData(stack).func_82580_o("chCount");
    }

    public static boolean tryRevertMainHand(EntityPlayer player, ItemStack stack) {
        if (ChargedCrystalToolBase.shouldRevert(stack)) {
            ItemStack inert = ChargedCrystalToolBase.getAsInertVariant(stack);
            ChargedCrystalToolBase.removeChargeRevertCounter(inert);
            player.func_184611_a(EnumHand.MAIN_HAND, inert);
            return true;
        }
        return false;
    }

    public static void applyToolProperties(ItemStack stack, ToolCrystalProperties properties) {
        properties.writeToNBT(NBTHelper.getPersistentData(stack));
    }

    public static ToolCrystalProperties getToolProperties(ItemStack stack) {
        NBTTagCompound nbt = NBTHelper.getPersistentData(stack);
        return ToolCrystalProperties.readFromNBT(nbt);
    }
}

