/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.page;

import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.util.BlockArrayRenderHelper;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class JournalPageStructure
implements IJournalPage {
    private BlockArray structure;
    private String unlocName;
    private Vector3 shift;

    public JournalPageStructure(BlockArray struct) {
        this(struct, null);
    }

    public JournalPageStructure(BlockArray struct, @Nullable String unlocName) {
        this(struct, unlocName, new Vector3());
    }

    public JournalPageStructure(BlockArray struct, @Nullable String unlocName, @Nonnull Vector3 shift) {
        this.structure = struct;
        this.unlocName = unlocName;
        this.shift = shift;
    }

    @Override
    public IGuiRenderablePage buildRenderPage() {
        return new Render(this.structure, this.unlocName, this.shift.clone());
    }

    public static class Render
    implements IGuiRenderablePage {
        private static BindableResource texSlices = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiscructpreviewicons");
        private final BlockArrayRenderHelper structRender;
        private final BlockArray blocks;
        private final Vector3 shift;
        private final List<Tuple<ItemStack, String>> descriptionStacks = new LinkedList<Tuple<ItemStack, String>>();
        private final String unlocName;
        private long totalRenderFrame = 0L;
        private Optional<Integer> drawSlice = Optional.empty();
        private Rectangle switchView = null;
        private Rectangle sliceUp = null;
        private Rectangle sliceDown = null;

        public Render(BlockArray structure, @Nullable String unlocName, @Nonnull Vector3 shift) {
            this.structRender = new BlockArrayRenderHelper(structure);
            this.blocks = structure;
            this.unlocName = unlocName;
            this.shift = shift;
            List<ItemStack> stacksNeeded = structure.getAsDescriptiveStacks();
            for (ItemStack stack : stacksNeeded) {
                if (stack.func_77973_b() instanceof UniversalBucket) {
                    FluidStack f = ((UniversalBucket)stack.func_77973_b()).getFluid(stack);
                    this.descriptionStacks.add(new Tuple<ItemStack, String>(stack, stack.func_190916_E() + "x " + I18n.func_135052_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[]{f.getLocalizedName()})));
                    continue;
                }
                this.descriptionStacks.add(new Tuple<ItemStack, String>(stack, stack.func_190916_E() + "x " + I18n.func_135052_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[0])));
            }
        }

        @Override
        public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            GL11.glPushAttrib((int)1048575);
            GlStateManager.func_179094_E();
            ++this.totalRenderFrame;
            this.renderStructure(offsetX, offsetY, pTicks);
            float shift = this.renderSizeDescription(offsetX, offsetY + 5.0f);
            if (this.unlocName != null) {
                this.renderHeadline(offsetX + shift, offsetY + 5.0f, this.unlocName);
            }
            this.renderSliceButtons(offsetX, offsetY + 10.0f, mouseX, mouseY);
            GlStateManager.func_179121_F();
            GL11.glPopAttrib();
        }

        private void renderSliceButtons(float offsetX, float offsetY, float mouseX, float mouseY) {
            texSlices.bindTexture();
            GlStateManager.func_179097_i();
            this.switchView = null;
            this.sliceUp = null;
            this.sliceDown = null;
            this.switchView = new Rectangle(MathHelper.func_76141_d((float)offsetX) + 152, MathHelper.func_76141_d((float)offsetY) + 10, 16, 16);
            double u = this.drawSlice.isPresent() ? 0.5 : 0.0;
            this.drawRectPart(this.switchView.x, this.switchView.y, this.switchView.width, this.switchView.height, 0.0, u, 0.0, 0.5, 0.3333333333333333);
            if (this.drawSlice.isPresent()) {
                double v;
                int yLevel = this.drawSlice.get();
                if (this.structRender.hasSlice(yLevel + 1)) {
                    this.sliceUp = new Rectangle(MathHelper.func_76141_d((float)offsetX) + 148, MathHelper.func_76141_d((float)offsetY) + 28, 11, 16);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)((double)this.sliceUp.x + (double)this.sliceUp.width / 2.0), (double)((double)this.sliceUp.y + (double)this.sliceUp.height / 2.0), (double)0.0);
                    v = 0.6666666666666666;
                    if (this.sliceUp.contains(mouseX, mouseY)) {
                        v = 0.3333333333333333;
                        GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
                    }
                    GlStateManager.func_179109_b((float)(-(this.sliceUp.width / 2)), (float)(-(this.sliceUp.height / 2)), (float)0.0f);
                    this.drawRectPart(0.0, 0.0, this.sliceUp.width, this.sliceUp.height, 0.0, 0.0, v, 0.34375, 0.3333333333333333);
                    GlStateManager.func_179121_F();
                }
                if (this.structRender.hasSlice(yLevel - 1)) {
                    this.sliceDown = new Rectangle(MathHelper.func_76141_d((float)offsetX) + 160, MathHelper.func_76141_d((float)offsetY) + 28, 11, 16);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)((double)this.sliceDown.x + (double)this.sliceDown.width / 2.0), (double)((double)this.sliceDown.y + (double)this.sliceDown.height / 2.0), (double)0.0);
                    v = 0.6666666666666666;
                    if (this.sliceDown.contains(mouseX, mouseY)) {
                        v = 0.3333333333333333;
                        GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
                    }
                    GlStateManager.func_179109_b((float)(-(this.sliceDown.width / 2)), (float)(-(this.sliceDown.height / 2)), (float)0.0f);
                    this.drawRectPart(0.0, 0.0, this.sliceDown.width, this.sliceDown.height, 0.0, 0.375, v, 0.34375, 0.3333333333333333);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179126_j();
            TextureHelper.refreshTextureBindState();
        }

        @Override
        public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            Rectangle rect = this.drawInfoStar(offsetX + 160.0f, offsetY + 10.0f, zLevel, 15.0f, pTicks);
            if (rect.contains(mouseX, mouseY)) {
                RenderingUtils.renderBlueStackTooltip((int)offsetX + 160, (int)offsetY + 10, this.descriptionStacks, this.getStandardFontRenderer(), this.getRenderItem());
            }
        }

        private void renderHeadline(float offsetX, float offsetY, String unlocName) {
            String head = I18n.func_135052_a((String)unlocName, (Object[])new Object[0]);
            FontRenderer fr = this.getStandardFontRenderer();
            float scale = 1.3f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179097_i();
            GL11.glDisable((int)2929);
            fr.func_175065_a(head, 0.0f, 0.0f, 0xDDDDDD, true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        private float renderSizeDescription(float offsetX, float offsetY) {
            Vec3i size = this.blocks.getSize();
            FontRenderer fr = this.getStandardFontRenderer();
            float scale = 1.3f;
            String desc = size.func_177958_n() + " - " + size.func_177956_o() + " - " + size.func_177952_p();
            float length = (float)fr.func_78256_a(desc) * scale;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179097_i();
            GL11.glDisable((int)2929);
            fr.func_175065_a(desc, 0.0f, 0.0f, 0xDDDDDD, true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return length + 8.0f;
        }

        private void renderStructure(float offsetX, float offsetY, float pTicks) {
            Point2D.Double offset = this.renderOffset(offsetX + 8.0f, offsetY);
            if (Mouse.isButtonDown((int)0) && this.totalRenderFrame > 30L) {
                this.structRender.rotate(0.25 * (double)Mouse.getDY(), 0.25 * (double)Mouse.getDX(), 0.0);
            }
            this.structRender.render3DSliceGUI(offset.x + this.shift.getX(), offset.y + this.shift.getY(), pTicks, this.drawSlice);
        }

        private Point2D.Double renderOffset(float stdPageOffsetX, float stdPageOffsetY) {
            return new Point2D.Double((double)stdPageOffsetX + 70.0, (double)stdPageOffsetY + 146.66666666666666);
        }

        @Override
        public boolean propagateMouseClick(int mouseX, int mouseZ) {
            if (this.switchView != null && this.switchView.contains(mouseX, mouseZ)) {
                this.drawSlice = this.drawSlice.isPresent() ? Optional.empty() : Optional.of(this.structRender.getDefaultSlice());
                SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
                return true;
            }
            if (this.sliceUp != null && this.drawSlice.isPresent() && this.sliceUp.contains(mouseX, mouseZ)) {
                this.drawSlice = Optional.of(this.drawSlice.get() + 1);
                SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
                return true;
            }
            if (this.sliceDown != null && this.drawSlice.isPresent() && this.sliceDown.contains(mouseX, mouseZ)) {
                this.drawSlice = Optional.of(this.drawSlice.get() - 1);
                SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
    }
}

