/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class CtcpUtil {
    private static final char CTCP_DELIMITER = '\u0001';
    private static final char CTCP_MQUOTE = '\u0016';
    private static final Pattern CTCP_ESCAPABLE_CHAR = Pattern.compile("[\n\r\u0000\u0001\u0016\\\\]");
    private static final Pattern CTCP_ESCAPED_CHAR = Pattern.compile("([\u0016\\\\])(.)");
    private static final Pattern CTCP_MESSAGE = Pattern.compile("\u0001([^\u0001]*)\u0001[^\u0001]*");

    private CtcpUtil() {
    }

    @Nonnull
    public static String fromCtcp(@Nonnull String message) {
        String ctcpContent = message.substring(1, message.indexOf(1, 1));
        StringBuilder builder = new StringBuilder(ctcpContent.length());
        int currentIndex = 0;
        Matcher matcher = CTCP_ESCAPED_CHAR.matcher(ctcpContent);
        while (matcher.find()) {
            if (matcher.start() > currentIndex) {
                builder.append(ctcpContent.substring(currentIndex, matcher.start()));
            }
            block4 : switch (matcher.group(1)) {
                case "\u0016": {
                    switch (matcher.group(2)) {
                        case "n": {
                            builder.append('\n');
                            break block4;
                        }
                        case "r": {
                            builder.append('\r');
                            break block4;
                        }
                        case "0": {
                            builder.append('\u0000');
                            break block4;
                        }
                    }
                    builder.append(matcher.group(2));
                    break;
                }
                case "\\": {
                    switch (matcher.group(2)) {
                        case "a": {
                            builder.append('\u0001');
                            break block4;
                        }
                    }
                    builder.append(matcher.group(2));
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex < ctcpContent.length()) {
            builder.append(ctcpContent.substring(currentIndex));
        }
        return builder.toString();
    }

    public static boolean isCtcp(@Nonnull String message) {
        return CTCP_MESSAGE.matcher(message).matches();
    }

    @Nonnull
    public static String toCtcp(@Nonnull String message) {
        StringBuilder builder = new StringBuilder(message.length());
        builder.append('\u0001');
        int currentIndex = 0;
        Matcher matcher = CTCP_ESCAPABLE_CHAR.matcher(message);
        while (matcher.find()) {
            if (matcher.start() > currentIndex) {
                builder.append(message.substring(currentIndex, matcher.start()));
            }
            switch (matcher.group()) {
                case "\n": {
                    builder.append('\u0016').append('n');
                    break;
                }
                case "\r": {
                    builder.append('\u0016').append('r');
                    break;
                }
                case "\u0000": {
                    builder.append('\u0016').append('0');
                    break;
                }
                case "\u0016": {
                    builder.append('\u0016').append('\u0016');
                    break;
                }
                case "\u0001": {
                    builder.append("\\a");
                    break;
                }
                case "\\": {
                    builder.append("\\\\");
                    break;
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex < message.length()) {
            builder.append(message.substring(currentIndex));
        }
        builder.append('\u0001');
        return builder.toString();
    }
}

