/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.MouseIntractable;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.Part;
import com.brandon3055.brandonscore.integration.IRecipeRenderer;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;

public class PartContainer
extends MGuiElementBase<PartContainer> {
    private static final Pattern leftPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7align:left)");
    private static final Pattern centrePat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7align:center)");
    private static final Pattern rightPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7align:right)");
    private static final Pattern shadowPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7shadow)");
    public GuiColourProvider<Integer> colourProvider;
    public boolean shadow = false;
    public List<MouseIntractable> mouseIntractables = new ArrayList<MouseIntractable>();
    public GuiAlign align;
    private LinkedList<Part> containerParts = new LinkedList();
    public IRecipeRenderer hoveredRecipe = null;
    public GuiMarkdownElement element;

    public PartContainer(GuiMarkdownElement element) {
        this.element = element;
        this.align = element.currentAlign;
        this.colourProvider = element.colourProvider;
    }

    public void parseMarkdown(LinkedList<String> markdownLines) {
        GuiMarkdownElement.profiler.startSection("Read Paragraph Formatting");
        this.readParagraphFormatting(markdownLines);
        GuiMarkdownElement.profiler.endSection();
        if (markdownLines.isEmpty()) {
            return;
        }
        GuiMarkdownElement.profiler.startSection("Check Heading | Rule");
        if (this.checkHeading(markdownLines) || this.checkRule(markdownLines)) {
            GuiMarkdownElement.profiler.endSection();
            return;
        }
        GuiMarkdownElement.profiler.endStartSection("Apply Builders");
        this.applyBuilders(markdownLines);
        GuiMarkdownElement.profiler.endSection();
    }

    private boolean checkHeading(LinkedList<String> markdownLines) {
        if (markdownLines.isEmpty()) {
            return false;
        }
        String line = markdownLines.getFirst();
        String line2 = markdownLines.size() > 1 ? markdownLines.get(1) : "";
        if (line.startsWith("#") || Part.isAllChar(line2, '=') || Part.isAllChar(line2, '-')) {
            int headingSize;
            for (headingSize = 0; headingSize < line.length() && line.charAt(headingSize) == '#'; ++headingSize) {
            }
            boolean underlineHeadding = false;
            if (headingSize == 0 && Part.isAllChar(line2, '=')) {
                headingSize = 1;
                underlineHeadding = true;
            } else if (headingSize == 0 && Part.isAllChar(line2, '-')) {
                headingSize = 2;
                underlineHeadding = true;
            } else if (headingSize <= 0 || headingSize > 6) {
                return false;
            }
            markdownLines.removeFirst();
            if (headingSize > 0 && headingSize <= 6) {
                String headingText;
                headingSize = 7 - headingSize;
                if (!underlineHeadding) {
                    headingText = Part.trim(Part.applyTextFormatting(line), '#');
                } else {
                    markdownLines.removeFirst();
                    headingText = Part.applyTextFormatting(line);
                }
                final float scaleFactor = 1.0f + (float)headingSize / 3.0f;
                final List list = this.fontRenderer.func_78271_c(headingText, (int)((float)this.xSize() / scaleFactor));
                Part part = new Part(this){

                    @Override
                    public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                        for (String string : list) {
                            float x = xPos;
                            float y = (float)yPos + (float)font.field_78288_b * scaleFactor * (float)list.indexOf(string);
                            float scaledWidth = (float)font.func_78256_a(string) * scaleFactor;
                            switch (PartContainer.this.align) {
                                case CENTER: {
                                    x = (float)xPos + (float)PartContainer.this.xSize() / 2.0f - scaledWidth / 2.0f;
                                    break;
                                }
                                case RIGHT: {
                                    x = (float)xPos + ((float)PartContainer.this.xSize() - scaledWidth);
                                }
                            }
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)1.0f);
                            GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
                            font.func_175065_a(string, x, y, colour, shadow);
                            GlStateManager.func_179121_F();
                        }
                    }
                };
                part.width = this.xSize();
                part.height = MathHelper.ceil((double)((double)((float)this.fontRenderer.field_78288_b * scaleFactor * (float)list.size()) * 1.1));
                this.setYSize(part.height);
                this.containerParts.add(part);
                return true;
            }
        }
        return false;
    }

    private boolean checkRule(LinkedList<String> markdownLines) {
        if (markdownLines.isEmpty()) {
            return false;
        }
        String line = markdownLines.getFirst();
        Pattern rulePat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7rule\\[[^]]*])");
        Pattern ruleOptionsPat = Pattern.compile("(?<=\u00a7rule\\[)([^]]*)(?=])");
        Matcher ruleMatch = rulePat.matcher(line);
        Matcher ruleOptMatch = ruleOptionsPat.matcher(line);
        if (ruleMatch.find()) {
            int bottomPadding;
            int topPadding;
            int ruleHeight;
            int ruleWidth;
            String options;
            String string = options = ruleOptMatch.find() ? ruleOptMatch.group() : "";
            if (options.contains("colour:")) {
                try {
                    int colour = Part.readColour(Part.readOption(options, "colour", "#606060"));
                    this.colourProvider = () -> colour;
                }
                catch (NumberFormatException e) {
                    Part.addError(markdownLines, "Invalid Colour Value! Valid formats are 0xRRGGBB or #RRGGBB (hex) or Red,Green,Blue (RGB)", line);
                    return false;
                }
            }
            if (options.contains("align:")) {
                try {
                    this.align = GuiAlign.valueOf(Part.readOption(options, "align", "left").toUpperCase());
                }
                catch (Throwable e) {
                    Part.addError(markdownLines, "Invalid Align Value! Valid values are left, center and right", line);
                    return false;
                }
            }
            try {
                String value = Part.readOption(options, "width", "100%");
                int v = Part.parseSize(this.xSize(), value);
                ruleWidth = MathHelper.clip((int)v, (int)0, (int)this.xSize());
            }
            catch (NumberFormatException e) {
                Part.addError(markdownLines, "Height value must be a number!", line);
                return false;
            }
            try {
                ruleHeight = Integer.parseInt(Part.readOption(options, "height", "5"));
            }
            catch (NumberFormatException e) {
                Part.addError(markdownLines, "Height value must be a number!", line);
                return false;
            }
            try {
                topPadding = Integer.parseInt(Part.readOption(options, "top_padding", "5"));
                bottomPadding = Integer.parseInt(Part.readOption(options, "bottom_padding", "5"));
            }
            catch (NumberFormatException e) {
                Part.addError(markdownLines, "Padding value(s) must be a number!", line);
                return false;
            }
            Part part = new Part(this){

                @Override
                public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                    if (ruleHeight > 0 && ruleWidth > 0) {
                        float x = xPos;
                        switch (PartContainer.this.align) {
                            case CENTER: {
                                x = (float)xPos + (float)PartContainer.this.xSize() / 2.0f - (float)ruleWidth / 2.0f;
                                break;
                            }
                            case RIGHT: {
                                x = xPos + (PartContainer.this.xSize() - ruleWidth);
                            }
                        }
                        PartContainer.this.drawColouredRect(x, yPos + topPadding, ruleWidth, ruleHeight, 0xFF000000 | colour);
                    }
                }
            };
            part.width = this.xSize();
            part.height = MathHelper.ceil((float)(topPadding + ruleHeight + bottomPadding));
            this.setYSize(part.height);
            this.containerParts.add(part);
            markdownLines.removeFirst();
            return true;
        }
        return false;
    }

    private void applyBuilders(LinkedList<String> markdownLines) {
        int yPos;
        if (markdownLines.isEmpty()) {
            return;
        }
        String next = markdownLines.removeFirst();
        boolean empty = next.isEmpty();
        this.fontRenderer.func_78265_b();
        BCFontRenderer.setStileToggleMode(true);
        int nextPart = next.length();
        int xPos = this.getInsetRect().x;
        int maxYPos = yPos = this.getInsetRect().y;
        block0: while (next.length() > 0) {
            for (IPartBuilder builder : GuiMarkdownElement.partBuilders) {
                int i = builder.matches(next);
                if (i == 0) {
                    builder.finalXPos = xPos;
                    builder.finalYPos = yPos;
                    int builderStartY = yPos;
                    next = builder.build(this.fontRenderer, next, nextPart, this.fontRenderer, this, this.containerParts, this.getInsetRect().x, this.getInsetRect().x + this.getInsetRect().width, xPos, yPos, maxYPos);
                    GuiMarkdownElement.profiler.endSection();
                    nextPart = next.length();
                    xPos = builder.finalXPos;
                    yPos = builder.finalYPos;
                    if (builderStartY + builder.builtHeight <= maxYPos) continue block0;
                    maxYPos = builderStartY + builder.builtHeight;
                    continue block0;
                }
                if (i <= 0 || i >= nextPart) continue;
                nextPart = i;
            }
        }
        if (empty) {
            this.setYSize(this.fontRenderer.field_78288_b);
        } else {
            this.setYSize(maxYPos - this.getInsetRect().y);
        }
        BCFontRenderer.setStileToggleMode(false);
    }

    private void readParagraphFormatting(LinkedList<String> markdownLines) {
        if (markdownLines.isEmpty()) {
            return;
        }
        String line = markdownLines.getFirst();
        boolean formatLine = false;
        if (leftPat.matcher(line).find()) {
            this.element.currentAlign = GuiAlign.LEFT;
            line = line.replace("\u00a7align:left", "");
            formatLine = true;
        } else if (centrePat.matcher(line).find()) {
            this.element.currentAlign = GuiAlign.CENTER;
            line = line.replace("\u00a7align:center", "");
            formatLine = true;
        } else if (rightPat.matcher(line).find()) {
            this.element.currentAlign = GuiAlign.RIGHT;
            line = line.replace("\u00a7align:right", "");
            formatLine = true;
        }
        if (shadowPat.matcher(line).find()) {
            this.shadow = true;
            line = line.replace("\u00a7shadow", "");
            formatLine = true;
        }
        this.align = this.element.currentAlign;
        Matcher c = GuiMarkdownElement.colourPat.matcher(line);
        Matcher cx = GuiMarkdownElement.colourExtractPat.matcher(line);
        try {
            if (c.find() && cx.find()) {
                formatLine = true;
                String raw = cx.group();
                int colour = Part.readColour(raw);
                this.colourProvider = () -> colour;
                line = c.replaceAll("");
            }
        }
        catch (NumberFormatException e) {
            markdownLines.removeFirst();
            markdownLines.addFirst("\u00a74Invalid colour value! Must be a hex starting with 0x or # or it can be separate integer or float R G B values separated by comma's. Float values must contain a decimal point.\u00a74 " + line);
            return;
        }
        if (formatLine) {
            markdownLines.removeFirst();
            if (!line.isEmpty()) {
                while (line.startsWith(" ") && line.length() > 1) {
                    line = line.substring(1);
                }
                markdownLines.addFirst(line);
            }
            this.readParagraphFormatting(markdownLines);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (MouseIntractable mi : this.mouseIntractables) {
            if (!mi.isMouseOver || !mi.onClick(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void linkClick(String linkTarget, int button) {
        if (this.element.linkListener != null) {
            this.element.linkListener.accept(linkTarget, button);
        }
    }

    public void imageClick(String linkTarget, int button) {
        if (this.element.imageListener != null) {
            this.element.imageListener.accept(linkTarget, button);
        }
    }

    public void recipeClick(ItemStack stackClicked, int button) {
        LogHelperBC.dev("Recipe Clicked! " + stackClicked);
        if (this.element.recipeListener != null) {
            this.element.recipeListener.accept(stackClicked, button);
        }
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.fontRenderer.func_78265_b();
        BCFontRenderer.setStileToggleMode(true);
        int xPos = this.getInsetRect().x;
        int yPos = this.getInsetRect().y;
        int maxWidth = this.getInsetRect().width;
        int prevHeight = 0;
        int alignOffset = 0;
        for (int i = 0; i < this.containerParts.size(); ++i) {
            Part part = this.containerParts.get(i);
            if (xPos + part.width > this.getInsetRect().x + maxWidth) {
                xPos = this.getInsetRect().x;
                yPos += prevHeight;
                prevHeight = 0;
            }
            if (xPos == this.getInsetRect().x && this.align != GuiAlign.LEFT) {
                int width = 0;
                for (int j = i; j < this.containerParts.size(); ++j) {
                    Part p = this.containerParts.get(j);
                    if (width + p.width > maxWidth) break;
                    width += p.width;
                }
                alignOffset = this.align == GuiAlign.CENTER ? (maxWidth - width) / 2 : maxWidth - width;
            }
            part.lastXPos = xPos + alignOffset;
            part.lastYPos = yPos;
            part.render(this.fontRenderer, xPos + alignOffset, yPos, mouseX, mouseY, this.colourProvider.getColour(), this.shadow, partialTicks);
            prevHeight = Math.max(part.height, prevHeight);
            xPos += part.width;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BCFontRenderer.setStileToggleMode(false);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        BCFontRenderer.setStileToggleMode(false);
        this.fontRenderer.func_78265_b();
        for (MouseIntractable mi : this.mouseIntractables) {
            if (mi.isMouseOver && (!mi.hoverText.isEmpty() || mi.errorText != null)) {
                if (mi.errorText != null) {
                    this.drawHoveringText(Collections.singletonList(mi.errorText), mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                } else {
                    this.drawHoveringText(mi.hoverText, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                }
                return true;
            }
            if (!mi.isMouseOver || mi.getHoverStack() == null) continue;
            List list = mi.getHoverStack().func_82840_a((EntityPlayer)this.mc.field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    list.set(i, mi.getHoverStack().func_77953_t().field_77937_e + (String)list.get(i));
                    continue;
                }
                list.set(i, TextFormatting.GRAY + (String)list.get(i));
            }
            GuiUtils.preItemToolTip((ItemStack)mi.getHoverStack());
            this.drawHoveringText(mi.getHoverStack(), list, mouseX, mouseY, this.screenWidth, this.screenHeight, -1, this.fontRenderer);
            GuiUtils.postItemToolTip();
            return true;
        }
        if (this.hoveredRecipe != null && this.isMouseOver(mouseX, mouseY)) {
            this.hoveredRecipe.renderOverlay(minecraft, mouseX, mouseY);
            this.hoveredRecipe = null;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onUpdate() {
        int mouseX = Mouse.getX() * this.screenWidth / this.mc.field_71443_c;
        int mouseY = this.screenHeight - Mouse.getY() * this.screenHeight / this.mc.field_71440_d - 1;
        this.mouseIntractables.forEach(mouseInteract -> mouseInteract.updateMouseOver(mouseX, mouseY));
        return super.onUpdate();
    }
}

