/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.elevator;

import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Broadcaster;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.blocks.elevator.ElevatorConfiguration;
import mcjty.rftools.blocks.elevator.ElevatorSetup;
import mcjty.rftools.blocks.elevator.ElevatorSounds;
import mcjty.rftools.blocks.shield.RelCoordinate;
import mcjty.rftools.playerprops.BuffProperties;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElevatorTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable {
    public static String CMD_SETNAME = "elevator.setName";
    private boolean prevIn = false;
    private double movingY = -1.0;
    private int startY;
    private int stopY;
    private String name = "";
    private Set<BlockPos> positions = new HashSet<BlockPos>();
    private Bounds bounds;
    private IBlockState movingState;
    private BlockPos cachedControllerPos;
    private int cachedLevels;
    private int cachedCurrent = -1;
    private boolean redstoneOut = false;
    private Set<Entity> entitiesOnPlatform = new HashSet<Entity>();
    private boolean entitiesOnPlatformComplete = false;
    private FakePlayer harvester = null;

    public ElevatorTileEntity() {
        super((long)ElevatorConfiguration.MAXENERGY, (long)ElevatorConfiguration.RFPERTICK);
    }

    private FakePlayer getHarvester() {
        if (this.harvester == null) {
            this.harvester = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_elevator".getBytes()), "rftools_elevator"));
        }
        this.harvester.func_70029_a(this.field_145850_b);
        this.harvester.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        return this.harvester;
    }

    public void clearCaches(EnumFacing side) {
        for (int y = 0; y < this.func_145831_w().func_72800_K(); ++y) {
            EnumFacing side2;
            TileEntity te;
            BlockPos pos2 = ElevatorTileEntity.getPosAtY(this.func_174877_v(), y);
            if (this.func_145831_w().func_180495_p(pos2).func_177230_c() != ElevatorSetup.elevatorBlock || !((te = this.func_145831_w().func_175625_s(pos2)) instanceof ElevatorTileEntity) || (side2 = (EnumFacing)this.func_145831_w().func_180495_p(pos2).func_177229_b((IProperty)BaseBlock.FACING_HORIZ)) != side) continue;
            ElevatorTileEntity tileEntity = (ElevatorTileEntity)te;
            tileEntity.cachedControllerPos = null;
            tileEntity.cachedLevels = 0;
            tileEntity.cachedCurrent = -1;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.markDirtyClient();
    }

    private void setRedstoneState() {
        this.func_70296_d();
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            boolean newout = this.isPlatformHere();
            if (newout != this.redstoneOut) {
                this.redstoneOut = newout;
                this.setRedstoneState();
            }
            if (this.isMoving()) {
                this.func_70296_d();
                double d = this.calculateSpeed();
                boolean stopped = this.handlePlatformMovement(d);
                if (stopped) {
                    this.stopMoving();
                    this.moveEntities(0.0, true);
                    this.clearMovement();
                } else {
                    this.moveEntities(d, false);
                }
                return;
            }
            if (this.powerLevel > 0 == this.prevIn) {
                return;
            }
            this.prevIn = this.powerLevel > 0;
            this.func_70296_d();
            if (this.powerLevel > 0) {
                this.movePlatformHere();
            }
        } else {
            if (this.isMoving()) {
                this.handleClientMovement();
            }
            this.handleSound();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().field_72995_K) {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSounds() {
        ElevatorSounds.stopSound(this.func_145831_w(), this.func_174877_v());
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleSound() {
        boolean shutdown;
        if (ElevatorConfiguration.baseElevatorVolume < 0.01f) {
            return;
        }
        if (!this.isMoving()) {
            this.stopSounds();
            return;
        }
        boolean startup = Math.abs((double)this.startY - this.movingY) < ElevatorConfiguration.maxSpeedDistanceStart;
        boolean bl = shutdown = Math.abs(this.movingY - (double)this.stopY) < ElevatorConfiguration.maxSpeedDistanceEnd * 2.0;
        if (shutdown) {
            if (!ElevatorSounds.isStopPlaying(this.func_145831_w(), this.field_174879_c)) {
                ElevatorSounds.playStop(this.func_145831_w(), this.field_174879_c);
            }
        } else if (startup) {
            if (!ElevatorSounds.isStartupPlaying(this.func_145831_w(), this.field_174879_c)) {
                ElevatorSounds.playStartup(this.func_145831_w(), this.field_174879_c);
            }
        } else if (!ElevatorSounds.isLoopPlaying(this.func_145831_w(), this.field_174879_c)) {
            ElevatorSounds.playLoop(this.func_145831_w(), this.field_174879_c);
        }
        ElevatorSounds.moveSound(this.func_145831_w(), this.field_174879_c, (float)this.movingY);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleClientMovement() {
        double d = this.calculateSpeed();
        this.handlePlatformMovement(d);
        if (this.bounds != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            AxisAlignedBB aabb = this.getAABBAboveElevator(d);
            boolean on = player.func_174813_aQ().func_72326_a(aabb);
            if (on) {
                player.func_70107_b(player.field_70165_t, this.movingY + 1.0, player.field_70161_v);
            }
        }
    }

    private double calculateSpeed() {
        double speedDiff = ElevatorConfiguration.maximumSpeed - ElevatorConfiguration.minimumSpeed;
        double speedFromStart = ElevatorConfiguration.minimumSpeed + speedDiff * Math.abs((this.movingY - (double)this.startY) / ElevatorConfiguration.maxSpeedDistanceStart);
        double speedFromStop = ElevatorConfiguration.minimumSpeed + speedDiff * Math.abs((this.movingY - (double)this.stopY) / ElevatorConfiguration.maxSpeedDistanceEnd);
        double d = Math.min(speedFromStart, speedFromStop);
        if (this.stopY < this.startY) {
            d = -d;
        }
        return d;
    }

    private boolean handlePlatformMovement(double d) {
        if (this.stopY > this.startY) {
            if (this.movingY >= (double)this.stopY) {
                return true;
            }
            this.movingY += d;
            if (this.movingY >= (double)this.stopY) {
                this.movingY = this.stopY;
            }
        } else {
            if (this.movingY <= (double)this.stopY) {
                return true;
            }
            this.movingY += d;
            if (this.movingY <= (double)this.stopY) {
                this.movingY = this.stopY;
            }
        }
        return false;
    }

    private void moveEntities(double speed, boolean stop) {
        if (this.bounds == null) {
            return;
        }
        double offset = speed > 0.0 ? speed * 2.0 : speed;
        Set<Entity> oldEntities = this.entitiesOnPlatform;
        this.entitiesOnPlatform = new HashSet<Entity>();
        List entities = this.func_145831_w().func_72872_a(Entity.class, this.getAABBAboveElevator(speed));
        for (Entity entity : entities) {
            entity.field_70143_R = 0.0f;
            this.entitiesOnPlatform.add(entity);
            this.moveEntityOnPlatform(stop, offset, entity);
            entity.field_70122_E = true;
            entity.field_70143_R = 0.0f;
        }
        for (Entity entity : oldEntities) {
            if (this.entitiesOnPlatform.contains(entity)) continue;
            if ((entity instanceof EntityPlayer || this.entitiesOnPlatformComplete) && entity.func_174813_aQ().func_72326_a(this.getAABBBigMargin())) {
                entity.field_70143_R = 0.0f;
                this.entitiesOnPlatform.add(entity);
                this.moveEntityOnPlatform(stop, offset, entity);
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
            }
            if (!(entity instanceof EntityPlayer)) continue;
            BuffProperties.disableElevatorMode((EntityPlayer)entity);
        }
        this.entitiesOnPlatformComplete = true;
    }

    private void moveEntityOnPlatform(boolean stop, double offset, Entity entity) {
        if (entity instanceof EntityPlayer) {
            double dy = 1.0;
            EntityPlayer player = (EntityPlayer)entity;
            if (stop) {
                BuffProperties.disableElevatorMode(player);
                entity.field_70163_u = this.movingY + dy;
                entity.func_70634_a(entity.field_70165_t, this.movingY + dy, entity.field_70161_v);
            } else {
                BuffProperties.enableElevatorMode(player);
                entity.func_70107_b(entity.field_70165_t, this.movingY + dy, entity.field_70161_v);
            }
        } else {
            double dy = 1.2 + offset;
            entity.field_70163_u = this.movingY + dy;
            entity.func_70634_a(entity.field_70165_t, this.movingY + dy, entity.field_70161_v);
        }
    }

    public BlockPos findBottomElevator() {
        if (this.cachedControllerPos != null) {
            return this.cachedControllerPos;
        }
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() != ElevatorSetup.elevatorBlock) {
            return null;
        }
        EnumFacing side = (EnumFacing)blockState.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        for (int y = 0; y < this.func_145831_w().func_72800_K(); ++y) {
            EnumFacing otherSide;
            BlockPos elevatorPos = ElevatorTileEntity.getPosAtY(this.func_174877_v(), y);
            IBlockState otherState = this.func_145831_w().func_180495_p(elevatorPos);
            if (otherState.func_177230_c() != ElevatorSetup.elevatorBlock || (otherSide = (EnumFacing)otherState.func_177229_b((IProperty)BaseBlock.FACING_HORIZ)) != side) continue;
            this.cachedControllerPos = elevatorPos;
            return elevatorPos;
        }
        return null;
    }

    private BlockPos findElevatorWithPlatform() {
        EnumFacing side = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        for (int y = 0; y < this.func_145831_w().func_72800_K(); ++y) {
            BlockPos frontPos;
            EnumFacing otherSide;
            BlockPos elevatorPos = ElevatorTileEntity.getPosAtY(this.func_174877_v(), y);
            IBlockState otherState = this.func_145831_w().func_180495_p(elevatorPos);
            if (otherState.func_177230_c() != ElevatorSetup.elevatorBlock || (otherSide = (EnumFacing)otherState.func_177229_b((IProperty)BaseBlock.FACING_HORIZ)) != side || !this.isValidPlatformBlock(frontPos = elevatorPos.func_177972_a(side))) continue;
            return elevatorPos;
        }
        return null;
    }

    private boolean isValidPlatformBlock(BlockPos frontPos) {
        World world = this.func_145831_w();
        IBlockState state = world.func_180495_p(frontPos);
        Block block = state.func_177230_c();
        return !block.isAir(state, (IBlockAccess)world, frontPos) && !block.hasTileEntity(state);
    }

    public Set<BlockPos> getPositions() {
        return this.positions;
    }

    public IBlockState getMovingState() {
        return this.movingState;
    }

    private void stopMoving() {
        this.movingY = this.stopY;
        for (BlockPos pos : this.positions) {
            if (!this.func_145831_w().func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), pos)) continue;
            this.func_145831_w().func_180501_a(ElevatorTileEntity.getPosAtY(pos, this.stopY), this.movingState, 3);
        }
        this.cachedCurrent = -1;
        this.markDirtyClient();
    }

    private void clearMovement() {
        this.positions.clear();
        this.entitiesOnPlatform.clear();
        this.movingState = null;
        this.bounds = null;
        this.movingY = -1.0;
    }

    private boolean startMoving(BlockPos start, BlockPos stop, IBlockState state) {
        this.movingState = state;
        this.positions.clear();
        this.getBounds(start);
        if (this.bounds.getMaxX() < this.bounds.getMinX() || this.bounds.getMaxZ() < this.bounds.getMinZ()) {
            this.bounds = null;
            return false;
        }
        this.movingY = start.func_177956_o();
        this.startY = start.func_177956_o();
        this.stopY = stop.func_177956_o();
        this.markDirtyClient();
        return true;
    }

    private boolean canMoveBlock(BlockPos pos) {
        World world = this.func_145831_w();
        IBlockState state = world.func_180495_p(pos);
        return state == this.movingState && state.func_185887_b(world, pos) >= 0.0f && BuilderTileEntity.allowedToBreak(state, world, pos, (EntityPlayer)this.getHarvester());
    }

    private void getBounds(BlockPos start) {
        BlockPos offset;
        EnumFacing side = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        this.bounds = new Bounds();
        for (int a = 1; a < ElevatorConfiguration.maxPlatformSize && this.canMoveBlock(offset = start.func_177967_a(side, a)); ++a) {
            BlockPos offsetRight;
            BlockPos offsetLeft;
            int b;
            this.func_145831_w().func_175698_g(offset);
            this.bounds.addPos(offset);
            this.positions.add(ElevatorTileEntity.getPosAtY(offset, this.func_174877_v().func_177956_o()));
            for (b = 1; b <= ElevatorConfiguration.maxPlatformSize / 2 && this.canMoveBlock(offsetLeft = offset.func_177967_a(side.func_176746_e(), b)); ++b) {
                this.func_145831_w().func_175698_g(offsetLeft);
                this.bounds.addPos(offsetLeft);
                this.positions.add(ElevatorTileEntity.getPosAtY(offsetLeft, this.func_174877_v().func_177956_o()));
            }
            for (b = 1; b <= ElevatorConfiguration.maxPlatformSize / 2 && this.canMoveBlock(offsetRight = offset.func_177967_a(side.func_176735_f(), b)); ++b) {
                this.func_145831_w().func_175698_g(offsetRight);
                this.bounds.addPos(offsetRight);
                this.positions.add(ElevatorTileEntity.getPosAtY(offsetRight, this.func_174877_v().func_177956_o()));
            }
        }
    }

    public AxisAlignedBB getAABBBigMargin() {
        return new AxisAlignedBB((double)this.bounds.getMinX(), this.movingY - 150.0, (double)this.bounds.getMinZ(), (double)(this.bounds.getMaxX() + 1), this.movingY + 150.0, (double)(this.bounds.getMaxZ() + 1));
    }

    public AxisAlignedBB getAABBAboveElevator(double speed) {
        double o2;
        double o1;
        if (speed > 0.0) {
            o1 = -speed * 2.0;
            o2 = 0.0;
        } else {
            o1 = 0.0;
            o2 = -speed * 2.0;
        }
        return new AxisAlignedBB((double)this.bounds.getMinX(), this.movingY - 1.0 + o1, (double)this.bounds.getMinZ(), (double)(this.bounds.getMaxX() + 1), this.movingY + 3.0 + o2, (double)(this.bounds.getMaxZ() + 1));
    }

    public boolean isMoving() {
        return this.movingY >= 0.0;
    }

    public double getMovingY() {
        return this.movingY;
    }

    public void toLevel(int level) {
        EnumFacing side = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        BlockPos controllerPos = this.findBottomElevator();
        for (int y = controllerPos.func_177956_o(); y < this.func_145831_w().func_72800_K(); ++y) {
            EnumFacing side2;
            TileEntity te2;
            BlockPos pos2 = ElevatorTileEntity.getPosAtY(controllerPos, y);
            if (this.func_145831_w().func_180495_p(pos2).func_177230_c() != ElevatorSetup.elevatorBlock || !((te2 = this.func_145831_w().func_175625_s(pos2)) instanceof ElevatorTileEntity) || side != (side2 = (EnumFacing)this.func_145831_w().func_180495_p(pos2).func_177229_b((IProperty)BaseBlock.FACING_HORIZ))) continue;
            if (level == 0) {
                ((ElevatorTileEntity)te2).movePlatformHere();
                return;
            }
            --level;
        }
    }

    public void findElevatorBlocks(List<Integer> heights) {
        BlockPos controllerPos = this.findBottomElevator();
        if (controllerPos == null) {
            return;
        }
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() != ElevatorSetup.elevatorBlock) {
            return;
        }
        EnumFacing side = (EnumFacing)blockState.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        for (int y = controllerPos.func_177956_o(); y < this.func_145831_w().func_72800_K(); ++y) {
            EnumFacing side2;
            BlockPos pos2 = ElevatorTileEntity.getPosAtY(controllerPos, y);
            TileEntity te2 = this.func_145831_w().func_175625_s(pos2);
            if (!(te2 instanceof ElevatorTileEntity) || side != (side2 = (EnumFacing)this.func_145831_w().func_180495_p(pos2).func_177229_b((IProperty)BaseBlock.FACING_HORIZ))) continue;
            heights.add(y);
        }
    }

    public int getCurrentLevel(List<Integer> heights) {
        BlockPos controllerPos = this.findBottomElevator();
        TileEntity te = this.func_145831_w().func_175625_s(controllerPos);
        if (te instanceof ElevatorTileEntity) {
            EnumFacing side = (EnumFacing)this.func_145831_w().func_180495_p(controllerPos).func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
            ElevatorTileEntity controller = (ElevatorTileEntity)te;
            if (controller.cachedCurrent == -1) {
                int level = 0;
                for (Integer y : heights) {
                    BlockPos pos2 = ElevatorTileEntity.getPosAtY(controllerPos, y);
                    BlockPos frontPos = pos2.func_177972_a(side);
                    if (this.isValidPlatformBlock(frontPos)) {
                        controller.cachedCurrent = level;
                    }
                    ++level;
                }
            }
            return controller.cachedCurrent;
        }
        return 0;
    }

    public int getLevelCount(List<Integer> heights) {
        return heights.size();
    }

    public boolean isPlatformHere() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() != ElevatorSetup.elevatorBlock) {
            return false;
        }
        EnumFacing side = (EnumFacing)blockState.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        BlockPos frontPos = this.func_174877_v().func_177972_a(side);
        return this.isValidPlatformBlock(frontPos);
    }

    private void movePlatformHere() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() != ElevatorSetup.elevatorBlock) {
            return;
        }
        EnumFacing side = (EnumFacing)blockState.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        BlockPos frontPos = this.func_174877_v().func_177972_a(side);
        if (this.isValidPlatformBlock(frontPos)) {
            return;
        }
        BlockPos platformPos = this.findElevatorWithPlatform();
        if (platformPos == null) {
            return;
        }
        BlockPos controllerPos = this.findBottomElevator();
        ElevatorTileEntity controller = (ElevatorTileEntity)this.func_145831_w().func_175625_s(controllerPos);
        if (controller.isMoving()) {
            return;
        }
        int rfNeeded = (int)((float)(ElevatorConfiguration.rfPerHeightUnit * Math.abs(this.func_174877_v().func_177956_o() - platformPos.func_177956_o())) * (3.0f - this.getInfusedFactor()) / 3.0f);
        if (controller.getStoredPower() < (long)rfNeeded) {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p(), (String)(TextFormatting.RED + "Not enough power to move the elevator platform!"), (float)10.0f);
            return;
        }
        if (controller.startMoving(platformPos, this.func_174877_v(), this.func_145831_w().func_180495_p(platformPos.func_177972_a(side)))) {
            controller.consumeEnergy(rfNeeded);
        } else {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p(), (String)(TextFormatting.RED + "The block in front of the elevator platform could not be moved!"), (float)10.0f);
        }
    }

    public static BlockPos getPosAtY(BlockPos p, int y) {
        return new BlockPos(p.func_177958_n(), y, p.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isMoving()) {
            return new AxisAlignedBB(this.func_174877_v().func_177982_a(-9, 0, -9), this.func_174877_v().func_177982_a(9, 255, 9));
        }
        return super.getRenderBoundingBox();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.isMoving()) {
            return 65536.0;
        }
        return super.func_145833_n();
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.readFromNBTCommon(compound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        this.readFromNBTCommon(tagCompound);
        this.redstoneOut = tagCompound.func_74767_n("rs");
        this.entitiesOnPlatformComplete = false;
        if (tagCompound.func_74764_b("players")) {
            this.entitiesOnPlatform.clear();
            WorldServer world = DimensionManager.getWorld((int)0);
            List serverPlayers = world.func_73046_m().func_184103_al().func_181057_v();
            NBTTagList playerList = tagCompound.func_150295_c("players", 10);
            block0: for (int i = 0; i < playerList.func_74745_c(); ++i) {
                NBTTagCompound p = playerList.func_150305_b(i);
                long lsb = p.func_74763_f("lsb");
                long msb = p.func_74763_f("msb");
                UUID uuid = new UUID(msb, lsb);
                for (EntityPlayerMP serverPlayer : serverPlayers) {
                    if (!serverPlayer.func_146103_bH().getId().equals(uuid)) continue;
                    this.entitiesOnPlatform.add((Entity)serverPlayer);
                    continue block0;
                }
            }
        }
    }

    private void readFromNBTCommon(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.movingY = tagCompound.func_74769_h("movingY");
        this.startY = tagCompound.func_74762_e("startY");
        this.stopY = tagCompound.func_74762_e("stopY");
        byte[] byteArray = tagCompound.func_74770_j("relcoords");
        this.positions.clear();
        int j = 0;
        for (int i = 0; i < byteArray.length / 6; ++i) {
            short dx = ElevatorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
            short dy = ElevatorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
            short dz = ElevatorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
            j += 6;
            RelCoordinate c = new RelCoordinate(dx, dy, dz);
            this.positions.add(new BlockPos(this.func_174877_v().func_177958_n() + c.getDx(), this.func_174877_v().func_177956_o() + c.getDy(), this.func_174877_v().func_177952_p() + c.getDz()));
        }
        if (tagCompound.func_74764_b("bminX")) {
            int bminX = tagCompound.func_74762_e("bminX");
            int bminZ = tagCompound.func_74762_e("bminZ");
            int bmaxX = tagCompound.func_74762_e("bmaxX");
            int bmaxZ = tagCompound.func_74762_e("bmaxZ");
            if (bminX <= bmaxX && bminZ <= bmaxZ) {
                this.bounds = new Bounds(bminX, bminZ, bmaxX, bmaxZ);
            }
        }
        if (tagCompound.func_74764_b("movingId")) {
            Integer id = tagCompound.func_74762_e("movingId");
            this.movingState = Block.func_176220_d((int)id);
        } else if (tagCompound.func_74764_b("movingBlock")) {
            String id = tagCompound.func_74779_i("movingBlock");
            int meta = tagCompound.func_74762_e("movingMeta");
            this.movingState = ((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(id))).func_176203_a(meta);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.redstoneOut);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74780_a("movingY", this.movingY);
        tagCompound.func_74768_a("startY", this.startY);
        tagCompound.func_74768_a("stopY", this.stopY);
        byte[] blocks = new byte[this.positions.size() * 6];
        int j = 0;
        for (BlockPos pos : this.positions) {
            RelCoordinate c = new RelCoordinate(pos.func_177958_n() - this.func_174877_v().func_177958_n(), pos.func_177956_o() - this.func_174877_v().func_177956_o(), pos.func_177952_p() - this.func_174877_v().func_177952_p());
            blocks[j + 0] = ElevatorTileEntity.shortToByte1((short)c.getDx());
            blocks[j + 1] = ElevatorTileEntity.shortToByte2((short)c.getDx());
            blocks[j + 2] = ElevatorTileEntity.shortToByte1((short)c.getDy());
            blocks[j + 3] = ElevatorTileEntity.shortToByte2((short)c.getDy());
            blocks[j + 4] = ElevatorTileEntity.shortToByte1((short)c.getDz());
            blocks[j + 5] = ElevatorTileEntity.shortToByte2((short)c.getDz());
            j += 6;
        }
        if (this.bounds != null) {
            tagCompound.func_74768_a("bminX", this.bounds.getMinX());
            tagCompound.func_74768_a("bminZ", this.bounds.getMinZ());
            tagCompound.func_74768_a("bmaxX", this.bounds.getMaxX());
            tagCompound.func_74768_a("bmaxZ", this.bounds.getMaxZ());
        }
        tagCompound.func_74773_a("relcoords", blocks);
        if (this.movingState != null) {
            tagCompound.func_74768_a("movingId", Block.func_176210_f((IBlockState)this.movingState));
        }
        if (!this.func_145831_w().field_72995_K && !this.entitiesOnPlatform.isEmpty()) {
            NBTTagList playerList = new NBTTagList();
            for (Entity entity : this.entitiesOnPlatform) {
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                UUID id = player.func_146103_bH().getId();
                NBTTagCompound p = new NBTTagCompound();
                p.func_74772_a("lsb", id.getLeastSignificantBits());
                p.func_74772_a("msb", id.getMostSignificantBits());
                playerList.func_74742_a((NBTBase)p);
            }
            tagCompound.func_74782_a("players", (NBTBase)playerList);
        }
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.func_74779_i("levelName");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74778_a("levelName", this.name == null ? "" : this.name);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETNAME.equals(command)) {
            this.setName((String)params.get(TextField.PARAM_TEXT));
            return true;
        }
        return false;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        this.clearCaches((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BaseBlock.FACING_HORIZ));
    }

    public void onBlockBreak(World workd, BlockPos pos, IBlockState state) {
        super.onBlockBreak(workd, pos, state);
        this.clearCaches((EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING_HORIZ));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        probeInfo.text(TextFormatting.BLUE + "Name: " + this.getName());
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        long energy = this.getStoredPower();
        currenttip.add(TextFormatting.GREEN + "RF: " + energy);
        if (this.getName() != null && !this.getName().isEmpty()) {
            currenttip.add(TextFormatting.BLUE + "Name: " + this.getName());
        }
    }

    public int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        if (side == direction) {
            return this.isPlatformHere() ? 15 : 0;
        }
        return 0;
    }

    private static class Bounds {
        private int minX = 1000000000;
        private int minZ = 1000000000;
        private int maxX = -1000000000;
        private int maxZ = -1000000000;

        public Bounds() {
        }

        public Bounds(int minX, int minZ, int maxX, int maxZ) {
            this.maxX = maxX;
            this.maxZ = maxZ;
            this.minX = minX;
            this.minZ = minZ;
        }

        public void addPos(BlockPos pos) {
            if (pos.func_177958_n() < this.minX) {
                this.minX = pos.func_177958_n();
            }
            if (pos.func_177958_n() > this.maxX) {
                this.maxX = pos.func_177958_n();
            }
            if (pos.func_177952_p() < this.minZ) {
                this.minZ = pos.func_177952_p();
            }
            if (pos.func_177952_p() > this.maxZ) {
                this.maxZ = pos.func_177952_p();
            }
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMinZ() {
            return this.minZ;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMaxZ() {
            return this.maxZ;
        }
    }
}

