/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod;

import com.rwtema.monkmod.ClientFunction;
import com.rwtema.monkmod.MonkMod;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.abilities.MonkAbilityAttribute;
import com.rwtema.monkmod.data.MonkData;
import com.rwtema.monkmod.levels.MonkLevelManager;
import com.rwtema.monkmod.network.MessageMonkLevelData;
import com.rwtema.monkmod.network.MessageProgress;
import com.rwtema.monkmod.network.MonkNetwork;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class MonkManager {
    public static final int NUMBER_OF_TIMES_TO_UPDATE = 100;
    @Nonnull
    public static final MonkData clientData = new MonkData();
    private static final ClientFunction<EntityPlayer, Boolean> isClient = new ClientFunction<EntityPlayer, Boolean>(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public Boolean apply(EntityPlayer player) {
            return player.field_70170_p.field_72995_K && player.equals((Object)Minecraft.func_71410_x().field_71439_g);
        }

        @Override
        public Boolean applyFallback(EntityPlayer player) {
            return false;
        }
    };

    @SubscribeEvent
    public static void registerCap(AttachCapabilitiesEvent<Entity> playerAttachCapabilitiesEvent) {
        if (playerAttachCapabilitiesEvent.getObject() instanceof EntityPlayer) {
            playerAttachCapabilitiesEvent.addCapability(MonkData.LOCATION, (ICapabilityProvider)new MonkData());
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        MonkData oldData = MonkManager.get(event.getOriginal());
        MonkData newData = MonkManager.get(event.getEntityPlayer());
        newData.deserializeNBT(oldData.serializeNBT());
        newData.dirty = 100;
    }

    @SubscribeEvent
    public static void onChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        MonkData monkData = MonkManager.get(event.player);
        monkData.dirty = 100;
    }

    @SubscribeEvent
    public static void onWatch(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        MonkManager.updatePlayer(player, MonkManager.get((EntityPlayer)player));
    }

    private static void updatePlayer(@Nonnull EntityPlayerMP player, MonkData monkData) {
        int level = monkData.getLevel();
        for (int i = 0; i < level; ++i) {
            MonkMod.TRIGGER.trigger(player, level);
        }
        MonkNetwork.net.sendTo((IMessage)new MessageMonkLevelData(monkData), player);
        player.func_71016_p();
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.phase == TickEvent.Phase.START) {
            return;
        }
        MonkData monkData = MonkManager.get(event.player);
        EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
        if (monkData.progressDirty) {
            MonkNetwork.net.sendTo((IMessage)new MessageProgress(monkData.getProgress(), monkData.getMaxProgress()), playerMP);
            monkData.progressDirty = false;
        }
        if (monkData.dirty > 0) {
            if (monkData.dirty == 100 || monkData.dirty % 6 == 0) {
                MonkManager.updatePlayer(playerMP, monkData);
            }
            --monkData.dirty;
        }
        Set<MonkAbility> abilities = MonkLevelManager.getAbilities(monkData.getLevel());
        abilities.forEach(ability -> ability.tickServer(playerMP));
        AbstractAttributeMap attributeMap = event.player.func_110140_aT();
        for (IAttributeInstance attributeInstance : attributeMap.func_111146_a()) {
            for (UUID uuid : MonkAbilityAttribute.uuids.keySet()) {
                if (attributeInstance.func_111127_a(uuid) == null) continue;
                Set monkAbilityAttributes = MonkAbilityAttribute.uuids.get((Object)uuid);
                if (!monkAbilityAttributes.stream().noneMatch(abilities::contains)) continue;
                attributeInstance.func_188479_b(uuid);
            }
        }
    }

    @Nonnull
    public static MonkData get(@Nonnull EntityPlayer player) {
        if (isClient.apply(player).booleanValue()) {
            return clientData;
        }
        return (MonkData)Validate.notNull((Object)player.getCapability(MonkData.MONKLEVELDATA, null));
    }

    public static boolean getAbilityLevel(@Nonnull EntityPlayer player, MonkAbility ability) {
        return MonkLevelManager.getAbilities(MonkManager.get(player).getLevel()).contains(ability);
    }

    public static boolean getAbilityLevel(@Nonnull EntityPlayer player, String key) {
        return MonkLevelManager.getAbilities(MonkManager.get(player).getLevel()).stream().anyMatch(a -> a.name.equals(key));
    }
}

