/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.thread;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import me.ichun.mods.ichunutil.common.core.util.ResourceHelper;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.NBTHandler;
import net.minecraft.entity.EntityLivingBase;

public class ThreadGetResources
extends Thread {
    public String sitePrefix = "https://raw.github.com/iChun/Morph/1.12.2/src/main/resources/assets/morph/mod/";

    public ThreadGetResources(String prefix) {
        if (!prefix.isEmpty()) {
            this.sitePrefix = prefix;
        }
        this.setName("Morph Resource Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        HashMap json = (HashMap)this.getResource("nbt_modifiers.json", new TypeToken<HashMap<String, HashMap<String, String>>>(){}.getType());
        int mcNBTModifiers = 0;
        NBTHandler.nbtModifiers.clear();
        for (Map.Entry e : json.entrySet()) {
            try {
                if (((String)e.getKey()).startsWith("example.class.")) continue;
                Class<?> clz = Class.forName((String)e.getKey());
                NBTHandler.TagModifier tagModifier = new NBTHandler.TagModifier();
                HashMap map = (HashMap)e.getValue();
                for (Map.Entry modifier : map.entrySet()) {
                    String value = (String)modifier.getValue();
                    NBTHandler.handleModifier(tagModifier, (String)modifier.getKey(), value);
                }
                if (!EntityLivingBase.class.isAssignableFrom(clz) || tagModifier.modifiers.isEmpty()) continue;
                NBTHandler.nbtModifiers.put(clz, tagModifier);
                if (clz.getName().startsWith("net.minecraft")) {
                    ++mcNBTModifiers;
                    continue;
                }
                Morph.LOGGER.info((Object)("Adding NBT modifiers for morphs for class: " + clz.getName()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (mcNBTModifiers > 0) {
            Morph.LOGGER.info((Object)("Loaded NBT modifiers for presumably " + mcNBTModifiers + " Minecraft mobs"));
        } else {
            Morph.LOGGER.warn((Object)"No NBT modifiers for Minecraft mobs? This might be an issue!");
        }
    }

    public <T> T getResource(String name, Type mapType) {
        Object objectType;
        Gson gson = new Gson();
        try {
            if (Morph.config.useLocalResources == 1) {
                FileInputStream con = new FileInputStream(new File(ResourceHelper.getConfigFolder(), name));
                String data = new String(ByteStreams.toByteArray((InputStream)con));
                ((InputStream)con).close();
                objectType = gson.fromJson(data, mapType);
            } else {
                InputStreamReader fileIn = new InputStreamReader(new URL(this.sitePrefix + name).openStream());
                objectType = gson.fromJson((Reader)fileIn, mapType);
                ((Reader)fileIn).close();
            }
        }
        catch (Exception e) {
            if (Morph.config.useLocalResources == 1) {
                Morph.LOGGER.warn((Object)("Failed to retrieve local resource: " + name));
            } else {
                Morph.LOGGER.warn((Object)("Failed to retrieve " + name + " from " + (Morph.config.customPatchLink.isEmpty() ? "GitHub!" : this.sitePrefix)));
            }
            e.printStackTrace();
            InputStreamReader fileIn = new InputStreamReader(Morph.class.getResourceAsStream("/assets/morph/mod/" + name));
            objectType = gson.fromJson((Reader)fileIn, mapType);
            try {
                ((Reader)fileIn).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return (T)objectType;
    }
}

