/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.packet;

import com.google.common.collect.Ordering;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphState;
import me.ichun.mods.morph.common.morph.MorphVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketUpdateMorphList
extends AbstractPacket {
    public boolean fullList;
    public MorphVariant[] morphVariants;

    public PacketUpdateMorphList() {
    }

    public PacketUpdateMorphList(boolean isFullList, MorphVariant ... variants) {
        this.fullList = isFullList;
        this.morphVariants = variants;
    }

    public void writeTo(ByteBuf buffer) {
        PacketBuffer pb = new PacketBuffer(buffer);
        buffer.writeBoolean(this.fullList);
        buffer.writeInt(this.morphVariants.length);
        for (MorphVariant var : this.morphVariants) {
            pb.func_150786_a(var.write(new NBTTagCompound()));
        }
    }

    public void readFrom(ByteBuf buffer) {
        PacketBuffer pb = new PacketBuffer(buffer);
        this.fullList = buffer.readBoolean();
        this.morphVariants = new MorphVariant[buffer.readInt()];
        try {
            for (int i = 0; i < this.morphVariants.length; ++i) {
                this.morphVariants[i] = new MorphVariant("");
                this.morphVariants[i].read(pb.func_150793_b());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void execute(Side side, EntityPlayer player) {
        this.handleClient();
    }

    public Side receivingSide() {
        return Side.CLIENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        Object state;
        boolean organiseFavourites = this.fullList;
        if (this.fullList) {
            Morph.eventHandlerClient.playerMorphs.clear();
            Morph.eventHandlerClient.favouriteStates.clear();
        }
        ArrayList<MorphVariant> morphs = new ArrayList<MorphVariant>();
        for (MorphVariant var : this.morphVariants) {
            morphs.addAll(var.split());
        }
        ArrayList<Object> states = new ArrayList<Object>();
        for (MorphVariant var : morphs) {
            state = new MorphState(var);
            ((MorphState)state).getEntInstance((World)Minecraft.func_71410_x().field_71441_e);
            states.add(state);
            if (!var.thisVariant.isFavourite) continue;
            organiseFavourites = true;
            Morph.eventHandlerClient.favouriteStates.add((MorphState)state);
        }
        String playerName = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        Collections.sort(states);
        if (organiseFavourites) {
            Collections.sort(Morph.eventHandlerClient.favouriteStates);
        }
        for (int i = 0; i < states.size(); ++i) {
            state = (MorphState)states.get(i);
            if (!((MorphState)state).currentVariant.entId.equals("PlayerMorph") || !((MorphState)state).currentVariant.playerName.equals(playerName)) continue;
            states.remove(i);
            states.add(0, state);
            if (!organiseFavourites) continue;
            Morph.eventHandlerClient.favouriteStates.remove(state);
            Morph.eventHandlerClient.favouriteStates.add(0, (MorphState)state);
        }
        boolean needsReorder = !this.fullList;
        for (MorphState morphState : states) {
            ArrayList category = Morph.eventHandlerClient.playerMorphs.computeIfAbsent(morphState.getName(), k -> new ArrayList());
            if (category.contains(morphState) && !category.remove(morphState)) continue;
            category.add(morphState);
        }
        if (needsReorder) {
            TreeMap<String, ArrayList<MorphState>> buffer = new TreeMap<String, ArrayList<MorphState>>((Comparator<String>)Ordering.natural());
            buffer.putAll(Morph.eventHandlerClient.playerMorphs);
            ArrayList arrayList = (ArrayList)buffer.get(playerName);
            buffer.remove(playerName);
            Morph.eventHandlerClient.playerMorphs.clear();
            Morph.eventHandlerClient.playerMorphs.put(playerName, arrayList);
            for (Map.Entry e : buffer.entrySet()) {
                Morph.eventHandlerClient.playerMorphs.put((String)e.getKey(), (ArrayList<MorphState>)e.getValue());
            }
        }
    }
}

