/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.config;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigHandler {
    private final Configuration config;
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_CROPS = "crops";
    private static final String CATEGORY_GARDENS = "gardens";
    private static final String CATEGORY_SALT = "salt";
    private static final String CATEGORY_BEE = "beekeeping";
    private static final String CATEGORY_MARKET_SALES = "market sales";
    private static final String CATEGORY_MARKET_PRICES = "market prices";
    private static final String CATEGORY_MARKET_CURRENCY = "market currency";
    private static final String CATEGORY_CANDLES = "candles";
    private static final String CATEGORY_DIMENSIONS = "dimensions";
    private static final String CATEGORY_SEEDS = "seeds";
    private static final String CATEGORY_MISC_RECIPES = "miscellaneous recipes";
    private static final String CATEGORY_SHIPPINGBIN_PURCHASES = "shipping bin purchases";
    private static final String CATEGORY_SHIPPINGBIN_PRICES = "shipping bin prices";
    private static final int defaultCropFoodRestore = 1;
    private static final double defaultSaturationSmall = 0.6;
    private static final double defaultSaturationMeal = 1.2;
    private static final double defaultSaturationMeatyMeal = (double)1.6f;
    private static final double defaultCropGrowthSpeed = 0.0;
    public boolean squiddropCalamari;
    public boolean smeltsquidintocookedFish;
    public int cropfoodRestore;
    public float cropsaturationRestore;
    public static boolean cropsdropSeeds;
    public static float cropGrowthSpeed;
    public float snacksaturation;
    public float mealsaturation;
    public float meatymealsaturation;
    public int freshmilkfrombucket;
    public int freshwaterfrombucket;
    public boolean enablesaltfromwaterbucketrecipe;
    public int seedrarity;
    public boolean enablegigapickleCrop;
    public int waterfilterfreshwaterAmount;
    public int waterfiltersaltAmount;
    public int waterfilterTime;
    public static int saltrecipeAmount;
    public static boolean enableHCFish;
    public static boolean enablevanillafoodBalance;
    public static int topTierFood;
    public static int buffTimeForTopTier;
    public boolean enablecroptoseedRecipe;
    public boolean enableTofuAsMeatInRecipes;
    public boolean enableTofuAsMilkInRecipes;
    public boolean enablelistAllwaterfreshwater;
    public boolean enablelistAllwatervanillawaterbucket;
    public boolean enablemaplesyrupslimeballPresser;
    public boolean enablehoneyslimeballPresser;
    public final HashMap<String, Boolean> seedDropFromGrass = new HashMap();
    private final Map<String, String[]> gardenDropConfig = new HashMap<String, String[]>();
    public int gardenRarity;
    public int gardendropAmount;
    public int gardenSpreadMax;
    public boolean enablegardenSpread;
    public int gardenspreadRate;
    public boolean enablearidgardenGeneration;
    public boolean enablefrostgardenGeneration;
    public boolean enabletropicalgardenGeneration;
    public boolean enablewindygardenGeneration;
    public boolean enableshadedgardenGeneration;
    public boolean enablesoggygardenGeneration;
    public boolean enablecropspecialplanting;
    public boolean marketsellSeeds;
    public boolean marketselltemperateSaplings;
    public boolean marketselltropicalSaplings;
    public boolean marketsellconiferousSaplings;
    public boolean marketsellPig;
    public boolean marketsellSheep;
    public boolean marketsellCow;
    public boolean marketsellChicken;
    public boolean marketsellHorse;
    public boolean marketsellLlama;
    public boolean marketsellOcelot;
    public boolean marketsellWolf;
    public boolean marketsellRabbit;
    public boolean marketsellLead;
    public boolean marketsellNametag;
    public boolean marketsellQueenbee;
    public boolean marketsellBonemeal;
    public int marketblockrecipeItem;
    public int marketseedPrice;
    public int marketsaplingPrice;
    public int marketpigPrice;
    public int marketsheepPrice;
    public int marketcowPrice;
    public int marketchickenPrice;
    public int markethorsePrice;
    public int marketllamaPrice;
    public int marketocelotPrice;
    public int marketwolfPrice;
    public int marketrabbitPrice;
    public int marketleadPrice;
    public int marketnametagPrice;
    public int marketbonemealPrice;
    public int marketqueenbeePrice;
    public int marketcurrencySeeds;
    public int marketcurrencytemperateSaplings;
    public int marketcurrencytropicalSaplings;
    public int marketcurrencyconiferousSaplings;
    public int marketcurrencyPig;
    public int marketcurrencySheep;
    public int marketcurrencyCow;
    public int marketcurrencyChicken;
    public int marketcurrencyHorse;
    public int marketcurrencyLlama;
    public int marketcurrencyOcelot;
    public int marketcurrencyWolf;
    public int marketcurrencyRabbit;
    public int marketcurrencyLead;
    public int marketcurrencyNametag;
    public int marketcurrencyBonemeal;
    public int marketcurrencyFish;
    public int marketcurrencyMeat;
    public int marketcurrencyBees;
    public boolean enableEasyHarvest;
    public boolean shippingbinbuyCrops;
    public int shippingbincropPrice;
    public boolean shippingbinbuyFish;
    public int shippingbinfishPrice;
    public boolean shippingbinbuyMeat;
    public int shippingbinmeatPrice;
    public boolean shippingbinbuyBees;
    public int shippingbinbeesPrice;
    public static boolean shippingbinenablevanillaMCCrops;
    public static boolean shippingbinenablevanillaMCFish;
    public static boolean shippingbinenablevanillaMCMeat;
    public static boolean shippingbinenablevanillaMCEgg;
    public static boolean shippingbinenablevanillaMCMonsterParts;
    public static boolean shippingbinenablevanillaMCBees;
    public boolean enableBeehiveGeneration;
    public int beehiveRarity;
    public boolean queenbeelastresultequalsQueen;
    public boolean enablebeegrubaslistAllmeat;

    public ConfigHandler(Configuration config) {
        this.config = config;
        this.initSettings();
    }

    private void initSettings() {
        this.config.load();
        this.initGeneralSettings();
        this.initCropSettings();
        this.initSeedDropSettings();
        this.initGardenSettings();
        this.initMarketSettings();
        this.initBeesSettings();
        this.initMiscRecipesSettings();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void initBeesSettings() {
        this.enableBeehiveGeneration = this.config.getBoolean("enableBeehiveGeneration", CATEGORY_BEE, true, "Enable generation of beehives.");
        this.beehiveRarity = this.config.getInt("beehiveRarity", CATEGORY_BEE, 10, 0, Short.MAX_VALUE, "The higher the value, the more beehives are generated.");
        this.queenbeelastresultequalsQueen = this.config.getBoolean("apiarylastresultequalsQueen", CATEGORY_BEE, true, "If true, the last item produced by a queen bee will be another queen bee.");
        this.enablebeegrubaslistAllmeat = this.config.getBoolean("enablebeegrubaslistAllmeat", CATEGORY_BEE, true, "Allows grubs and cooked grubs to be used in listAllrawmeat and listAllcookedmeat.");
    }

    private void initGeneralSettings() {
        this.squiddropCalamari = this.config.getBoolean("squiddropCalamari", CATEGORY_GENERAL, true, "Enables squid mobs to drop raw calamari.");
        this.smeltsquidintocookedFish = this.config.getBoolean("smeltsquidintocookedFish", CATEGORY_GENERAL, false, "Enable to have raw calamari smelt into cooked fish instead.");
        this.enableEasyHarvest = this.config.getBoolean("enableEasyHarvest", CATEGORY_GENERAL, true, "Enables harvesting by right-clicking.");
        enableHCFish = this.config.getBoolean("enableHCFish", CATEGORY_GENERAL, true, "Enables catching of HarvestCraft fish using the normal fishing rod.");
        enablevanillafoodBalance = this.config.getBoolean("enablevanillafoodBalance", CATEGORY_GENERAL, true, "Makes changes to vanilla food item and drop hunger restore and saturation values to be balanced with HarvestCraft food.");
        topTierFood = this.config.get(CATEGORY_GENERAL, "topTierFood", 10, "Default: 10, Choose 5, 6, 7, 8, 9, or 10 shank foods which become top tier.  Foods at this level or above give buffs.  Top tier foods are always edible, so be careful!  Set to 0 to have no top tier foods.").getInt();
        buffTimeForTopTier = this.config.get(CATEGORY_GENERAL, "buffTimeForTopTier", 3600, "Default: 3600 or 3 minutes").getInt();
        this.waterfilterfreshwaterAmount = this.config.get(CATEGORY_GENERAL, "waterfilterfreshwaterAmount", 8, "How many Fresh Water you get per Woven Cloth in the Water Filter.  Default 8.  Use whole numbers between 0 and 64.").getInt();
        this.waterfiltersaltAmount = this.config.get(CATEGORY_GENERAL, "waterfiltersaltAmount", 8, "How many Salt you get per Woven Cloth in the Water Filter.  Default 8.  Use whole numbers between 0 and 64.").getInt();
        this.waterfilterTime = this.config.get(CATEGORY_GENERAL, "waterfilterTime", 516, "How long the Water Filter takes to run.  Default 516.  For comparison, the Presser time is 125.").getInt();
    }

    private void initCropSettings() {
        this.cropfoodRestore = this.config.get(CATEGORY_CROPS, "cropfoodRestore", 1).getInt();
        this.cropsaturationRestore = (float)this.config.get(CATEGORY_CROPS, "cropsaturationRestore", 0.6).getDouble();
        this.snacksaturation = (float)this.config.get(CATEGORY_CROPS, "snacksaturation", 0.6).getDouble();
        this.mealsaturation = (float)this.config.get(CATEGORY_CROPS, "mealsaturation", 1.2).getDouble();
        this.meatymealsaturation = (float)this.config.get(CATEGORY_CROPS, "meatymealsaturation", (double)1.6f).getDouble();
        this.enablecropspecialplanting = this.config.get(CATEGORY_CROPS, "enablecropspecialplanting", true).getBoolean();
        cropsdropSeeds = this.config.get(CATEGORY_CROPS, "cropsdropSeeds", false).getBoolean();
        cropGrowthSpeed = (float)this.config.get(CATEGORY_CROPS, "cropGrowthSpeed", 0.0, "Default: 0.0, This number is added/subtracted from normal fertile crop growth (3.0) and adjacent fertile crop growth (4.0).").getDouble();
        this.enablegigapickleCrop = this.config.get(CATEGORY_CROPS, "enablegigapickleCrop", true, "Disable to keep giga pickle crop seeds from appearing in dungeon chests").getBoolean();
    }

    private void initGardenSettings() {
        this.gardenRarity = this.config.get(CATEGORY_GARDENS, "gardenRarity", 2).getInt();
        this.gardendropAmount = this.config.get(CATEGORY_GARDENS, "gardendropAmount", 3).getInt();
        this.enablegardenSpread = this.config.get(CATEGORY_GARDENS, "enablegardenSpread", true).getBoolean();
        this.gardenspreadRate = this.config.getInt("gardenSpreadRate", CATEGORY_GARDENS, 30, 1, 100, "Garden spread rate. 100 means a garden spawns every tick. 1 means a garden spawns with a probability of 1% per tick.");
        this.gardenSpreadMax = this.config.get(CATEGORY_GARDENS, "gardenspreadMax", 8).getInt();
        this.enablearidgardenGeneration = this.config.get(CATEGORY_GARDENS, "enablearidgardenGeneration", true).getBoolean();
        this.enablefrostgardenGeneration = this.config.get(CATEGORY_GARDENS, "enablefrostgardenGeneration", true).getBoolean();
        this.enabletropicalgardenGeneration = this.config.get(CATEGORY_GARDENS, "enabletropicalgardenGeneration", true).getBoolean();
        this.enablewindygardenGeneration = this.config.get(CATEGORY_GARDENS, "enablewindygardenGeneration", true).getBoolean();
        this.enableshadedgardenGeneration = this.config.get(CATEGORY_GARDENS, "enableshadedgardenGeneration", true).getBoolean();
        this.enablesoggygardenGeneration = this.config.get(CATEGORY_GARDENS, "enablesoggygardenGeneration", true).getBoolean();
        this.gardenDropConfig.put("aridGarden", this.config.getStringList("aridGarden", "drops", new String[]{"harvestcraft:cactusfruititem", "minecraft:cactus"}, ""));
        this.gardenDropConfig.put("frostGarden", this.config.getStringList("frostGarden", "drops", new String[]{"harvestcraft:raspberryitem", "harvestcraft:oatsitem", "harvestcraft:ryeitem", "harvestcraft:celeryitem", "harvestcraft:peasitem", "harvestcraft:beetitem", "harvestcraft:rutabagaitem", "harvestcraft:broccoliitem", "harvestcraft:caulifloweritem", "harvestcraft:cabbageitem", "harvestcraft:spinachitem", "harvestcraft:cottonitem"}, ""));
        this.gardenDropConfig.put("shadedGarden", this.config.getStringList("shadedGarden", "drops", new String[]{"harvestcraft:whitemushroomitem", "harvestcraft:blackberryitem", "harvestcraft:zucchiniitem", "harvestcraft:radishitem", "harvestcraft:rhubarbitem", "harvestcraft:tealeafitem", "harvestcraft:garlicitem", "harvestcraft:sweetpotatoitem", "harvestcraft:turnipitem", "harvestcraft:spiceleafitem", "harvestcraft:beanitem", "harvestcraft:leekitem", "harvestcraft:scallionitem", "harvestcraft:tomatoitem", "harvestcraft:cottonitem"}, ""));
        this.gardenDropConfig.put("soggyGarden", this.config.getStringList("soggyGarden", "drops", new String[]{"harvestcraft:brusselsproutitem", "harvestcraft:spiceleafitem", "harvestcraft:blueberryitem", "harvestcraft:asparagusitem", "harvestcraft:cranberryitem", "harvestcraft:riceitem", "harvestcraft:seaweeditem", "harvestcraft:waterchestnutitem", "harvestcraft:okraitem", "harvestcraft:cottonitem"}, ""));
        this.gardenDropConfig.put("tropicalGarden", this.config.getStringList("tropicalGarden", "drops", new String[]{"harvestcraft:grapeitem", "harvestcraft:pineappleitem", "harvestcraft:kiwiitem", "harvestcraft:sesameseedsitem", "harvestcraft:curryleafitem", "harvestcraft:bambooshootitem", "harvestcraft:cantaloupeitem", "harvestcraft:gingeritem", "harvestcraft:coffeebeanitem", "harvestcraft:soybeanitem", "harvestcraft:eggplantitem", "harvestcraft:cottonitem"}, ""));
        this.gardenDropConfig.put("windyGarden", this.config.getStringList("windyGarden", "drops", new String[]{"harvestcraft:strawberryitem", "harvestcraft:barleyitem", "harvestcraft:cornitem", "harvestcraft:cucumberitem", "harvestcraft:wintersquashitem", "harvestcraft:mustardseedsitem", "harvestcraft:onionitem", "harvestcraft:parsnipitem", "harvestcraft:peanutitem", "minecraft:potato", "minecraft:carrot", "harvestcraft:lettuceitem", "harvestcraft:artichokeitem", "harvestcraft:bellpepperitem", "harvestcraft:chilipepperitem", "minecraft:wheat", "harvestcraft:cottonitem"}, ""));
    }

    private void initMarketSettings() {
        this.marketsellSeeds = this.config.get(CATEGORY_MARKET_SALES, "marketsellSeeds", true).getBoolean();
        this.marketselltemperateSaplings = this.config.get(CATEGORY_MARKET_SALES, "marketselltemperateSaplings", true).getBoolean();
        this.marketselltropicalSaplings = this.config.get(CATEGORY_MARKET_SALES, "marketselltropicalSaplings", true).getBoolean();
        this.marketsellconiferousSaplings = this.config.get(CATEGORY_MARKET_SALES, "marketsellconiferousSaplings", true).getBoolean();
        this.marketsellPig = this.config.get(CATEGORY_MARKET_SALES, "marketsellPig", true).getBoolean();
        this.marketsellSheep = this.config.get(CATEGORY_MARKET_SALES, "marketsellSheep", true).getBoolean();
        this.marketsellCow = this.config.get(CATEGORY_MARKET_SALES, "marketsellCow", true).getBoolean();
        this.marketsellChicken = this.config.get(CATEGORY_MARKET_SALES, "marketsellChicken", true).getBoolean();
        this.marketsellHorse = this.config.get(CATEGORY_MARKET_SALES, "marketsellHorse", true).getBoolean();
        this.marketsellLlama = this.config.get(CATEGORY_MARKET_SALES, "marketsellLlama", true).getBoolean();
        this.marketsellOcelot = this.config.get(CATEGORY_MARKET_SALES, "marketsellOcelot", true).getBoolean();
        this.marketsellWolf = this.config.get(CATEGORY_MARKET_SALES, "marketsellWolf", true).getBoolean();
        this.marketsellRabbit = this.config.get(CATEGORY_MARKET_SALES, "marketsellRabbit", true).getBoolean();
        this.marketsellLead = this.config.get(CATEGORY_MARKET_SALES, "marketsellLead", true).getBoolean();
        this.marketsellNametag = this.config.get(CATEGORY_MARKET_SALES, "marketsellNametag", true).getBoolean();
        this.marketsellBonemeal = this.config.get(CATEGORY_MARKET_SALES, "marketsellBonemeal", true).getBoolean();
        this.marketsellQueenbee = this.config.get(CATEGORY_MARKET_SALES, "marketsellQueenbee", true).getBoolean();
        this.marketseedPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketseedPrice", 1).getInt();
        this.marketsaplingPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketsaplingPrice", 3).getInt();
        this.marketpigPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketpigPrice", 6).getInt();
        this.marketsheepPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketsheepPrice", 6).getInt();
        this.marketcowPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketcowPrice", 9).getInt();
        this.marketchickenPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketchickenPrice", 3).getInt();
        this.markethorsePrice = this.config.get(CATEGORY_MARKET_PRICES, "markethorsePrice", 12).getInt();
        this.marketllamaPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketllamaPrice", 12).getInt();
        this.marketocelotPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketocelotPrice", 9).getInt();
        this.marketwolfPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketwolfPrice", 9).getInt();
        this.marketrabbitPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketrabbitPrice", 3).getInt();
        this.marketleadPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketleadPrice", 1).getInt();
        this.marketnametagPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketnametagPrice", 1).getInt();
        this.marketbonemealPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketbonemealPrice", 3).getInt();
        this.marketqueenbeePrice = this.config.get(CATEGORY_MARKET_PRICES, "marketqueenbeePrice", 3).getInt();
        this.marketcurrencySeeds = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencySeeds", 0).getInt();
        this.marketcurrencytemperateSaplings = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencytemperateSaplings", 0).getInt();
        this.marketcurrencytropicalSaplings = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencytropicalSaplings", 0).getInt();
        this.marketcurrencyconiferousSaplings = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyconiferousSaplings", 0).getInt();
        this.marketcurrencyPig = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyPig", 0).getInt();
        this.marketcurrencySheep = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencySheep", 0).getInt();
        this.marketcurrencyCow = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyCow", 0).getInt();
        this.marketcurrencyChicken = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyChicken", 0).getInt();
        this.marketcurrencyHorse = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyHorse", 0).getInt();
        this.marketcurrencyLlama = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyLlama", 0).getInt();
        this.marketcurrencyOcelot = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyOcelot", 0).getInt();
        this.marketcurrencyWolf = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyWolf", 0).getInt();
        this.marketcurrencyRabbit = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyRabbit", 0).getInt();
        this.marketcurrencyLead = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyLead", 0).getInt();
        this.marketcurrencyNametag = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyNametag", 0).getInt();
        this.marketcurrencyBonemeal = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyBonemeal", 0).getInt();
        this.marketcurrencyFish = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyFish", 0).getInt();
        this.marketcurrencyMeat = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyMeat", 0).getInt();
        this.marketcurrencyBees = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyBees", 0).getInt();
        this.shippingbinbuyCrops = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinbuyCrops", true).getBoolean();
        this.shippingbincropPrice = this.config.get(CATEGORY_SHIPPINGBIN_PRICES, "shippingbincropPrice", 32).getInt();
        this.shippingbinbuyFish = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinbuyFish", true).getBoolean();
        this.shippingbinfishPrice = this.config.get(CATEGORY_SHIPPINGBIN_PRICES, "shippingbinfishPrice", 16).getInt();
        this.shippingbinbuyMeat = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinbuyMeat", true).getBoolean();
        this.shippingbinmeatPrice = this.config.get(CATEGORY_SHIPPINGBIN_PRICES, "shippingbinmeatPrice", 16).getInt();
        this.shippingbinbuyBees = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinbuyBees", true).getBoolean();
        this.shippingbinbeesPrice = this.config.get(CATEGORY_SHIPPINGBIN_PRICES, "shippingbinbeesPrice", 16).getInt();
        shippingbinenablevanillaMCCrops = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinenablevanillaMCCrops", true).getBoolean();
        shippingbinenablevanillaMCFish = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinenablevanillaMCFish", true).getBoolean();
        shippingbinenablevanillaMCMeat = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinenablevanillaMCMeat", true).getBoolean();
        shippingbinenablevanillaMCEgg = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinenablevanillaMCEgg", true).getBoolean();
        shippingbinenablevanillaMCMonsterParts = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinenablevanillaMCMonsterParts", true).getBoolean();
        shippingbinenablevanillaMCBees = this.config.get(CATEGORY_SHIPPINGBIN_PURCHASES, "shippingbinenablevanillaMCBees", true).getBoolean();
    }

    private void initSeedDropSettings() {
        this.seedrarity = this.config.get(CATEGORY_SEEDS, "seedrarity", 1).getInt();
        this.initSeedDropFromGrassSetting("asparagusseeddropfromgrass", "asparagus");
        this.initSeedDropFromGrassSetting("barleyseeddropfromgrass", "barley");
        this.initSeedDropFromGrassSetting("beanseeddropfromgrass", "bean");
        this.initSeedDropFromGrassSetting("beetseeddropfromgrass", "beet");
        this.initSeedDropFromGrassSetting("broccoliseeddropfromgrass", "broccoli");
        this.initSeedDropFromGrassSetting("cauliflowerseeddropfromgrass", "cauliflower");
        this.initSeedDropFromGrassSetting("celeryseeddropfromgrass", "celery");
        this.initSeedDropFromGrassSetting("cranberryseeddropfromgrass", "cranberry");
        this.initSeedDropFromGrassSetting("garlicseeddropfromgrass", "garlic");
        this.initSeedDropFromGrassSetting("gingerseeddropfromgrass", "ginger");
        this.initSeedDropFromGrassSetting("leekseeddropfromgrass", "leek");
        this.initSeedDropFromGrassSetting("lettuceseeddropfromgrass", "lettuce");
        this.initSeedDropFromGrassSetting("oatsseeddropfromgrass", "oats");
        this.initSeedDropFromGrassSetting("onionseeddropfromgrass", "onion");
        this.initSeedDropFromGrassSetting("parsnipseeddropfromgrass", "parsnip");
        this.initSeedDropFromGrassSetting("peanutseeddropfromgrass", "peanut");
        this.initSeedDropFromGrassSetting("pineappleseeddropfromgrass", "pineapple");
        this.initSeedDropFromGrassSetting("radishseeddropfromgrass", "radish");
        this.initSeedDropFromGrassSetting("riceseeddropfromgrass", "rice");
        this.initSeedDropFromGrassSetting("rutabagaseeddropfromgrass", "rutabaga");
        this.initSeedDropFromGrassSetting("ryeseeddropfromgrass", "rye");
        this.initSeedDropFromGrassSetting("scallionseeddropfromgrass", "scallion");
        this.initSeedDropFromGrassSetting("soybeanseeddropfromgrass", "soybean");
        this.initSeedDropFromGrassSetting("spiceleafseeddropfromgrass", "spiceleaf");
        this.initSeedDropFromGrassSetting("sweetpotatoseeddropfromgrass", "sweetpotato");
        this.initSeedDropFromGrassSetting("teaseeddropfromgrass", "tealeaf");
        this.initSeedDropFromGrassSetting("turnipseeddropfromgrass", "turnip");
        this.initSeedDropFromGrassSetting("whitemushroomseeddropfromgrass", "whitemushroom");
        this.initSeedDropFromGrassSetting("artichokeseeddropfromgrass", "artichoke");
        this.initSeedDropFromGrassSetting("bellpepperseeddropfromgrass", "bellpepper");
        this.initSeedDropFromGrassSetting("blackberryseeddropfromgrass", "blackberry");
        this.initSeedDropFromGrassSetting("blueberryseeddropfromgrass", "blueberry");
        this.initSeedDropFromGrassSetting("brusselsproutseeddropfromgrass", "brusselsprout");
        this.initSeedDropFromGrassSetting("cabbageseeddropfromgrass", "cabbage");
        this.initSeedDropFromGrassSetting("cactusfruitseeddropfromgrass", "cactusfruit");
        this.initSeedDropFromGrassSetting("candleberryseeddropfromgrass", "candleberry");
        this.initSeedDropFromGrassSetting("cantaloupeseeddropfromgrass", "cantaloupe");
        this.initSeedDropFromGrassSetting("chilipepperseeddropfromgrass", "chilipepper");
        this.initSeedDropFromGrassSetting("coffeeseeddropfromgrass", "coffeebean");
        this.initSeedDropFromGrassSetting("cornseeddropfromgrass", "corn");
        this.initSeedDropFromGrassSetting("cottonseeddropfromgrass", "cotton");
        this.initSeedDropFromGrassSetting("cucumberseeddropfromgrass", "cucumber");
        this.initSeedDropFromGrassSetting("eggplantseeddropfromgrass", "eggplant");
        this.initSeedDropFromGrassSetting("grapeseeddropfromgrass", "grape");
        this.initSeedDropFromGrassSetting("kiwiseeddropfromgrass", "kiwi");
        this.initSeedDropFromGrassSetting("mustardseeddropfromgrass", "mustardseeds");
        this.initSeedDropFromGrassSetting("okraseeddropfromgrass", "okra");
        this.initSeedDropFromGrassSetting("peasseeddropfromgrass", "peas");
        this.initSeedDropFromGrassSetting("raspberryseeddropfromgrass", "raspberry");
        this.initSeedDropFromGrassSetting("rhubarbseeddropfromgrass", "rhubarb");
        this.initSeedDropFromGrassSetting("seaweedseeddropfromgrass", "seaweed");
        this.initSeedDropFromGrassSetting("strawberryseeddropfromgrass", "strawberry");
        this.initSeedDropFromGrassSetting("tomatoseeddropfromgrass", "tomato");
        this.initSeedDropFromGrassSetting("wintersquashseeddropfromgrass", "wintersquash");
        this.initSeedDropFromGrassSetting("zucchiniseeddropfromgrass", "zucchini");
        this.initSeedDropFromGrassSetting("bambooshootseeddropfromgrass", "bambooshoot");
        this.initSeedDropFromGrassSetting("spinachseeddropfromgrass", "spinach");
        this.initSeedDropFromGrassSetting("curryleafseeddropfromgrass", "curryleaf");
        this.initSeedDropFromGrassSetting("sesameseedsseeddropfromgrass", "sesameseeds");
        this.initSeedDropFromGrassSetting("waterchestnutseeddropfromgrass", "waterchestnut");
    }

    private void initMiscRecipesSettings() {
        this.enablesaltfromwaterbucketrecipe = this.config.get(CATEGORY_MISC_RECIPES, "enablesaltfromwaterbucketrecipe", true).getBoolean();
        this.enablecroptoseedRecipe = this.config.get(CATEGORY_MISC_RECIPES, "enablecroptoseedRecipe", true).getBoolean();
        this.enableTofuAsMeatInRecipes = this.config.get(CATEGORY_MISC_RECIPES, "enabletofuasmeatinRecipes", true).getBoolean();
        this.enableTofuAsMilkInRecipes = this.config.get(CATEGORY_MISC_RECIPES, "enabletofuasmilkinRecipes", true).getBoolean();
        this.enablelistAllwaterfreshwater = this.config.get(CATEGORY_MISC_RECIPES, "enablelistAllwaterfreshwater", true).getBoolean();
        this.enablelistAllwatervanillawaterbucket = this.config.get(CATEGORY_MISC_RECIPES, "enablelistAllwatervanillawaterbucket", true).getBoolean();
        this.marketblockrecipeItem = this.config.get(CATEGORY_MISC_RECIPES, "marketblockrecipeItem", 0).getInt();
        this.enablemaplesyrupslimeballPresser = this.config.get(CATEGORY_MISC_RECIPES, "enablemaplesyrupslimeballPresser", true).getBoolean();
        this.enablehoneyslimeballPresser = this.config.get(CATEGORY_MISC_RECIPES, "enablehoneyslimeballPresser", true).getBoolean();
    }

    private void initSeedDropFromGrassSetting(String key, String item) {
        boolean doDrop = this.config.get(CATEGORY_SEEDS, key, false).getBoolean();
        this.seedDropFromGrass.put(item, doDrop);
    }

    public void configureGardenDrops() {
        Pattern ITEM_STACK_PATTERN = Pattern.compile("(?:([0-9]+)x)?([\\w:]+)(?:[@:]([0-9]+))?");
        Matcher ITEM_STACK_MATCHER = ITEM_STACK_PATTERN.matcher("");
        for (String garden : this.gardenDropConfig.keySet()) {
            String[] itemNames;
            HarvestCraft.log.info("Registering drops for %s.", (Object)garden);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (String baseItemName : itemNames = this.gardenDropConfig.get(garden)) {
                ItemStack drop;
                ITEM_STACK_MATCHER.reset(baseItemName);
                if (!ITEM_STACK_MATCHER.find()) continue;
                String itemName = ITEM_STACK_MATCHER.group(2);
                int metadata = 0;
                if (ITEM_STACK_MATCHER.group(3) != null) {
                    metadata = Integer.parseInt(ITEM_STACK_MATCHER.group(3));
                }
                int stackSize = 1;
                if (ITEM_STACK_MATCHER.group(1) != null) {
                    stackSize = Integer.parseInt(ITEM_STACK_MATCHER.group(1));
                }
                if ((drop = GameRegistry.makeItemStack((String)itemName, (int)metadata, (int)stackSize, null)) != null) {
                    drops.add(drop);
                    continue;
                }
                HarvestCraft.log.error("Unable to find item %s to add to this garden.", (Object)baseItemName);
            }
            BlockBaseGarden.drops.put(garden, drops);
        }
    }
}

