/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.zenscript;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.socket.SingleError;
import crafttweaker.zenscript.GlobalRegistry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.compiler.ClassNameGenerator;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class CrTGlobalEnvironment
implements IEnvironmentGlobal {
    private final Map<String, byte[]> classes;
    private final Map<String, IZenSymbol> symbols;
    private final ClassNameGenerator generator;
    private List<SingleError> errors = new ArrayList<SingleError>();

    public CrTGlobalEnvironment(Map<String, byte[]> classes) {
        this.classes = classes;
        this.symbols = new HashMap<String, IZenSymbol>();
        this.generator = new ClassNameGenerator();
    }

    @Override
    public IZenCompileEnvironment getEnvironment() {
        return GlobalRegistry.getEnvironment();
    }

    @Override
    public TypeExpansion getExpansion(String name) {
        return GlobalRegistry.getExpansions().get(name);
    }

    @Override
    public String makeClassName() {
        return this.generator.generate();
    }

    @Override
    public boolean containsClass(String name) {
        return this.classes.containsKey(name);
    }

    @Override
    public void putClass(String name, byte[] data) {
        this.classes.put(name, data);
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.symbols.containsKey(name)) {
            return this.symbols.get(name).instance(position);
        }
        if (GlobalRegistry.getGlobals().containsKey(name)) {
            return GlobalRegistry.getGlobals().get(name).instance(position);
        }
        IZenSymbol pkg = GlobalRegistry.getRoot().get(name);
        if (pkg == null) {
            return null;
        }
        return pkg.instance(position);
    }

    @Override
    public void putValue(String name, IZenSymbol value, ZenPosition position) {
        if (this.symbols.containsKey(name)) {
            this.error(position, "Value already defined in this scope: " + name);
        } else {
            this.symbols.put(name, value);
        }
    }

    @Override
    public ZenType getType(Type type) {
        return GlobalRegistry.getTypes().getType(type);
    }

    @Override
    public void error(ZenPosition position, String message) {
        CraftTweakerAPI.logError(position.toString() + " > " + message);
        this.errors.add(new SingleError(position.getFile().getFileName(), position.getLine(), position.getLineOffset(), message, SingleError.Level.ERROR));
    }

    @Override
    public void warning(ZenPosition position, String message) {
        CraftTweakerAPI.logWarning(position.toString() + " > " + message);
        this.errors.add(new SingleError(position.getFile().getFileName(), position.getLine(), position.getLineOffset(), message, SingleError.Level.WARN));
    }

    @Override
    public void info(ZenPosition position, String message) {
        CraftTweakerAPI.logInfo(position.toString() + " > " + message);
        this.errors.add(new SingleError(position.getFile().getFileName(), position.getLine(), position.getLineOffset(), message, SingleError.Level.INFO));
    }

    @Override
    public Set<String> getClassNames() {
        return this.classes.keySet();
    }

    @Override
    public byte[] getClass(String name) {
        return this.classes.get(name);
    }

    @Override
    public void error(String message) {
        CraftTweakerAPI.logError(message);
    }

    @Override
    public void error(String message, Throwable e) {
        CraftTweakerAPI.logError(message, e);
    }

    @Override
    public void warning(String message) {
        CraftTweakerAPI.logWarning(message);
    }

    @Override
    public void info(String message) {
        CraftTweakerAPI.logInfo(message);
    }

    public void clear() {
        this.errors.clear();
    }

    public List<SingleError> getErrors() {
        return this.errors;
    }
}

