/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.data;

import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.IData;
import crafttweaker.api.data.IDataConverter;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataString
implements IData {
    private final String value;

    public DataString(String value) {
        this.value = value;
    }

    @Override
    public boolean asBool() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    public byte asByte() {
        return Byte.parseByte(this.value);
    }

    @Override
    public short asShort() {
        return Short.parseShort(this.value);
    }

    @Override
    public int asInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    public long asLong() {
        return Long.parseLong(this.value);
    }

    @Override
    public float asFloat() {
        return Float.parseFloat(this.value);
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.value);
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public List<IData> asList() {
        return null;
    }

    @Override
    public Map<String, IData> asMap() {
        return Collections.singletonMap(this.value, this);
    }

    @Override
    public byte[] asByteArray() {
        return null;
    }

    @Override
    public int[] asIntArray() {
        return null;
    }

    @Override
    public IData getAt(int i) {
        return new DataString(this.value.substring(i, i + 1));
    }

    @Override
    public void setAt(int i, IData value) {
        throw new UnsupportedOperationException("Strings are immutable");
    }

    @Override
    public IData memberGet(String name) {
        if (name.equals("length")) {
            return new DataInt(this.value.length());
        }
        throw new UnsupportedOperationException("no such member: " + name);
    }

    @Override
    public void memberSet(String name, IData data) {
        throw new UnsupportedOperationException("Strings are immutable");
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public boolean contains(IData data) {
        return data.asString().equals(this.value);
    }

    @Override
    public boolean equals(IData data) {
        return this.value.equals(data.asString());
    }

    @Override
    public int compareTo(IData data) {
        return this.value.compareTo(data.asString());
    }

    @Override
    public IData immutable() {
        return this;
    }

    @Override
    public IData update(IData data) {
        return data;
    }

    @Override
    public <T> T convert(IDataConverter<T> converter) {
        return converter.fromString(this.value);
    }

    @Override
    public IData add(IData other) {
        return new DataString(this.value + other.asString());
    }

    @Override
    public IData sub(IData other) {
        throw new UnsupportedOperationException("Cannot subtract from a string");
    }

    @Override
    public IData mul(IData other) {
        throw new UnsupportedOperationException("Cannot multiply a string");
    }

    @Override
    public IData div(IData other) {
        throw new UnsupportedOperationException("Cannot divide a string");
    }

    @Override
    public IData mod(IData other) {
        throw new UnsupportedOperationException("Cannot perform modulo on a string");
    }

    @Override
    public IData and(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public IData or(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public IData xor(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public IData neg() {
        throw new UnsupportedOperationException("Cannot negate a string");
    }

    @Override
    public IData not() {
        throw new UnsupportedOperationException("Cannot perform bitwise arithmetic on a string");
    }

    @Override
    public String toString() {
        return DataString.quoteAndEscape(this.value);
    }

    public static String quoteAndEscape(String p_193588_0_) {
        StringBuilder stringbuilder = new StringBuilder("\"");
        for (int i = 0; i < p_193588_0_.length(); ++i) {
            char c0 = p_193588_0_.charAt(i);
            if (c0 == '\\' || c0 == '\"') {
                stringbuilder.append('\\');
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.append('\"').toString();
    }
}

