/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import mod.chiselsandbits.config.ModConfig;
import mod.chiselsandbits.crafting.BitSawCrafting;
import mod.chiselsandbits.crafting.ChiselBlockCrafting;
import mod.chiselsandbits.crafting.ChiselCrafting;
import mod.chiselsandbits.crafting.MirrorTransferCrafting;
import mod.chiselsandbits.crafting.NegativeInversionCrafting;
import mod.chiselsandbits.crafting.StackableCrafting;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRecipes {
    final ModConfig config;

    public ModRecipes(ModConfig modConfig) {
        this.config = modConfig;
    }

    @SubscribeEvent
    void registerRecipes(RegistryEvent.Register<IRecipe> e) {
        IForgeRegistry r = e.getRegistry();
        String MODID = "chiselsandbits";
        if (this.config.enablePositivePrintCrafting) {
            r.register((IForgeRegistryEntry)new ChiselCrafting(new ResourceLocation(MODID, "positiveprintcrafting")));
        }
        if (this.config.enableChiselCrafting) {
            r.register((IForgeRegistryEntry)new ChiselBlockCrafting(new ResourceLocation(MODID, "chiselcrafting")));
        }
        if (this.config.enableStackableCrafting) {
            r.register((IForgeRegistryEntry)new StackableCrafting(new ResourceLocation(MODID, "stackablecrafting")));
        }
        if (this.config.enableNegativePrintInversionCrafting) {
            r.register((IForgeRegistryEntry)new NegativeInversionCrafting(new ResourceLocation(MODID, "negativepatterncrafting")));
        }
        if (this.config.enableMirrorPrint) {
            r.register((IForgeRegistryEntry)new MirrorTransferCrafting(new ResourceLocation(MODID, "mirrorpatterncrafting")));
        }
        if (this.config.enableBitSaw) {
            r.register((IForgeRegistryEntry)new BitSawCrafting(new ResourceLocation(MODID, "bitsawcrafting")));
        }
    }
}

