/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Tools {
    public static IBlockState stringToState(String s) {
        if (s.contains("@")) {
            String[] split = StringUtils.split((String)s, (char)'@');
            Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
            if (value == null) {
                throw new RuntimeException("Cannot find block: '" + split[0] + "'!");
            }
            try {
                int meta = Integer.parseInt(split[1]);
                return value.func_176203_a(meta);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Bad meta for: '" + s + "'!");
            }
        }
        Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
        if (value == null) {
            throw new RuntimeException("Cannot find block: '" + s + "'!");
        }
        return value.func_176223_P();
    }

    public static String stateToString(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == 0) {
            return state.func_177230_c().getRegistryName().toString();
        }
        return state.func_177230_c().getRegistryName().toString() + "@" + meta;
    }

    public static String getRandomFromList(Random random, List<Pair<Float, String>> list) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<Pair<Float, String>> elements = new ArrayList<Pair<Float, String>>();
        float totalweight = 0.0f;
        for (Pair<Float, String> pair : list) {
            elements.add(pair);
            totalweight += ((Float)pair.getKey()).floatValue();
        }
        float r = random.nextFloat() * totalweight;
        for (Pair pair : elements) {
            if (!((r -= ((Float)pair.getKey()).floatValue()) <= 0.0f)) continue;
            return (String)pair.getRight();
        }
        return null;
    }

    public static int calcIndex(int x, int y, int z) {
        return x << 12 | (z << 8) + y;
    }
}

