/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.config;

import io.github.drmanganese.topaddons.network.MessageClientOptions;
import io.github.drmanganese.topaddons.network.PacketHandler;
import io.github.drmanganese.topaddons.reference.ElementSync;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConfigClient {
    private static Configuration config;
    private static String fluidGaugeDisplay;
    private static boolean forestryReasonCrouch;
    private static boolean showPitch;
    private static boolean smelteryInIngots;
    private static boolean colorDragonName;
    private static boolean stevesOtherModules;

    public static void init(Configuration configIn) {
        config = configIn;
        config.load();
        ConfigCategory oldOptions = config.getCategory("Options");
        if (oldOptions != null) {
            config.removeCategory(oldOptions);
        }
        fluidGaugeDisplay = config.getString("fluidGaugeDisplay", "Client Options", "Both", "Which tank gauge(s) to display (The One Probe, TOP Addons, Both).", new String[]{"The One Probe", "TOP Addons", "Both"});
        forestryReasonCrouch = config.getBoolean("forestryReasonCrouch", "Client Options", false, "Only show Forestry machines' important failure reasons when crouching.");
        showPitch = config.getBoolean("showPitch", "Client Options", true, "Display pitch and instrument on Note Blocks.");
        smelteryInIngots = config.getBoolean("smelteryInIngots", "Client Options", true, "Show smeltery fluid volume in ingots.");
        colorDragonName = config.getBoolean("colorDragonName", "Client Options", true, "Color the name of an Ice and Fire dragon depending on its type.");
        stevesOtherModules = config.getBoolean("stevesOtherModules", "Client Options", false, "Display installed modules when sneaking.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("topaddons")) {
            config.save();
            if (event.isWorldRunning()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageClientOptions(ConfigClient.getClientValues(config), ElementSync.elementIds, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            }
        }
    }

    public static Map<String, Integer> getClientValues(Configuration config) {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        block5: for (Map.Entry entry : config.getCategory("Client Options").entrySet()) {
            Property prop = (Property)entry.getValue();
            switch (((Property)entry.getValue()).getType()) {
                case BOOLEAN: {
                    values.put((String)entry.getKey(), prop.getBoolean() ? 1 : 0);
                    break;
                }
                case INTEGER: {
                    values.put((String)entry.getKey(), prop.getInt());
                    break;
                }
                case STRING: {
                    for (int i = 0; i < prop.getValidValues().length; ++i) {
                        if (!prop.getValidValues()[i].equals(prop.getString())) continue;
                        values.put((String)entry.getKey(), i);
                    }
                    continue block5;
                }
                default: {
                    values.put((String)entry.getKey(), ((Property)entry.getValue()).getInt());
                }
            }
        }
        return values;
    }

    static {
        fluidGaugeDisplay = "Both";
        forestryReasonCrouch = false;
        showPitch = true;
        smelteryInIngots = true;
        colorDragonName = true;
        stevesOtherModules = false;
    }
}

