/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.magic;

import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.WorkUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EnchantmentExtractorTile
extends CustomElectricMachine {
    private ItemStackHandler inBook;
    private ItemStackHandler inEnchanted;
    private ItemStackHandler outItem;
    private ItemStackHandler outEnchanted;

    public EnchantmentExtractorTile() {
        super(EnchantmentExtractorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.initInputInv();
        this.initOutputInv();
    }

    private void initInputInv() {
        this.inBook = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                EnchantmentExtractorTile.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inBook, EnumDyeColor.BROWN, "Input books", 54, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals(Items.field_151122_aG);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        super.addInventoryToStorage(this.inBook, "ench_books");
        this.inEnchanted = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                EnchantmentExtractorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inEnchanted, EnumDyeColor.PURPLE, "Input enchanted items", 54, 61, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77948_v() && stack.func_77973_b().func_77616_k(stack) || stack.func_77973_b().equals(Items.field_151134_bR);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.inEnchanted, "ench_ext_in_items");
    }

    private void initOutputInv() {
        this.outEnchanted = new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                EnchantmentExtractorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outEnchanted, EnumDyeColor.MAGENTA, "Enchanted Books", 86, 25, 4, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outEnchanted, "ench_ext_out_book");
        this.outItem = new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                EnchantmentExtractorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItem, EnumDyeColor.YELLOW, "Enchantless Items", 86, 61, 4, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItem, "ench_ext_out_items");
    }

    private boolean hasBooks() {
        return !this.inBook.getStackInSlot(0).func_190926_b();
    }

    private ItemStack getItem() {
        return this.inEnchanted.getStackInSlot(0);
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.getItem().func_77973_b().equals(Items.field_151134_bR) && ItemEnchantedBook.func_92110_g((ItemStack)this.getItem()).func_74745_c() == 1 && ItemHandlerHelper.insertItem((IItemHandler)this.outEnchanted, (ItemStack)this.getItem().func_77946_l(), (boolean)true).func_190926_b()) {
            ItemHandlerHelper.insertItem((IItemHandler)this.outEnchanted, (ItemStack)this.getItem().func_77946_l(), (boolean)false);
            this.getItem().func_190920_e(0);
            return 1.0f;
        }
        if (!this.hasBooks() || this.getItem().func_190926_b()) {
            return 0.0f;
        }
        ItemStack enchantedItem = this.getItem();
        ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
        if (ItemHandlerHelper.insertItem((IItemHandler)this.outEnchanted, (ItemStack)enchantedBook, (boolean)true).func_190926_b() && ItemHandlerHelper.insertItem((IItemHandler)this.outItem, (ItemStack)enchantedItem, (boolean)true).func_190926_b()) {
            NBTTagCompound base = null;
            if (enchantedItem.func_77973_b().equals(Items.field_151134_bR) && ItemEnchantedBook.func_92110_g((ItemStack)enchantedItem).func_74745_c() > 0) {
                for (int i = 0; i < ItemEnchantedBook.func_92110_g((ItemStack)enchantedItem).func_74745_c(); ++i) {
                    if (!(ItemEnchantedBook.func_92110_g((ItemStack)enchantedItem).func_179238_g(i) instanceof NBTTagCompound)) continue;
                    base = (NBTTagCompound)ItemEnchantedBook.func_92110_g((ItemStack)enchantedItem).func_179238_g(i);
                    NBTTagCompound tagCompound = enchantedItem.func_77978_p();
                    NBTTagList list = ItemEnchantedBook.func_92110_g((ItemStack)enchantedItem);
                    list.func_74744_a(i);
                    tagCompound.func_74782_a("StoredEnchantments", (NBTBase)list);
                    enchantedItem.func_77982_d(tagCompound);
                    break;
                }
            } else if (enchantedItem.func_77986_q().func_74745_c() > 0 && enchantedItem.func_77986_q().func_179238_g(0) instanceof NBTTagCompound) {
                base = (NBTTagCompound)enchantedItem.func_77986_q().func_179238_g(0);
                enchantedItem.func_77986_q().func_74744_a(0);
            }
            if (base != null && Enchantment.func_185262_c((int)base.func_74765_d("id")) != null) {
                ItemEnchantedBook.func_92115_a((ItemStack)enchantedBook, (EnchantmentData)new EnchantmentData(Enchantment.func_185262_c((int)base.func_74765_d("id")), (int)base.func_74765_d("lvl")));
                if (enchantedItem.func_77986_q().func_82582_d() && enchantedItem.func_77978_p() != null && enchantedItem.func_77978_p().func_74764_b("ench")) {
                    enchantedItem.func_77978_p().func_82580_o("ench");
                    if (enchantedItem.func_77978_p().func_82582_d()) {
                        enchantedItem.func_77982_d(null);
                    }
                }
                ItemHandlerHelper.insertItem((IItemHandler)this.outEnchanted, (ItemStack)enchantedBook, (boolean)false);
                this.inBook.getStackInSlot(0).func_190920_e(this.inBook.getStackInSlot(0).func_190916_E() - 1);
                if (enchantedItem.func_77973_b().equals(Items.field_151134_bR) && ItemEnchantedBook.func_92110_g((ItemStack)enchantedItem).func_74745_c() == 1 || !enchantedItem.func_77973_b().equals(Items.field_151134_bR) && !enchantedItem.func_77948_v()) {
                    ItemStack stack = enchantedItem.func_77946_l();
                    stack.func_82841_c((stack.func_82838_A() - 1) / 2);
                    if (stack.func_77978_p() != null && stack.func_82838_A() <= 0) {
                        stack.func_77978_p().func_82580_o("RepairCost");
                        if (stack.func_77978_p().func_82582_d()) {
                            stack.func_77982_d(null);
                        }
                    }
                    ItemHandlerHelper.insertItem((IItemHandler)this.outItem, (ItemStack)stack, (boolean)false);
                    enchantedItem.func_190920_e(enchantedItem.func_190916_E() - 1);
                }
            }
            return 1.0f;
        }
        return 0.0f;
    }
}

