/*
 * Decompiled with CFR 0.152.
 */
package jackyy.integrationforegoing.integration.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import jackyy.integrationforegoing.util.ModConfig;
import jackyy.integrationforegoing.util.ModUtils;
import jackyy.integrationforegoing.util.Reference;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlantRecollectableNatura {
    @SubscribeEvent
    public void register(RegistryEvent.Register<PlantRecollectable> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new PlantRecollectable("natura_berry_bush"){

            public boolean canBeHarvested(World world, BlockPos pos, IBlockState blockState) {
                return blockState.func_177230_c().func_176201_c(blockState) == 3 && blockState.func_177230_c().getRegistryName().func_110624_b().equals("natura") && blockState.func_177230_c().getRegistryName().func_110623_a().contains("berrybush");
            }

            public List<ItemStack> doHarvestOperation(World world, BlockPos pos, IBlockState blockState) {
                NonNullList stacks = NonNullList.func_191196_a();
                switch (blockState.func_177230_c().getRegistryName().func_110623_a()) {
                    case "overworld_berrybush_raspberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 2));
                        break;
                    }
                    case "overworld_berrybush_blueberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 3));
                        break;
                    }
                    case "overworld_berrybush_blackberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 4));
                        break;
                    }
                    case "overworld_berrybush_maloberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 5));
                        break;
                    }
                    case "nether_berrybush_blightberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 6));
                        break;
                    }
                    case "nether_berrybush_duskberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 7));
                        break;
                    }
                    case "nether_berrybush_skyberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 8));
                        break;
                    }
                    case "nether_berrybush_stingberry": {
                        stacks.add(0, (Object)ModUtils.getItemStackByName("natura", "edibles", 1, 9));
                    }
                }
                world.func_175656_a(pos, blockState.func_177226_a((IProperty)Reference.NATURA_BERRIES_AGE, (Comparable)Integer.valueOf(2)));
                return stacks;
            }

            public boolean shouldCheckNextPlant(World world, BlockPos pos, IBlockState blockState) {
                return true;
            }

            public List<String> getRecollectablesNames() {
                return Collections.singletonList("text.integrationforegoing.plant.natura_berry_bush");
            }
        });
        registry.register((IForgeRegistryEntry)new PlantRecollectable("natura_crops"){

            public boolean canBeHarvested(World world, BlockPos pos, IBlockState blockState) {
                ResourceLocation regname = blockState.func_177230_c().getRegistryName();
                if (regname.func_110624_b().equals("natura") && regname.func_110623_a().equals("barley_crop")) {
                    return blockState.func_177230_c().func_176201_c(blockState) == 3;
                }
                if (regname.func_110624_b().equals("natura") && regname.func_110623_a().equals("cotton_crop")) {
                    return blockState.func_177230_c().func_176201_c(blockState) == 4;
                }
                return false;
            }

            public List<ItemStack> doHarvestOperation(World world, BlockPos pos, IBlockState blockState) {
                NonNullList stacks = NonNullList.func_191196_a();
                blockState.func_177230_c().getDrops(stacks, (IBlockAccess)world, pos, blockState, 0);
                if (ModConfig.misc.natura.naturaCropsReplant) {
                    world.func_175698_g(pos);
                } else {
                    for (int i = 0; i < stacks.size(); ++i) {
                        if (((ItemStack)stacks.get(i)).func_77973_b() != ModUtils.getItemByName("natura", "overworld_seeds")) continue;
                        stacks.remove(i);
                    }
                    switch (blockState.func_177230_c().getRegistryName().func_110623_a()) {
                        case "barley_crop": {
                            world.func_175656_a(pos, blockState.func_177226_a((IProperty)Reference.NATURA_BARLEY_AGE, (Comparable)Integer.valueOf(1)));
                            break;
                        }
                        case "cotton_crop": {
                            world.func_175656_a(pos, blockState.func_177226_a((IProperty)Reference.NATURA_COTTON_AGE, (Comparable)Integer.valueOf(2)));
                        }
                    }
                }
                return stacks;
            }

            public boolean shouldCheckNextPlant(World world, BlockPos pos, IBlockState blockState) {
                return true;
            }

            public List<String> getRecollectablesNames() {
                return ModConfig.misc.natura.naturaCropsReplant ? Collections.singletonList("text.integrationforegoing.plant.natura_crops_replant") : Collections.singletonList("text.integrationforegoing.plant.natura_crops_no_replant");
            }
        });
    }
}

