/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SkylineHelper {
    public static EntitySkylineHook spawnHook(EntityPlayer player, TileEntity start, ImmersiveNetHandler.Connection connection) {
        BlockPos cc0 = connection.end == Utils.toCC(start) ? connection.start : connection.end;
        BlockPos cc1 = connection.end == Utils.toCC(start) ? connection.end : connection.start;
        IImmersiveConnectable iicStart = ApiUtils.toIIC(cc1, player.field_70170_p);
        IImmersiveConnectable iicEnd = ApiUtils.toIIC(cc0, player.field_70170_p);
        Vec3d vStart = new Vec3d((Vec3i)cc1);
        Vec3d vEnd = new Vec3d((Vec3i)cc0);
        if (iicStart != null) {
            vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
        }
        if (iicEnd != null) {
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));
        }
        Vec3d pos = player.func_174824_e(0.0f);
        Vec3d across = new Vec3d(vEnd.field_72450_a - vStart.field_72450_a, vEnd.field_72448_b - vStart.field_72448_b, vEnd.field_72449_c - vStart.field_72449_c);
        double t = Utils.getCoeffForMinDistance(pos, vStart, across);
        connection.getSubVertices(player.field_70170_p);
        pos = connection.getVecAt(t, vStart, across, Math.sqrt(across.field_72450_a * across.field_72450_a + across.field_72449_c * across.field_72449_c));
        Vec3d[] steps = ApiUtils.getConnectionCatenary(connection, vStart, vEnd);
        int tInt = MathHelper.func_76125_a((int)((int)(t * 17.0)), (int)0, (int)16);
        EntitySkylineHook hook = new EntitySkylineHook(player.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, connection, cc0, steps, tInt + 1);
        float speed = 1.0f;
        if (!player.func_184607_cu().func_190926_b() && player.func_184607_cu().func_77973_b() instanceof ItemSkyhook) {
            speed = ((ItemSkyhook)player.func_184607_cu().func_77973_b()).getSkylineSpeed(player.func_184607_cu());
        }
        Vec3d moveVec = SkylineHelper.getSubMovementVector(steps[tInt], steps[tInt + 1], speed);
        hook.field_70159_w = moveVec.field_72450_a;
        hook.field_70181_x = moveVec.field_72448_b;
        hook.field_70179_y = moveVec.field_72449_c;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72838_d((Entity)hook);
        }
        ItemSkyhook.existingHooks.put(player.func_70005_c_(), hook);
        player.func_184220_m((Entity)hook);
        return hook;
    }

    public static Vec3d getSubMovementVector(Vec3d start, Vec3d target, float speed) {
        Vec3d movementVec = new Vec3d(target.field_72450_a - start.field_72450_a, target.field_72448_b - start.field_72448_b, target.field_72449_c - start.field_72449_c);
        int lPixel = (int)Math.max(1.0, movementVec.func_72433_c() / (0.125 * (double)speed));
        return new Vec3d(movementVec.field_72450_a / (double)lPixel, movementVec.field_72448_b / (double)lPixel, movementVec.field_72449_c / (double)lPixel);
    }

    public static boolean isInBlock(EntityPlayer player, World w) {
        BlockPos init = player.func_180425_c();
        AxisAlignedBB hitbox = player.func_174813_aQ();
        hitbox = new AxisAlignedBB(hitbox.field_72340_a - 1.0, hitbox.field_72338_b - 1.0, hitbox.field_72339_c - 1.0, hitbox.field_72336_d, hitbox.field_72337_e, hitbox.field_72334_f);
        for (int xOff = 0; xOff < 2; ++xOff) {
            for (int yOff = 0; yOff < 3; ++yOff) {
                for (int zOff = 0; zOff < 2; ++zOff) {
                    Vec3d v = new Vec3d((double)(init.func_177958_n() + xOff), (double)(init.func_177956_o() + yOff), (double)(init.func_177952_p() + zOff));
                    if (!hitbox.func_72318_a(v) || w.func_175623_d(new BlockPos(v))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

