/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySorter
extends TileEntityIEBase
implements IEBlockInterfaces.IGuiTile {
    public SorterInventory filter;
    public int[] sideFilter = new int[]{0, 0, 0, 0, 0, 0};
    public static final int filterSlotsPerSide = 8;
    private static Set<BlockPos> routed = null;
    IItemHandler[] insertionHandlers = new IItemHandler[]{new SorterInventoryHandler(this, EnumFacing.DOWN), new SorterInventoryHandler(this, EnumFacing.UP), new SorterInventoryHandler(this, EnumFacing.NORTH), new SorterInventoryHandler(this, EnumFacing.SOUTH), new SorterInventoryHandler(this, EnumFacing.WEST), new SorterInventoryHandler(this, EnumFacing.EAST)};

    public TileEntitySorter() {
        this.filter = new SorterInventory(this);
    }

    public ItemStack routeItem(EnumFacing inputSide, ItemStack stack, boolean simulate) {
        if (!this.field_145850_b.field_72995_K && this.canRoute()) {
            boolean first = this.startRouting();
            EnumFacing[][] validOutputs = this.getValidOutputs(inputSide, stack);
            stack = this.doInsert(stack, validOutputs[0], simulate);
            stack = this.doInsert(stack, validOutputs[1], simulate);
            if (first) {
                routed = null;
            }
        }
        return stack;
    }

    private boolean canRoute() {
        return routed == null || !routed.contains(this.field_174879_c);
    }

    private boolean startRouting() {
        boolean first;
        boolean bl = first = routed == null;
        if (first) {
            routed = new HashSet<BlockPos>();
        }
        routed.add(this.field_174879_c);
        return first;
    }

    private ItemStack doInsert(ItemStack stack, EnumFacing[] sides, boolean simulate) {
        for (int lengthFiltered = sides.length; lengthFiltered > 0 && !stack.func_190926_b(); --lengthFiltered) {
            int rand = Utils.RAND.nextInt(lengthFiltered);
            stack = this.outputItemToInv(stack, sides[rand], simulate);
            sides[rand] = sides[lengthFiltered - 1];
        }
        return stack;
    }

    public boolean doOredict(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 1) != 0;
        }
        return false;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 2) != 0;
        }
        return false;
    }

    public boolean doFuzzy(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 4) != 0;
        }
        return false;
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 6;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.func_74764_b("sideConfig")) {
            this.sideFilter = message.func_74759_k("sideConfig");
        }
    }

    public EnumFacing[][] getValidOutputs(EnumFacing inputSide, ItemStack stack) {
        if (stack.func_190926_b()) {
            return new EnumFacing[][]{new EnumFacing[0], new EnumFacing[0], new EnumFacing[0], new EnumFacing[0]};
        }
        ArrayList<EnumFacing> validFiltered = new ArrayList<EnumFacing>(6);
        ArrayList<EnumFacing> validUnfiltered = new ArrayList<EnumFacing>(6);
        for (EnumFacing side : EnumFacing.values()) {
            if (side == inputSide) continue;
            EnumFilterResult result = this.checkStackAgainstFilter(stack, side);
            if (result == EnumFilterResult.VALID_FILTERED) {
                validFiltered.add(side);
                continue;
            }
            if (result != EnumFilterResult.VALID_UNFILTERED) continue;
            validUnfiltered.add(side);
        }
        return new EnumFacing[][]{validFiltered.toArray(new EnumFacing[0]), validUnfiltered.toArray(new EnumFacing[0])};
    }

    public ItemStack pullItem(EnumFacing outputSide, int amount, boolean simulate) {
        if (!this.field_145850_b.field_72995_K && this.canRoute()) {
            boolean first = this.startRouting();
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity neighbourTile;
                if (side == outputSide || (neighbourTile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side))) == null || !neighbourTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) continue;
                Predicate<ItemStack> concatFilter = null;
                IItemHandler itemHandler = (IItemHandler)neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack extractItem = itemHandler.extractItem(i, amount, simulate);
                    if (extractItem.func_190926_b()) continue;
                    if (concatFilter == null) {
                        concatFilter = this.concatFilters(outputSide, side);
                    }
                    if (!concatFilter.test(extractItem)) continue;
                    if (first) {
                        routed = null;
                    }
                    return extractItem;
                }
            }
            if (first) {
                routed = null;
            }
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareStackToFilterstack(ItemStack stack, ItemStack filterStack, boolean fuzzy, boolean oredict, boolean nbt) {
        boolean b = OreDictionary.itemMatches((ItemStack)filterStack, (ItemStack)stack, (boolean)true);
        if (!b && fuzzy) {
            b = filterStack.func_77973_b().equals(stack.func_77973_b());
        }
        if (!b && oredict) {
            for (String name : OreDictionary.getOreNames()) {
                if (!Utils.compareToOreName(stack, name) || !Utils.compareToOreName(filterStack, name)) continue;
                b = true;
                break;
            }
        }
        if (nbt) {
            b &= Utils.compareItemNBT(filterStack, stack);
        }
        return b;
    }

    private EnumFilterResult checkStackAgainstFilter(ItemStack stack, EnumFacing side) {
        boolean unmapped = true;
        for (ItemStack filterStack : this.filter.filters[side.ordinal()]) {
            if (filterStack.func_190926_b()) continue;
            unmapped = false;
            if (!this.compareStackToFilterstack(stack, filterStack, this.doFuzzy(side.ordinal()), this.doOredict(side.ordinal()), this.doNBT(side.ordinal()))) continue;
            return EnumFilterResult.VALID_FILTERED;
        }
        if (unmapped) {
            return EnumFilterResult.VALID_UNFILTERED;
        }
        return EnumFilterResult.INVALID;
    }

    private Predicate<ItemStack> concatFilters(final EnumFacing side0, EnumFacing side1) {
        final ArrayList<ItemStack> concat = new ArrayList<ItemStack>();
        for (ItemStack filterStack : this.filter.filters[side0.ordinal()]) {
            if (filterStack.func_190926_b()) continue;
            concat.add(filterStack);
        }
        Predicate<ItemStack> matchFilter = concat.isEmpty() ? stack -> true : new Predicate<ItemStack>(){
            final Set<ItemStack> filter;
            {
                this.filter = new HashSet<ItemStack>(concat);
            }

            @Override
            public boolean test(ItemStack stack) {
                for (ItemStack filterStack : this.filter) {
                    if (!TileEntitySorter.this.compareStackToFilterstack(stack, filterStack, TileEntitySorter.this.doFuzzy(side0.ordinal()), TileEntitySorter.this.doOredict(side0.ordinal()), TileEntitySorter.this.doNBT(side0.ordinal()))) continue;
                    return true;
                }
                return false;
            }
        };
        for (ItemStack filterStack : this.filter.filters[side1.ordinal()]) {
            if (filterStack.func_190926_b() || !matchFilter.test(filterStack)) continue;
            concat.add(filterStack);
        }
        boolean concatFuzzy = this.doFuzzy(side0.ordinal()) | this.doFuzzy(side1.ordinal());
        boolean concatOredict = this.doOredict(side0.ordinal()) | this.doOredict(side1.ordinal());
        boolean concatNBT = this.doNBT(side0.ordinal()) | this.doNBT(side1.ordinal());
        return concat.isEmpty() ? stack -> true : stack -> {
            for (ItemStack filterStack : concat) {
                if (!this.compareStackToFilterstack((ItemStack)stack, filterStack, concatFuzzy, concatOredict, concatNBT)) continue;
                return true;
            }
            return false;
        };
    }

    public ItemStack outputItemToInv(ItemStack stack, EnumFacing side, boolean simulate) {
        TileEntity inventory = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(side));
        return Utils.insertStackIntoInventory(inventory, stack, side.func_176734_d(), simulate);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideFilter = nbt.func_74759_k("sideFilter");
        if (!descPacket) {
            NBTTagList filterList = nbt.func_150295_c("filter", 10);
            this.filter = new SorterInventory(this);
            this.filter.readFromNBT(filterList);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideFilter", this.sideFilter);
        if (!descPacket) {
            NBTTagList filterList = new NBTTagList();
            this.filter.writeToNBT(filterList);
            nbt.func_74782_a("filter", (NBTBase)filterList);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return (T)this.insertionHandlers[facing.ordinal()];
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        return id == 0;
    }

    private static enum EnumFilterResult {
        INVALID,
        VALID_FILTERED,
        VALID_UNFILTERED;

    }

    public static class SorterInventory
    implements IInventory {
        public ItemStack[][] filters = new ItemStack[6][8];
        final TileEntitySorter tile;

        public SorterInventory(TileEntitySorter tile) {
            this.tile = tile;
            this.func_174888_l();
        }

        public int func_70302_i_() {
            return 48;
        }

        public boolean func_191420_l() {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if (this.filters[i][j].func_190926_b()) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack func_70301_a(int slot) {
            return this.filters[slot / 8][slot % 8];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                if (stack.func_190916_E() <= amount) {
                    this.func_70299_a(slot, null);
                } else if ((stack = stack.func_77979_a(amount)).func_190916_E() == 0) {
                    this.func_70299_a(slot, null);
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                this.func_70299_a(slot, null);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.filters[slot / 8][slot % 8] = stack;
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }

        public void func_174888_l() {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    this.filters[i][j] = ItemStack.field_190927_a;
                }
            }
        }

        public String func_70005_c_() {
            return "IESorterLayout";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentString(this.func_70005_c_());
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    if (this.filters[i][j].func_190926_b()) continue;
                    NBTTagCompound itemTag = new NBTTagCompound();
                    itemTag.func_74774_a("Slot", (byte)(i * 8 + j));
                    this.filters[i][j].func_77955_b(itemTag);
                    list.func_74742_a((NBTBase)itemTag);
                }
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.filters[slot / 8][slot % 8] = new ItemStack(itemTag);
            }
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }
    }

    public static class SorterInventoryHandler
    implements IItemHandlerModifiable {
        TileEntitySorter sorter;
        EnumFacing side;

        public SorterInventoryHandler(TileEntitySorter sorter, EnumFacing side) {
            this.sorter = sorter;
            this.side = side;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.sorter.routeItem(this.side, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.sorter.pullItem(this.side, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

