/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.siv;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import net.creeperhost.minetogether.siv.EnumSIPValues;

public class SipEndPoint {
    private InetSocketAddress address;
    private Map<String, String> values;
    private String[] onlineUsernames;
    private Map<String, Object> extendedValues;

    public SipEndPoint(String host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public SipEndPoint(InetSocketAddress address) {
        this.address = address;
    }

    public Map<String, String> getValues() {
        if (this.values == null) {
            throw new IllegalStateException("Query has not been sent yet!");
        }
        return this.values;
    }

    public String[] getOnlineUsernames() {
        if (this.onlineUsernames == null) {
            throw new IllegalStateException("Query has not been sent yet!");
        }
        return this.onlineUsernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExtendedInfo(EnumSIPValues ... values) throws IOException {
        try (Socket socket = new Socket(this.address.getAddress(), this.address.getPort());){
            String line;
            socket.setSoTimeout(5000);
            ArrayList<String> toRequest = new ArrayList<String>();
            for (EnumSIPValues value : values) {
                toRequest.add(value.toString());
            }
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            String endString = gson.toJson(toRequest);
            PrintWriter os = new PrintWriter(socket.getOutputStream());
            os.write(endString + "\n");
            os.flush();
            BufferedReader is = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String json = "";
            while ((line = is.readLine()) != null) {
                json = json + line;
            }
            Type myTypeMap = new TypeToken<Map<String, Object>>(){}.getType();
            this.extendedValues = (Map)gson.fromJson(json, myTypeMap);
        }
    }

    public <T> T getExtendedObject(EnumSIPValues key, Class<T> clazz) {
        if (this.extendedValues != null) {
            if (this.extendedValues.containsKey(key.toString())) {
                try {
                    GsonBuilder builder = new GsonBuilder();
                    Gson gson = builder.create();
                    String endString = gson.toJson(this.extendedValues.get(key.toString()));
                    return (T)gson.fromJson(endString, clazz);
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                return null;
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

