/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverstuffs.command;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import net.creeperhost.minetogether.common.WebUtils;
import net.creeperhost.minetogether.serverstuffs.CreeperHostServer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandInvite
extends CommandBase {
    public static void reloadInvites(String[] prevNames) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        Gson gson = new Gson();
        UserListWhitelist whitelistedPlayers = server.func_184103_al().func_152599_k();
        ArrayList<String> tempHash = new ArrayList<String>();
        ArrayList<String> removeHash = new ArrayList<String>();
        try {
            byte[] hash;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (String name : whitelistedPlayers.func_152685_a()) {
                hash = digest.digest(whitelistedPlayers.func_152706_a(name).getId().toString().getBytes(Charset.forName("UTF-8")));
                tempHash.add(new HexBinaryAdapter().marshal(hash));
            }
            for (String name : prevNames) {
                if (whitelistedPlayers.func_152706_a(name) != null) continue;
                hash = digest.digest(whitelistedPlayers.func_152706_a(name).getId().toString().getBytes(Charset.forName("UTF-8")));
                removeHash.add(new HexBinaryAdapter().marshal(hash));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        CreeperHostServer.InviteClass invite = new CreeperHostServer.InviteClass();
        invite.hash = tempHash;
        invite.id = CreeperHostServer.updateID;
        CreeperHostServer.logger.debug("Sending " + gson.toJson((Object)invite) + " to add endpoint");
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/invite", gson.toJson((Object)invite), true, true);
        CreeperHostServer.logger.debug("Response from add endpoint " + resp);
        if (!removeHash.isEmpty()) {
            invite = new CreeperHostServer.InviteClass();
            invite.id = CreeperHostServer.updateID;
            invite.hash = tempHash;
            CreeperHostServer.logger.debug("Sending " + gson.toJson((Object)invite) + " to revoke endpoint");
            resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/revokeinvite", gson.toJson((Object)invite), true, true);
            CreeperHostServer.logger.debug("Response from revoke endpoint " + resp);
        }
    }

    public String func_71517_b() {
        return "invite";
    }

    public int func_82362_a() {
        return 3;
    }

    public String func_71518_a(ICommandSender sender) {
        return "creeperhostserver.commands.invite.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("creeperhostserver.commands.invite.usage", new Object[0]);
        }
        if ("list".equals(args[0])) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("creeperhostserver.commands.invite.list", new Object[]{server.func_184103_al().func_152598_l().length, server.func_184103_al().func_72373_m().length}));
            Object[] astring = server.func_184103_al().func_152598_l();
            sender.func_145747_a((ITextComponent)new TextComponentString(CommandInvite.func_71527_a((Object[])astring)));
        } else if ("add".equals(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("creeperhostserver.commands.invite.add.usage", new Object[0]);
            }
            GameProfile gameprofile = server.func_152358_ax().func_152655_a(args[1]);
            if (gameprofile == null) {
                throw new CommandException("creeperhostserver.commands.invite.add.failed", new Object[]{args[1]});
            }
            server.func_184103_al().func_152601_d(gameprofile);
            this.inviteUser(gameprofile);
            CommandInvite.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"creeperhostserver.commands.invite.add.success", (Object[])new Object[]{args[1]});
        } else if ("remove".equals(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("creeperhostserver.commands.invite.remove.usage", new Object[0]);
            }
            GameProfile gameprofile1 = server.func_184103_al().func_152599_k().func_152706_a(args[1]);
            if (gameprofile1 == null) {
                throw new CommandException("creeperhostserver.commands.invite.remove.failed", new Object[]{args[1]});
            }
            server.func_184103_al().func_152597_c(gameprofile1);
            this.removeUser(gameprofile1);
            CommandInvite.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"creeperhostserver.commands.invite.remove.success", (Object[])new Object[]{args[1]});
        } else if ("reload".equals(args[0])) {
            String[] prevNames = server.func_184103_al().func_152598_l();
            server.func_184103_al().func_187244_a();
            CommandInvite.reloadInvites(prevNames);
            CommandInvite.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"creeperhostserver.commands.invite.reloaded", (Object[])new Object[0]);
        } else {
            throw new WrongUsageException("creeperhostserver.commands.invite.usage", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandInvite.func_71530_a((String[])args, (String[])new String[]{"list", "add", "remove", "reload"});
        }
        if (args.length == 2) {
            if ("remove".equals(args[0])) {
                return CommandInvite.func_71530_a((String[])args, (String[])server.func_184103_al().func_152598_l());
            }
            if ("add".equals(args[0])) {
                return CommandInvite.func_71530_a((String[])args, (String[])server.func_152358_ax().func_152654_a());
            }
        }
        return Collections.emptyList();
    }

    private void inviteUser(GameProfile profile) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        Gson gson = new Gson();
        UserListWhitelist whitelistedPlayers = server.func_184103_al().func_152599_k();
        ArrayList<String> tempHash = new ArrayList<String>();
        String name = profile.getName().toLowerCase();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(whitelistedPlayers.func_152706_a(name).getId().toString().getBytes(Charset.forName("UTF-8")));
            tempHash.add(new HexBinaryAdapter().marshal(hash));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        CreeperHostServer.InviteClass invite = new CreeperHostServer.InviteClass();
        invite.hash = tempHash;
        invite.id = CreeperHostServer.updateID;
        CreeperHostServer.logger.debug("Sending " + gson.toJson((Object)invite) + " to add endpoint");
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/invite", gson.toJson((Object)invite), true, true);
        CreeperHostServer.logger.debug("Response from add endpoint " + resp);
    }

    private void removeUser(GameProfile profile) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        Gson gson = new Gson();
        ArrayList<String> tempHash = new ArrayList<String>();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(profile.getId().toString().getBytes(Charset.forName("UTF-8")));
            String hashString = new HexBinaryAdapter().marshal(hash);
            CreeperHostServer.logger.info("Removing player with hash " + hashString);
            tempHash.add(hashString);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        CreeperHostServer.InviteClass invite = new CreeperHostServer.InviteClass();
        invite.hash = tempHash;
        invite.id = CreeperHostServer.updateID;
        CreeperHostServer.logger.debug("Sending " + gson.toJson((Object)invite) + " to revoke endpoint");
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/revokeinvite", gson.toJson((Object)invite), true, true);
        CreeperHostServer.logger.debug("Response from revoke endpoint " + resp);
    }
}

