/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.QueueProcessingThread;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class Listener<Type> {
    private final String clientName;
    @Nullable
    private ListenerThread thread;

    public Listener(@Nonnull Client client, @Nullable Consumer<Type> consumer) {
        this.clientName = Sanity.nullCheck(client, "Client cannot be null").getName();
        this.thread = consumer == null ? null : new ListenerThread(this.clientName, consumer);
    }

    public void queue(@Nonnull Type item) {
        if (this.thread != null) {
            this.thread.queue(item);
        }
    }

    public void removeConsumer() {
        this.shutdown();
        this.thread = null;
    }

    public void setConsumer(@Nonnull Consumer<Type> consumer) {
        if (this.thread == null) {
            this.thread = new ListenerThread(this.clientName, consumer);
        } else {
            this.thread.consumer = consumer;
        }
    }

    public void shutdown() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("clientName", this.clientName).toString();
    }

    private final class ListenerThread
    extends QueueProcessingThread<Type> {
        private volatile Consumer<Type> consumer;

        private ListenerThread(@Nonnull String clientName, Consumer<Type> consumer) {
            super("KICL Listener (" + clientName + ')');
            this.consumer = consumer;
        }

        @Override
        protected void processElement(@Nonnull Type element) {
            try {
                this.consumer.accept(element);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        protected void cleanup(@Nonnull Queue<Type> remainingQueue) {
            while (!remainingQueue.isEmpty()) {
                try {
                    this.consumer.accept(remainingQueue.poll());
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

