/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesNewSupportedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesSupportedListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientConnectionEndedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsClientState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsPolicy;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.StsUtil;

public class StsHandler {
    public static final String DRAFT = "draft/";
    private static final Predicate<CapabilityState> STS_CAPABILITY_PREDICATE = c -> c.getName().equals("draft/sts");
    private final StsMachine machine;
    private final Client.WithManagement client;
    private boolean isSecure;

    public StsHandler(StsMachine machine, Client.WithManagement client) {
        this.machine = machine;
        this.client = client;
        this.isSecure = client.isSecureConnection();
    }

    @Handler
    public void onCapLs(CapabilitiesSupportedListEvent event) {
        Optional<CapabilityState> potentialStsCapability = event.getSupportedCapabilities().stream().filter(STS_CAPABILITY_PREDICATE).findAny();
        if (!potentialStsCapability.isPresent()) {
            if (this.machine.getCurrentState() == StsClientState.STS_PRESENT_RECONNECTING) {
                this.machine.setCurrentState(StsClientState.INVALID_STS_MISSING_ON_RECONNECT);
            }
            return;
        }
        CapabilityState sts = potentialStsCapability.get();
        this.handleStsCapability(sts, event.getOriginalMessages());
    }

    @Handler
    public void onCapNew(CapabilitiesNewSupportedEvent event) {
        Optional<CapabilityState> potentialStsCapability = event.getNewCapabilities().stream().filter(STS_CAPABILITY_PREDICATE).findAny();
        if (!potentialStsCapability.isPresent()) {
            return;
        }
        CapabilityState sts = potentialStsCapability.get();
        if (this.machine.getCurrentState() == StsClientState.UNKNOWN) {
            this.handleStsCapability(sts, event.getOriginalMessages());
        }
    }

    @Handler
    public void onDisconnect(ClientConnectionEndedEvent event) {
        String hostname = this.client.getServerAddress().getHostName();
        StsStorageManager storageManager = this.machine.getStorageManager();
        storageManager.getEntry(hostname).ifPresent(policy -> {
            long duration = Long.parseLong(policy.getOptions().get("duration"));
            storageManager.removeEntry(hostname);
            storageManager.addEntry(hostname, duration, (StsPolicy)policy);
        });
    }

    private void handleStsCapability(CapabilityState sts, List<ServerMessage> originalMessages) {
        this.isSecure = this.client.isSecureConnection();
        InetSocketAddress address = this.client.getServerAddress();
        if (!sts.getValue().isPresent()) {
            throw new KittehServerMessageException(originalMessages, "No value provided for sts capability.");
        }
        String capabilityValue = sts.getValue().get();
        StsPolicy policy = StsUtil.getStsPolicyFromString(",", capabilityValue);
        if (policy.getFlags().contains("port") || policy.getFlags().contains("duration")) {
            throw new KittehServerMessageException(originalMessages, "Improper use of flag in required option context!");
        }
        if (!policy.getOptions().containsKey("port")) {
            policy.getOptions().put("port", Integer.toString(address.getPort()));
        }
        for (String key : policy.getOptions().keySet()) {
            this.machine.setStsPolicy(policy);
            if (this.isSecure) {
                this.handleSecureKey(key, policy, originalMessages);
                continue;
            }
            this.handleInsecureKey(key, policy, originalMessages);
        }
    }

    private void handleInsecureKey(String key, StsPolicy policy, List<ServerMessage> originalMessages) {
        String value = policy.getOptions().get(key);
        switch (key) {
            case "duration": {
                break;
            }
            case "port": {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    throw new KittehServerMessageException(originalMessages, "Specified port could not be parsed: " + nfe.getMessage());
                }
                this.machine.setCurrentState(StsClientState.STS_PRESENT_RECONNECTING);
            }
        }
    }

    private void handleSecureKey(String key, StsPolicy policy, List<ServerMessage> originalMessages) {
        String value = policy.getOptions().get(key);
        switch (key) {
            case "duration": {
                long duration;
                try {
                    duration = Long.parseLong(value);
                }
                catch (NumberFormatException nfe) {
                    throw new KittehServerMessageException(originalMessages, "Invalid duration provided: " + nfe.getMessage());
                }
                StsStorageManager storageMan = this.machine.getStorageManager();
                String hostname = this.client.getServerAddress().getHostName();
                if (duration == 0L) {
                    storageMan.removeEntry(hostname);
                    return;
                }
                if (storageMan.hasEntry(hostname)) {
                    storageMan.removeEntry(hostname);
                }
                storageMan.addEntry(hostname, duration, policy);
                this.machine.setCurrentState(StsClientState.STS_PRESENT_NOW_SECURE);
                break;
            }
        }
    }
}

