/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ClientLinked;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.Mode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class ModeStatus<ModeType extends Mode>
implements ClientLinked {
    private final ModeType mode;
    @Nullable
    private final String parameter;
    private final boolean setting;

    public ModeStatus(boolean setting, @Nonnull ModeType mode) {
        this.mode = (Mode)Sanity.nullCheck(mode, "Mode cannot be null");
        this.parameter = null;
        this.setting = setting;
    }

    public ModeStatus(boolean setting, @Nonnull ModeType mode, @Nonnull String parameter) {
        this.mode = (Mode)Sanity.nullCheck(mode, "Mode cannot be null");
        this.parameter = Sanity.safeMessageCheck(parameter, "Parameter");
        this.setting = setting;
    }

    @Override
    @Nonnull
    public Client getClient() {
        return this.getMode().getClient();
    }

    @Nonnull
    public ModeType getMode() {
        return this.mode;
    }

    @Nonnull
    public Optional<String> getParameter() {
        return Optional.ofNullable(this.parameter);
    }

    public boolean isSetting() {
        return this.setting;
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("mode", this.mode).add("setting", this.setting).add("parameter", this.parameter).toString();
    }
}

