/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.config;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.common.Config;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ReflectionConfigElement
implements IConfigElement {
    final Field field;
    final Object defValue;
    private HashMap<String, Class<? extends GuiConfigEntries.IConfigEntry>> lookupEntry = new HashMap<String, Class<? extends GuiConfigEntries.IConfigEntry>>(){
        {
            this.put("boolean", GuiConfigEntries.BooleanEntry.class);
            this.put("String", GuiConfigEntries.StringEntry.class);
            this.put("int", GuiConfigEntries.IntegerEntry.class);
        }
    };
    private HashMap<String, ConfigGuiType> lookup = new HashMap<String, ConfigGuiType>(){
        {
            this.put("boolean", ConfigGuiType.BOOLEAN);
            this.put("String", ConfigGuiType.STRING);
            this.put("int", ConfigGuiType.INTEGER);
        }
    };

    ReflectionConfigElement(Field field, Object defValue) {
        this.field = field;
        this.defValue = defValue;
    }

    public boolean isProperty() {
        return true;
    }

    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return null;
    }

    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return null;
    }

    public String getName() {
        return this.field.getName();
    }

    public String getQualifiedName() {
        return "creeperhost.config." + this.getName();
    }

    public String getLanguageKey() {
        return "creeperhost.config." + this.getName().toLowerCase();
    }

    public String getComment() {
        return "creeperhost.config.comment." + this.getName().toLowerCase();
    }

    public List<IConfigElement> getChildElements() {
        return null;
    }

    public ConfigGuiType getType() {
        ConfigGuiType type = this.lookup.get(this.field.getType().toString());
        return type != null ? type : ConfigGuiType.STRING;
    }

    public boolean isList() {
        return false;
    }

    public boolean isListLengthFixed() {
        return false;
    }

    public int getMaxListLength() {
        return 0;
    }

    public boolean isDefault() {
        return this.defValue != null && this.defValue.equals(this.get());
    }

    public Object getDefault() {
        return this.defValue;
    }

    public Object[] getDefaults() {
        return new Object[0];
    }

    public void setToDefault() {
    }

    public boolean requiresWorldRestart() {
        return false;
    }

    public boolean showInGui() {
        return true;
    }

    public boolean requiresMcRestart() {
        return false;
    }

    public Object get() {
        try {
            this.field.setAccessible(true);
            return this.field.get(Config.getInstance());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Object[] getList() {
        return new Object[0];
    }

    public void set(Object value) {
        try {
            this.field.setAccessible(true);
            this.field.set(Config.getInstance(), value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void set(Object[] aVal) {
    }

    public String[] getValidValues() {
        return null;
    }

    public Object getMinValue() {
        return 0;
    }

    public Object getMaxValue() {
        return 400;
    }

    public Pattern getValidationPattern() {
        return null;
    }
}

