/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakedmodels.OverrideListModel;
import com.brandon3055.brandonscore.items.ItemEnergyBase;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRenderOverride;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.IHudDisplay;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ExternalConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IConfigurableItem;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.IToolModelProvider;
import com.brandon3055.draconicevolution.client.model.tool.ToolOverrideList;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.items.tools.IAOEWeapon;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ToolBase
extends ItemEnergyBase
implements IRenderOverride,
IUpgradableItem,
IConfigurableItem,
IHudDisplay,
IToolModelProvider {
    private float baseAttackDamage;
    private float baseAttackSpeed;
    protected int energyPerOperation = 1024;

    public ToolBase() {
        this.func_77625_d(1);
    }

    public abstract double getBaseAttackSpeedConfig();

    public abstract double getBaseAttackDamageConfig();

    public abstract void loadEnergyStats();

    public void loadStatConfig() {
        this.baseAttackDamage = (float)this.getBaseAttackDamageConfig();
        this.baseAttackSpeed = (float)this.getBaseAttackSpeedConfig();
        this.loadEnergyStats();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b();
    }

    public int getItemEnchantability(ItemStack stack) {
        return 23 + this.getToolTier(stack) * 3;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    @Override
    public int getProfileCount(ItemStack stack) {
        return 5;
    }

    protected void addEnchantConfig(ItemStack stack, ItemConfigFieldRegistry registry) {
        Map<Enchantment, Integer> enchants = this.getAllEnchants(stack);
        Map<Enchantment, Integer> disEnchants = this.getDisabledEnchants(stack);
        enchants.forEach((enchantment, integer) -> {
            ToolConfigHelper.getFieldStorage(stack).func_82580_o(enchantment.func_77320_a());
            registry.register(stack, new BooleanConfigField(enchantment.getRegistryName() + "", false, "config.field.toggleEnchant.description", (Enchantment)enchantment, (Integer)integer){
                final /* synthetic */ Enchantment val$enchantment;
                final /* synthetic */ Integer val$integer;
                {
                    this.val$enchantment = enchantment;
                    this.val$integer = n;
                    super(name, value, description);
                }

                @Override
                public String getUnlocalizedName() {
                    return this.val$enchantment.func_77316_c(this.val$integer.intValue());
                }

                @Override
                public void readFromNBT(NBTTagCompound compound) {
                    super.readFromNBT(compound);
                }

                @Override
                public void writeToNBT(NBTTagCompound compound) {
                    super.writeToNBT(compound);
                }

                @Override
                public Integer getValue() {
                    return super.getValue();
                }

                @Override
                public String getReadableValue() {
                    return super.getReadableValue();
                }
            });
        });
    }

    public Map<Enchantment, Integer> getDisabledEnchants(ItemStack stack) {
        NBTTagList list = ItemNBTHelper.getCompound((ItemStack)stack).func_150295_c("disableEnchants", 10);
        HashMap<Enchantment, Integer> disEnch = new HashMap<Enchantment, Integer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Enchantment enchantment = Enchantment.func_185262_c((int)list.func_150305_b(i).func_74765_d("id"));
            short level = list.func_150305_b(i).func_74765_d("lvl");
            disEnch.put(enchantment, Integer.valueOf(level));
        }
        return disEnch;
    }

    public Map<Enchantment, Integer> getAllEnchants(ItemStack stack) {
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        enchants.putAll(this.getDisabledEnchants(stack));
        enchants.putAll(EnchantmentHelper.func_82781_a((ItemStack)stack));
        return enchants;
    }

    @Override
    public void onFieldChanged(ItemStack stack, IItemConfigField field) {
        block5: {
            if (!(field instanceof BooleanConfigField) || !field.getDescription().equals("config.field.toggleEnchant.description")) break block5;
            Enchantment target = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(field.getName()));
            if (EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(target)) {
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
                for (Enchantment enchantment : enchants.keySet()) {
                    if (enchantment != target) continue;
                    NBTTagList list = ItemNBTHelper.getCompound((ItemStack)stack).func_150295_c("disableEnchants", 10);
                    NBTTagCompound ench = new NBTTagCompound();
                    ench.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)enchantment));
                    ench.func_74777_a("lvl", ((Integer)enchants.get(enchantment)).shortValue());
                    list.func_74742_a((NBTBase)ench);
                    ItemNBTHelper.getCompound((ItemStack)stack).func_74782_a("disableEnchants", (NBTBase)list);
                    enchants.remove(enchantment);
                    EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
                    ToolConfigHelper.getFieldStorage(stack).func_74757_a(field.getName(), false);
                    return;
                }
            } else {
                Map<Enchantment, Integer> enchants = this.getDisabledEnchants(stack);
                for (Enchantment enchantment : enchants.keySet()) {
                    if (enchantment != target) continue;
                    NBTTagList list = ItemNBTHelper.getCompound((ItemStack)stack).func_150295_c("disableEnchants", 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        Enchantment e = Enchantment.func_185262_c((int)list.func_150305_b(i).func_74765_d("id"));
                        if (e != enchantment) continue;
                        list.func_74744_a(i);
                        break;
                    }
                    stack.func_77966_a(enchantment, enchants.get(enchantment).intValue());
                    ToolConfigHelper.getFieldStorage(stack).func_74757_a(field.getName(), true);
                    return;
                }
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !this.getDisabledEnchants(stack).containsKey(enchantment);
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        return new ArrayList<String>(){
            {
                this.add("rfCap");
            }
        };
    }

    @Override
    public abstract int getMaxUpgradeLevel(ItemStack var1, String var2);

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        ToolBase.holdCTRLForUpgrades(tooltip, stack);
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public static void holdCTRLForUpgrades(List<String> list, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IUpgradableItem)) {
            return;
        }
        if (!InfoHelper.isCtrlKeyDown()) {
            list.add(I18n.func_135052_a((String)"upgrade.de.holdCtrlForUpgrades.info", (Object[])new Object[]{TextFormatting.AQUA + "" + TextFormatting.ITALIC, TextFormatting.RESET + "" + TextFormatting.GRAY}));
        } else {
            list.add(TextFormatting.GOLD + I18n.func_135052_a((String)"upgrade.de.upgrades.info", (Object[])new Object[0]));
            list.addAll(UpgradeHelper.getUpgradeStats(stack));
        }
    }

    public int getCapacity(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "rfCap");
        if (level == 0) {
            return super.getCapacity(stack);
        }
        return super.getCapacity(stack) * (int)Math.pow(2.0, level + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ModelResourceLocation modelLocation = new ModelResourceLocation("draconicevolution:" + feature.getName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)modelLocation);
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> modelLocation);
        ModelRegistryHelper.register((ModelResourceLocation)modelLocation, (IBakedModel)new OverrideListModel((ItemOverrideList)new ToolOverrideList()));
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (this instanceof IAOEWeapon && player.func_184825_o(0.5f) >= 0.95f && ((IAOEWeapon)((Object)this)).getWeaponAOE(stack) > 0.0) {
            List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, entity.func_174813_aQ().func_72314_b(((IAOEWeapon)((Object)this)).getWeaponAOE(stack), 0.25, ((IAOEWeapon)((Object)this)).getWeaponAOE(stack)));
            for (EntityLivingBase aoeEntity : entities) {
                if (aoeEntity == player || aoeEntity == entity || player.func_184191_r(entity) || !this.extractAttackEnergy(stack, (Entity)aoeEntity, player)) continue;
                aoeEntity.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                aoeEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), this.getAttackDamage(stack));
            }
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
            player.func_184810_cG();
        }
        this.extractAttackEnergy(stack, entity, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    protected boolean extractAttackEnergy(ItemStack stack, Entity entity, EntityPlayer player) {
        if (this.getEnergyStored(stack) > this.energyPerOperation) {
            this.modifyEnergy(stack, -this.energyPerOperation);
            return true;
        }
        return false;
    }

    public float getAttackDamage(ItemStack stack) {
        float damage = this.baseAttackDamage + (float)UpgradeHelper.getUpgradeLevel(stack, "attackDmg") * (this.baseAttackDamage / 4.0f);
        if (this.getEnergyStored(stack) < this.energyPerOperation) {
            damage /= 10.0f;
        }
        return damage;
    }

    private float getAttackSpeed(ItemStack stack) {
        return this.baseAttackSpeed;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack) - 1.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getAttackSpeed(stack), 0));
        }
        return multimap;
    }

    public abstract int getToolTier(ItemStack var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(@Nullable ItemStack stack, World world, @Nullable BlockPos pos, List<String> displayList) {
        ItemConfigFieldRegistry registry = new ItemConfigFieldRegistry();
        this.getFields(stack, registry);
        displayList.add(TextFormatting.DARK_PURPLE + ToolConfigHelper.getProfileName(stack, ToolConfigHelper.getProfile(stack)));
        for (IItemConfigField field : registry.getFields()) {
            if (field instanceof ExternalConfigField) continue;
            displayList.add(InfoHelper.ITC() + I18n.func_135052_a((String)field.getUnlocalizedName(), (Object[])new Object[0]) + ": " + InfoHelper.HITC() + field.getReadableValue());
        }
    }
}

