/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.brandon3055.brandonscore.items.ItemEnergyBase;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class DraconiumCapacitor
extends ItemEnergyBase
implements IInvCharge,
IUpgradableItem,
IBauble {
    public static final int wyvernTransfer = 8000000;
    public static final int wyvernBaseCap = 64000000;
    public static final int draconicTransfer = 64000000;
    public static final int draconicBaseCap = 256000000;
    @CapabilityInject(value=IBaublesItemHandler.class)
    private static Capability<IBaublesItemHandler> CAPABILITY_BAUBLES = null;

    public DraconiumCapacitor() {
        this.func_77627_a(true);
        this.addName(0, "wyvern").addName(1, "draconic").addName(2, "creative");
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 0));
            subItems.add((Object)ItemNBTHelper.setInteger((ItemStack)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 0), (String)"Energy", (int)64000000));
            subItems.add((Object)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 1));
            subItems.add((Object)ItemNBTHelper.setInteger((ItemStack)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 1), (String)"Energy", (int)256000000));
            subItems.add((Object)ItemNBTHelper.setInteger((ItemStack)new ItemStack((Item)DEFeatures.draconiumCapacitor, 1, 2), (String)"Energy", (int)0x3FFFFFFF));
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public int getCapacity(ItemStack stack) {
        int tier = stack.func_77952_i();
        int upgrade = UpgradeHelper.getUpgradeLevel(stack, "rfCap");
        switch (tier) {
            case 0: {
                return 64000000 + upgrade * 32000000;
            }
            case 1: {
                return 256000000 + upgrade * 128000000;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int getMaxReceive(ItemStack stack) {
        int tier = stack.func_77952_i();
        switch (tier) {
            case 0: {
                return 8000000;
            }
            case 1: {
                return 64000000;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int getMaxExtract(ItemStack stack) {
        int tier = stack.func_77952_i();
        switch (tier) {
            case 0: {
                return 8000000;
            }
            case 1: {
                return 64000000;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77952_i() == 2) {
            return maxReceive;
        }
        return super.receiveEnergy(container, maxReceive, simulate);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77952_i() == 2) {
            return maxExtract;
        }
        return super.extractEnergy(container, maxExtract, simulate);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            short mode = ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0);
            int newMode = mode == 4 ? 0 : mode + 1;
            ItemNBTHelper.setShort((ItemStack)stack, (String)"Mode", (short)((short)newMode));
            if (world.field_72995_K) {
                ChatHelper.indexedMsg((ICommandSender)player, (String)(InfoHelper.ITC() + I18n.func_135052_a((String)"info.de.capacitorMode.txt", (Object[])new Object[0]) + ": " + InfoHelper.HITC() + I18n.func_135052_a((String)("info.de.capacitorMode" + ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0) + ".txt"), (Object[])new Object[0])));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack container, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        this.updateEnergy(container, (EntityPlayer)entity, new ArrayList<ItemStack>());
    }

    public void updateEnergy(ItemStack capacitor, EntityPlayer player, List<ItemStack> stacks) {
        short mode = ItemNBTHelper.getShort((ItemStack)capacitor, (String)"Mode", (short)0);
        if (mode == 4) {
            stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
            stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
            stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_184439_c);
        } else {
            if (mode == 1 || mode == 3) {
                stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
            }
            if (mode == 2 || mode == 3) {
                stacks.add(player.func_184592_cb());
                stacks.add(player.func_184614_ca());
            }
        }
        for (ItemStack stack : stacks) {
            Item item;
            int max = Math.min(this.getEnergyStored(capacitor), this.getMaxExtract(capacitor));
            if (!EnergyHelper.canReceiveEnergy((ItemStack)stack) || (item = stack.func_77973_b()) instanceof IInvCharge && !((IInvCharge)item).canCharge(stack, player)) continue;
            this.extractEnergy(capacitor, EnergyHelper.insertEnergy((ItemStack)stack, (int)max, (boolean)false), false);
        }
    }

    @Override
    public boolean canCharge(ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        if (InfoHelper.holdShiftForDetails(tooltip)) {
            tooltip.add(I18n.func_135052_a((String)"info.de.changwMode.txt", (Object[])new Object[0]));
            tooltip.add(InfoHelper.ITC() + I18n.func_135052_a((String)"info.de.capacitorMode.txt", (Object[])new Object[0]) + ": " + InfoHelper.HITC() + I18n.func_135052_a((String)("info.de.capacitorMode" + ItemNBTHelper.getShort((ItemStack)stack, (String)"Mode", (short)0) + ".txt"), (Object[])new Object[0]));
        }
        ToolBase.holdCTRLForUpgrades(tooltip, stack);
        InfoHelper.addEnergyInfo((ItemStack)stack, tooltip);
        if (stack.func_77952_i() == 2) {
            tooltip.add(InfoHelper.HITC() + I18n.func_135052_a((String)"info.creativeCapacitor.txt", (Object[])new Object[0]) + " " + Utils.formatNumber((long)0x3FFFFFFFL) + " RF/t");
        }
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        return new ArrayList<String>(){
            {
                this.add("rfCap");
            }
        };
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return stack.func_77952_i() == 0 ? 3 : (stack.func_77952_i() == 1 ? 6 : 0);
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        this.updateEnergy(itemstack, (EntityPlayer)player, DraconiumCapacitor.getBaubles((Entity)player));
    }

    private static List<ItemStack> getBaubles(Entity entity) {
        if (CAPABILITY_BAUBLES == null) {
            return Collections.emptyList();
        }
        IBaublesItemHandler handler = (IBaublesItemHandler)entity.getCapability(CAPABILITY_BAUBLES, null);
        if (handler == null) {
            return Collections.emptyList();
        }
        return IntStream.range(0, handler.getSlots()).mapToObj(arg_0 -> ((IBaublesItemHandler)handler).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }
}

