/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemConfigFieldRegistry {
    private Map<String, IItemConfigField> fields = new LinkedHashMap<String, IItemConfigField>();

    public ItemConfigFieldRegistry register(ItemStack stack, IItemConfigField field) {
        this.fields.put(field.getName(), field);
        NBTTagCompound fieldStorage = ToolConfigHelper.getFieldStorage(stack);
        if (!fieldStorage.func_74764_b(field.getName())) {
            field.writeToNBT(fieldStorage);
        } else {
            field.readFromNBT(fieldStorage);
        }
        return this;
    }

    public IItemConfigField getField(String name) {
        return this.fields.get(name);
    }

    public Collection<IItemConfigField> getFields() {
        return this.fields.values();
    }

    public void clear() {
        this.fields.clear();
    }

    public int size() {
        return this.fields.size();
    }
}

