/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.helper.NbtHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedtunnels.GeneralConfig;

public class TunnelFluidHelpers {
    public static final Predicate<FluidStack> MATCH_ALL = input -> true;
    public static final Predicate<FluidStack> MATCH_NONE = input -> false;

    @Nullable
    public static FluidStack moveFluids(IFluidHandler source, IFluidHandler target, int maxAmount, boolean doTransfer, Predicate<FluidStack> fluidStackMatcher, boolean exact) {
        return TunnelFluidHelpers.moveFluids(source, (FluidStack input) -> target, maxAmount, doTransfer, fluidStackMatcher, exact);
    }

    @Nullable
    public static FluidStack moveFluids(IFluidHandler source, Function<FluidStack, IFluidHandler> targetGetter, int maxAmount, boolean doTransfer, Predicate<FluidStack> fluidStackMatcher, boolean exact) {
        ArrayList checkFluids = Lists.newArrayList();
        for (IFluidTankProperties properties : source.getTankProperties()) {
            FluidStack contents = properties.getContents();
            if (contents == null) continue;
            FluidStack toMove = contents.copy();
            toMove.amount = maxAmount;
            if (!fluidStackMatcher.test(toMove)) continue;
            checkFluids.add(toMove);
        }
        for (FluidStack checkFluid : checkFluids) {
            FluidStack drained;
            int fillableAmount;
            IFluidHandler target;
            FluidStack drainable = source.drain(checkFluid, false);
            if (drainable == null || drainable.amount <= 0 || (target = targetGetter.apply(drainable)) == null || (fillableAmount = target.fill(drainable, false)) <= 0 || exact && fillableAmount != maxAmount || (drained = source.drain(new FluidStack(drainable, fillableAmount), doTransfer)) == null) continue;
            drained.amount = target.fill(drained, doTransfer);
            return drained;
        }
        return null;
    }

    public static Predicate<FluidStack> matchFluidStack(FluidStack fluidStack, boolean checkAmount, boolean checkNbt, boolean blacklist) {
        return input -> {
            boolean result = TunnelFluidHelpers.areFluidStackEqual(input, fluidStack, true, checkAmount, checkNbt);
            if (blacklist) {
                result = !result;
            }
            return result;
        };
    }

    public static Predicate<FluidStack> matchFluidStacks(IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack> fluidStacks, boolean checkAmount, boolean checkNbt) {
        return input -> {
            for (ValueObjectTypeFluidStack.ValueFluidStack fluidStack : fluidStacks) {
                if (!fluidStack.getRawValue().isPresent() || !TunnelFluidHelpers.areFluidStackEqual(input, (FluidStack)fluidStack.getRawValue().get(), true, checkAmount, checkNbt)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<FluidStack> matchPredicate(PartTarget partTarget, IOperator predicate) {
        return input -> {
            ValueObjectTypeFluidStack.ValueFluidStack valueFluidStack = ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)input);
            try {
                IValue result = ValueHelpers.evaluateOperator((IOperator)predicate, (IValue[])new IValue[]{valueFluidStack});
                ValueHelpers.validatePredicateOutput((IOperator)predicate, (IValue)result);
                return ((ValueTypeBoolean.ValueBoolean)result).getRawValue();
            }
            catch (EvaluationException e) {
                PartHelpers.PartStateHolder partData = PartHelpers.getPart((PartPos)partTarget.getCenter());
                if (partData != null) {
                    IPartStateWriter partState = (IPartStateWriter)partData.getState();
                    partState.addError(partState.getActiveAspect(), new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
                    partState.setDeactivated(true);
                }
                return false;
            }
        };
    }

    public static Predicate<FluidStack> matchNbt(NBTTagCompound tag, boolean subset, boolean superset, boolean requireNbt, boolean recursive) {
        return input -> {
            if (input.tag == null && requireNbt) {
                return false;
            }
            NBTTagCompound itemTag = input.tag != null ? input.tag : new NBTTagCompound();
            return !(subset && !NbtHelpers.nbtMatchesSubset((NBTTagCompound)tag, (NBTTagCompound)itemTag, (boolean)recursive) || superset && !NbtHelpers.nbtMatchesSubset((NBTTagCompound)itemTag, (NBTTagCompound)tag, (boolean)recursive));
        };
    }

    public static boolean areFluidStackEqual(FluidStack stackA, FluidStack stackB, boolean checkFluid, boolean checkAmount, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkAmount && stackA.amount != stackB.amount) {
                return false;
            }
            if (checkFluid && stackA.getFluid() != stackB.getFluid()) {
                return false;
            }
            return !checkNbt || FluidStack.areFluidStackTagsEqual((FluidStack)stackA, (FluidStack)stackB);
        }
        return false;
    }

    public static FluidStack placeFluids(IFluidHandler source, World world, BlockPos pos, Predicate<FluidStack> fluidStackMatcher, boolean blockUpdate, boolean ignoreReplacable) {
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || isDestNonSolid && ignoreReplacable && isDestReplaceable && !destMaterial.func_76224_d())) {
            return null;
        }
        FluidStack moved = TunnelFluidHelpers.moveFluids(source, (FluidStack input) -> {
            Fluid fluid = input.getFluid();
            if (world.field_73011_w.func_177500_n() && fluid.doesVaporize(input)) {
                return null;
            }
            Block block = fluid.getBlock();
            Object handler = block instanceof IFluidBlock ? new FluidBlockWrapper((IFluidBlock)block, world, pos) : (block instanceof BlockLiquid ? new BlockLiquidWrapper((BlockLiquid)block, world, pos) : new BlockWrapper(block, world, pos));
            return handler;
        }, 1000, true, fluidStackMatcher, true);
        if (moved != null) {
            if (GeneralConfig.worldInteractionEvents) {
                SoundEvent soundevent = moved.getFluid().getEmptySound(moved);
                world.func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (blockUpdate) {
                world.func_190524_a(pos, Blocks.field_150350_a, pos);
            }
        }
        return moved;
    }

    public static FluidStack pickUpFluids(World world, BlockPos pos, EnumFacing side, IFluidHandler target, Predicate<FluidStack> fluidStackMatcher) {
        IFluidHandler targetFluidHandler;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((block instanceof IFluidBlock || block instanceof BlockLiquid) && (targetFluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)side)) != null) {
            FluidStack pickedUp = TunnelFluidHelpers.moveFluids(targetFluidHandler, target, 1000, true, fluidStackMatcher, true);
            if (pickedUp != null && GeneralConfig.worldInteractionEvents) {
                SoundEvent soundevent = pickedUp.getFluid().getFillSound(pickedUp);
                world.func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return pickedUp;
        }
        return null;
    }
}

