/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public abstract class ItemStackPredicate
implements Predicate<ItemStack> {
    private final ItemStack itemStack;
    private final int matchFlags;
    private final boolean blacklist;
    private final EmptyBehaviour emptyBehaviour;

    public ItemStackPredicate(@Nonnull ItemStack itemStack, int matchFlags, boolean blacklist, EmptyBehaviour emptyBehaviour) {
        this.itemStack = itemStack;
        this.matchFlags = matchFlags;
        this.blacklist = blacklist;
        this.emptyBehaviour = emptyBehaviour;
    }

    public ItemStackPredicate(boolean blacklist) {
        this(ItemStack.field_190927_a, -1, blacklist, EmptyBehaviour.NONE);
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getMatchFlags() {
        return this.matchFlags;
    }

    public boolean hasMatchFlags() {
        return this.getMatchFlags() >= 0 && (this.emptyBehaviour == EmptyBehaviour.ANY || !this.getItemStack().func_190926_b());
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public static enum EmptyBehaviour {
        ANY,
        NONE;


        public static EmptyBehaviour fromBoolean(boolean emptyIsAny) {
            return emptyIsAny ? ANY : NONE;
        }
    }
}

