/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.GuiStorageTerminal;
import mcjty.rftools.blocks.storage.StorageTerminalContainer;
import mcjty.rftools.blocks.storage.StorageTerminalTileEntity;
import mcjty.rftools.blocks.storagemonitor.GuiStorageScanner;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.varia.RFToolsTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StorageTerminalBlock
extends LogicSlabBlock<StorageTerminalTileEntity, StorageTerminalContainer> {
    public static final PropertyBool MODULE = PropertyBool.func_177716_a((String)"module");

    public StorageTerminalBlock() {
        super((ModBase)RFTools.instance, Material.field_151573_f, StorageTerminalTileEntity.class, StorageTerminalContainer::new, "storage_terminal", true);
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<StorageTerminalTileEntity, StorageTerminalContainer, GenericGuiContainer<? super StorageTerminalTileEntity>> getGuiFactory() {
        return GuiStorageTerminal::new;
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == ScreenSetup.storageControlModuleItem;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This terminal can be retrofitted with");
            list.add(TextFormatting.WHITE + "a Storage Control Screen Module so");
            list.add(TextFormatting.WHITE + "that you can access a Storage Scanner");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        ItemStack module = StorageTerminalBlock.getModule(world.func_175625_s(data.getPos()));
        if (module.func_190926_b()) {
            probeInfo.text(TextFormatting.GREEN + "Install storage control screen module first");
        } else {
            probeInfo.text(TextFormatting.GREEN + "Use wrench to remove module");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        ItemStack module = StorageTerminalBlock.getModule(accessor.getTileEntity());
        if (module.func_190926_b()) {
            currenttip.add(TextFormatting.GREEN + "Install storage control screen module first");
        } else {
            currenttip.add(TextFormatting.GREEN + "Use wrench to remove module");
        }
        return currenttip;
    }

    public boolean hasRedstoneOutput() {
        return false;
    }

    public boolean needsRedstoneCheck() {
        return false;
    }

    public int getGuiID() {
        return RFTools.GUI_STORAGE_TERMINAL;
    }

    private static ItemStack getModule(TileEntity tileEntity) {
        if (tileEntity instanceof StorageTerminalTileEntity) {
            StorageTerminalTileEntity terminalTileEntity = (StorageTerminalTileEntity)tileEntity;
            return terminalTileEntity.func_70301_a(0);
        }
        return ItemStack.field_190927_a;
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        StorageTerminalTileEntity terminalTileEntity;
        ItemStack module;
        if (!entityPlayer.func_70093_af() && tileEntity instanceof StorageTerminalTileEntity && !(module = (terminalTileEntity = (StorageTerminalTileEntity)tileEntity).func_70301_a(0)).func_190926_b()) {
            int dimension = RFToolsTools.getDimensionFromModule(module);
            BlockPos pos = RFToolsTools.getPositionFromModule(module);
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (!WorldTools.chunkLoaded((World)world, (BlockPos)pos)) {
                entityPlayer.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Storage scanner out of range!"), false);
                return null;
            }
            TileEntity scannerTE = world.func_175625_s(pos);
            if (!(scannerTE instanceof StorageScannerTileEntity)) {
                entityPlayer.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Storage scanner is missing!"), false);
                return null;
            }
            return new StorageScannerContainer(entityPlayer, (IInventory)scannerTE, terminalTileEntity);
        }
        return super.createServerContainer(entityPlayer, tileEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, final TileEntity tileEntity) {
        ItemStack module;
        if (!entityPlayer.func_70093_af() && !(module = StorageTerminalBlock.getModule(tileEntity)).func_190926_b()) {
            int monitordim = RFToolsTools.getDimensionFromModule(module);
            BlockPos pos = RFToolsTools.getPositionFromModule(module);
            StorageScannerTileEntity te = new StorageScannerTileEntity(entityPlayer, monitordim){

                @Override
                public BlockPos getCraftingGridContainerPos() {
                    return tileEntity.func_174877_v();
                }

                @Override
                public CraftingGridProvider getCraftingGridProvider() {
                    return (CraftingGridProvider)tileEntity;
                }

                @Override
                public boolean isOpenWideView() {
                    TileEntity realTe = RFTools.proxy.getClientWorld().func_175625_s(this.field_174879_c);
                    if (realTe instanceof StorageScannerTileEntity) {
                        return ((StorageScannerTileEntity)realTe).isOpenWideView();
                    }
                    return true;
                }

                @Override
                public BlockPos getStorageScannerPos() {
                    return this.field_174879_c;
                }
            };
            te.func_174878_a(pos);
            return new GuiStorageScanner(te, new StorageScannerContainer(entityPlayer, (IInventory)te, (CraftingGridProvider)tileEntity));
        }
        return super.createClientGui(entityPlayer, tileEntity);
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        StorageTerminalTileEntity storageTerminalTileEntity;
        ItemStack module;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof StorageTerminalTileEntity && !(module = (storageTerminalTileEntity = (StorageTerminalTileEntity)te).func_70301_a(0)).func_190926_b()) {
            storageTerminalTileEntity.func_70299_a(0, ItemStack.field_190927_a);
            storageTerminalTileEntity.markDirtyClient();
            if (!player.field_71071_by.func_70441_a(module)) {
                player.func_70099_a(module, 1.05f);
            }
            player.func_146105_b((ITextComponent)new TextComponentString("Removed module"), false);
        }
        return true;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!this.tileEntityClass.isInstance(te)) {
            return false;
        }
        if (this.checkAccess(world, player, te)) {
            return true;
        }
        if (player.func_70093_af()) {
            player.openGui((Object)this.modBase, this.getGuiID(), world, x, y, z);
        } else {
            player.openGui((Object)this.modBase, RFTools.GUI_STORAGE_TERMINAL_SCANNER, world, x, y, z);
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        ItemStack module = StorageTerminalBlock.getModule(world.func_175625_s(pos));
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)MODULE, (Comparable)Boolean.valueOf(!module.func_190926_b()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOGIC_FACING, META_INTERMEDIATE, MODULE});
    }
}

