/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.List;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TickShieldBlockTileEntity
extends NoTickShieldBlockTileEntity
implements ITickable {
    private int damageTimer = 10;

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.damageBits != 0) {
            this.handleDamage();
        }
    }

    private void handleDamage() {
        ShieldTEBase shieldTileEntity;
        --this.damageTimer;
        if (this.damageTimer > 0) {
            return;
        }
        this.damageTimer = 10;
        if (this.beamBox == null) {
            int xCoord = this.func_174877_v().func_177958_n();
            int yCoord = this.func_174877_v().func_177956_o();
            int zCoord = this.func_174877_v().func_177952_p();
            this.beamBox = new AxisAlignedBB((double)xCoord - 0.4, (double)yCoord - 0.4, (double)zCoord - 0.4, (double)xCoord + 1.4, (double)yCoord + 2.0, (double)zCoord + 1.4);
        }
        if (this.shieldBlock != null && (shieldTileEntity = (ShieldTEBase)this.func_145831_w().func_175625_s(this.shieldBlock)) != null) {
            List l = this.func_145831_w().func_72872_a(Entity.class, this.beamBox);
            for (Entity entity : l) {
                if ((this.damageBits & 4) != 0 && entity instanceof IMob) {
                    if (!this.checkEntityDamage(shieldTileEntity, "hostile")) continue;
                    shieldTileEntity.applyDamageToEntity(entity);
                    continue;
                }
                if ((this.damageBits & 2) != 0 && entity instanceof IAnimals) {
                    if (!this.checkEntityDamage(shieldTileEntity, "animal")) continue;
                    shieldTileEntity.applyDamageToEntity(entity);
                    continue;
                }
                if ((this.damageBits & 8) == 0 || !(entity instanceof EntityPlayer) || !this.checkPlayerDamage(shieldTileEntity, (EntityPlayer)entity)) continue;
                shieldTileEntity.applyDamageToEntity(entity);
            }
        }
    }

    private boolean checkEntityDamage(ShieldTEBase shieldTileEntity, String filterName) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!filterName.equals(filter.getFilterName())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }

    private boolean checkPlayerDamage(ShieldTEBase shieldTileEntity, EntityPlayer entity) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!"player".equals(filter.getFilterName())) continue;
            PlayerFilter playerFilter = (PlayerFilter)filter;
            String name = playerFilter.getName();
            if (name == null || name.isEmpty()) {
                return (filter.getAction() & 2) != 0;
            }
            if (!name.equals(entity.func_70005_c_())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }
}

