/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IExtraVariantHolder;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.interf.IModBlock;
import vazkii.arl.interf.IVariantHolder;
import vazkii.arl.item.ItemMod;

public final class ModelHandler {
    public static final HashMap<String, ModelResourceLocation> resourceLocations = new HashMap();

    @SubscribeEvent
    public static void onRegister(ModelRegistryEvent event) {
        for (IVariantHolder holder : ItemMod.variantHolders) {
            ModelHandler.registerModels(holder);
        }
    }

    public static void init() {
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        for (IVariantHolder holder : ItemMod.variantHolders) {
            if (holder instanceof IItemColorProvider) {
                itemColors.func_186730_a(((IItemColorProvider)((Object)holder)).getItemColor(), new Item[]{(Item)holder});
            }
            if (!(holder instanceof ItemBlock) || !(((ItemBlock)holder).func_179223_d() instanceof IBlockColorProvider)) continue;
            Block block = ((ItemBlock)holder).func_179223_d();
            blockColors.func_186722_a(((IBlockColorProvider)block).getBlockColor(), new Block[]{block});
            itemColors.func_186731_a(((IBlockColorProvider)block).getItemColor(), new Block[]{block});
        }
    }

    public static void registerModels(IVariantHolder holder) {
        String unique = holder.getUniqueModel();
        String prefix = holder.getPrefix();
        Item i = (Item)holder;
        ItemMeshDefinition def = holder.getCustomMeshDefinition();
        if (def != null) {
            ModelLoader.setCustomMeshDefinition((Item)((Item)holder), (ItemMeshDefinition)def);
        } else {
            ModelHandler.registerModels(i, prefix, holder.getVariants(), unique, false);
        }
        if (holder instanceof IExtraVariantHolder) {
            IExtraVariantHolder extra = (IExtraVariantHolder)holder;
            ModelHandler.registerModels(i, prefix, extra.getExtraVariants(), unique, true);
        }
    }

    public static void registerModels(Item item, String prefix, String[] variants, String uniqueVariant, boolean extra) {
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IModBlock) {
            IModBlock quarkBlock = (IModBlock)((ItemBlock)item).func_179223_d();
            Class clazz = quarkBlock.getVariantEnum();
            IProperty variantProp = quarkBlock.getVariantProp();
            boolean ignoresVariant = false;
            IStateMapper mapper = quarkBlock.getStateMapper();
            IProperty[] ignored = quarkBlock.getIgnoredProperties();
            if (mapper != null || ignored != null && ignored.length > 0) {
                if (mapper != null) {
                    ModelLoader.setCustomStateMapper((Block)((Block)quarkBlock), (IStateMapper)mapper);
                } else {
                    StateMap.Builder builder = new StateMap.Builder();
                    for (IProperty p : ignored) {
                        if (p == variantProp) {
                            ignoresVariant = true;
                        }
                        builder.func_178442_a(new IProperty[]{p});
                    }
                    ModelLoader.setCustomStateMapper((Block)((Block)quarkBlock), (IStateMapper)builder.func_178441_a());
                }
            }
            if (clazz != null && !ignoresVariant) {
                ModelHandler.registerVariantsDefaulted(item, (Block)quarkBlock, clazz, variantProp.func_177701_a());
                return;
            }
        }
        for (int i = 0; i < variants.length; ++i) {
            String var = variants[i];
            if (!extra && uniqueVariant != null) {
                var = uniqueVariant;
            }
            String name = prefix + var;
            ModelResourceLocation loc = new ModelResourceLocation(name, "inventory");
            if (!extra) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
                resourceLocations.put(ModelHandler.getKey(item, i), loc);
                continue;
            }
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{loc});
            resourceLocations.put(variants[i], loc);
        }
    }

    private static <T extends Enum<T>> void registerVariantsDefaulted(Item item, Block b, Class<T> enumclazz, String variantHeader) {
        String baseName = b.getRegistryName().toString();
        for (Enum e : (Enum[])enumclazz.getEnumConstants()) {
            String variantName = variantHeader + "=" + ((IStringSerializable)e).func_176610_l();
            ModelResourceLocation loc = new ModelResourceLocation(baseName, variantName);
            int i = e.ordinal();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
            resourceLocations.put(ModelHandler.getKey(item, i), loc);
        }
    }

    public static ModelResourceLocation getModelLocation(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return null;
        }
        return ModelHandler.getModelLocation(stack.func_77973_b(), stack.func_77952_i());
    }

    public static ModelResourceLocation getModelLocation(Item item, int meta) {
        String key = ModelHandler.getKey(item, meta);
        if (resourceLocations.containsKey(key)) {
            return resourceLocations.get(key);
        }
        return null;
    }

    private static String getKey(Item item, int meta) {
        return "i_" + item.getRegistryName() + "@" + meta;
    }
}

