/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import com.direwolf20.buildinggadgets.ModBlocks;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.items.ExchangerTool;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExchangingModes {
    private static boolean isReplaceable(World world, BlockPos pos, IBlockState currentBlock, IBlockState setBlock, boolean fuzzyMode) {
        IBlockState worldBlockState = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (worldBlockState != currentBlock && !fuzzyMode) {
            return false;
        }
        if (worldBlockState == ModBlocks.effectBlock.func_176223_P()) {
            return false;
        }
        if (worldBlockState == setBlock) {
            return false;
        }
        if (te != null && !(te instanceof ConstructionBlockTileEntity)) {
            return false;
        }
        if (te instanceof ConstructionBlockTileEntity && ((ConstructionBlockTileEntity)te).getBlockState() == setBlock) {
            return false;
        }
        if (worldBlockState.func_177230_c().func_176195_g(worldBlockState, world, pos) < 0.0f) {
            return false;
        }
        if (worldBlockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        return !worldBlockState.func_177230_c().func_149688_o(worldBlockState).func_76224_d();
    }

    public static List<BlockPos> getBuildOrders(World world, EntityPlayer player, BlockPos startBlock, EnumFacing sideHit, ItemStack tool) {
        ArrayList<BlockPos> coordinates;
        block27: {
            int z;
            int x;
            IBlockState currentBlock;
            BlockPos pos;
            Boolean fuzzyMode;
            int range;
            IBlockState setBlock;
            ExchangerTool.ToolMode mode;
            block25: {
                int bound;
                block28: {
                    block26: {
                        int y;
                        int boundZS;
                        int boundXS;
                        int boundZ;
                        int boundX;
                        mode = ExchangerTool.getToolMode(tool);
                        setBlock = GadgetUtils.getToolBlock(tool);
                        range = GadgetUtils.getToolRange(tool);
                        fuzzyMode = ExchangerTool.getFuzzy(tool);
                        coordinates = new ArrayList<BlockPos>();
                        pos = startBlock;
                        bound = (range - 1) / 2;
                        EnumFacing playerFacing = player.func_174811_aO();
                        if (playerFacing == EnumFacing.SOUTH || playerFacing == EnumFacing.NORTH) {
                            boundX = bound;
                            boundZ = 0;
                        } else {
                            boundX = 0;
                            boundZ = bound;
                        }
                        if (sideHit == EnumFacing.SOUTH || sideHit == EnumFacing.NORTH) {
                            boundXS = bound;
                            boundZS = 0;
                        } else {
                            boundXS = 0;
                            boundZS = bound;
                        }
                        currentBlock = world.func_180495_p(startBlock);
                        if (mode == ExchangerTool.ToolMode.Wall) {
                            if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                for (x = bound * -1; x <= bound; ++x) {
                                    for (z = bound * -1; z <= bound; ++z) {
                                        pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                        if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                        coordinates.add(pos);
                                    }
                                }
                            } else {
                                for (y = bound; y >= bound * -1; --y) {
                                    for (int x2 = boundXS * -1; x2 <= boundXS; ++x2) {
                                        for (int z2 = boundZS * -1; z2 <= boundZS; ++z2) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x2, startBlock.func_177956_o() - y, startBlock.func_177952_p() + z2);
                                            if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                }
                            }
                        }
                        if (mode == ExchangerTool.ToolMode.VerticalColumn) {
                            if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                for (x = boundZ * -1; x <= boundZ; ++x) {
                                    for (z = boundX * -1; z <= boundX; ++z) {
                                        pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                        if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                        coordinates.add(pos);
                                    }
                                }
                            } else {
                                for (y = bound; y >= bound * -1; --y) {
                                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - y, startBlock.func_177952_p());
                                    if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                    coordinates.add(pos);
                                }
                            }
                        }
                        if (mode != ExchangerTool.ToolMode.HorizontalColumn) break block25;
                        if (sideHit != EnumFacing.UP && sideHit != EnumFacing.DOWN) break block26;
                        for (x = boundX * -1; x <= boundX; ++x) {
                            for (z = boundZ * -1; z <= boundZ; ++z) {
                                pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                coordinates.add(pos);
                            }
                        }
                        break block27;
                    }
                    if (sideHit != EnumFacing.NORTH && sideHit != EnumFacing.SOUTH) break block28;
                    for (x = bound * -1; x <= bound; ++x) {
                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p());
                        if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                        coordinates.add(pos);
                    }
                    break block27;
                }
                if (sideHit != EnumFacing.EAST && sideHit != EnumFacing.WEST) break block27;
                for (int z3 = bound * -1; z3 <= bound; ++z3) {
                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), startBlock.func_177952_p() + z3);
                    if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                    coordinates.add(pos);
                }
                break block27;
            }
            if (mode == ExchangerTool.ToolMode.Checkerboard) {
                for (x = ++range * -7 / 5; x <= range * 7 / 5; ++x) {
                    for (z = range * -7 / 5; z <= range * 7 / 5; ++z) {
                        if (x % ((range - 2) % 6 + 2) != 0 || z % ((range - 2) % 6 + 2) != 0 || !ExchangingModes.isReplaceable(world, pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() + z), currentBlock, setBlock, fuzzyMode)) continue;
                        coordinates.add(pos);
                    }
                }
            }
        }
        return coordinates;
    }
}

