/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.blocks.templatemanager;

import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.blocks.templatemanager.TemplateManagerContainer;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TemplateManagerTileEntity
extends TileEntity {
    private static final Set<Item> allowedItemsLeft = Stream.of(ModItems.copyPasteTool, ModItems.template).collect(Collectors.toSet());
    private static final Set<Item> allowedItemsRight = Stream.of(Items.field_151121_aF, ModItems.template).collect(Collectors.toSet());
    public static final int SIZE = 2;
    private ItemStackHandler itemStackHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TemplateManagerTileEntity.this.func_70296_d();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 0) {
                if (!allowedItemsLeft.contains(stack.func_77973_b())) {
                    return stack;
                }
            } else if (slot == 1) {
                if (!allowedItemsRight.contains(stack.func_77973_b())) {
                    return stack;
                }
                if (this.getStackInSlot(slot).func_190916_E() > 0) {
                    return stack;
                }
                if (stack.func_190916_E() > 1) {
                    super.insertItem(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), simulate);
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
                }
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public TemplateManagerContainer getContainer(EntityPlayer playerIn) {
        return new TemplateManagerContainer((IInventory)playerIn.field_71071_by, this);
    }
}

