/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.blocks.templatemanager;

import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.blocks.templatemanager.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.items.ITemplate;
import com.direwolf20.buildinggadgets.items.Template;
import com.direwolf20.buildinggadgets.network.PacketBlockMap;
import com.direwolf20.buildinggadgets.network.PacketHandler;
import com.direwolf20.buildinggadgets.tools.BlockMap;
import com.direwolf20.buildinggadgets.tools.BlockMapIntState;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.tools.PasteToolBufferBuilder;
import com.direwolf20.buildinggadgets.tools.UniqueItem;
import com.direwolf20.buildinggadgets.tools.WorldSave;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TemplateManagerCommands {
    private static final Set<Item> allowedItemsRight = Stream.of(Items.field_151121_aF, ModItems.template).collect(Collectors.toSet());

    public static void loadTemplate(TemplateManagerContainer container, EntityPlayer player) {
        ItemStack itemStack0 = container.func_75139_a(0).func_75211_c();
        ItemStack itemStack1 = container.func_75139_a(1).func_75211_c();
        if (!(itemStack0.func_77973_b() instanceof ITemplate) || !allowedItemsRight.contains(itemStack1.func_77973_b())) {
            return;
        }
        ITemplate template = (ITemplate)itemStack0.func_77973_b();
        if (itemStack1.func_77973_b().equals(Items.field_151121_aF)) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos startPos = template.getStartPos(itemStack1);
        BlockPos endPos = template.getEndPos(itemStack1);
        Map<UniqueItem, Integer> tagMap = template.getItemCountMap(itemStack1);
        String UUIDTemplate = ModItems.template.getUUID(itemStack1);
        if (UUIDTemplate == null) {
            return;
        }
        WorldSave worldSave = WorldSave.getWorldSave(world);
        WorldSave templateWorldSave = WorldSave.getTemplateWorldSave(world);
        template.setStartPos(itemStack0, startPos);
        template.setEndPos(itemStack0, endPos);
        template.setItemCountMap(itemStack0, tagMap);
        String UUID = template.getUUID(itemStack0);
        if (UUID == null) {
            return;
        }
        NBTTagCompound templateTagCompound = templateWorldSave.getCompoundFromUUID(UUIDTemplate);
        NBTTagCompound tagCompound = templateTagCompound.func_74737_b();
        template.incrementCopyCounter(itemStack0);
        tagCompound.func_74768_a("copycounter", template.getCopyCounter(itemStack0));
        tagCompound.func_74778_a("UUID", template.getUUID(itemStack0));
        tagCompound.func_74778_a("owner", player.func_70005_c_());
        if (template.equals(ModItems.copyPasteTool)) {
            worldSave.addToMap(UUID, tagCompound);
        } else {
            templateWorldSave.addToMap(UUID, tagCompound);
            Template.setName(itemStack0, Template.getName(itemStack1));
        }
        container.func_75141_a(0, itemStack0);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(tagCompound), (EntityPlayerMP)player);
    }

    public static void saveTemplate(TemplateManagerContainer container, EntityPlayer player, String templateName) {
        ItemStack templateStack;
        ItemStack itemStack0 = container.func_75139_a(0).func_75211_c();
        ItemStack itemStack1 = container.func_75139_a(1).func_75211_c();
        if (itemStack0.func_190926_b() && itemStack1.func_77973_b() instanceof Template && !templateName.isEmpty()) {
            Template.setName(itemStack1, templateName);
            container.func_75141_a(1, itemStack1);
            return;
        }
        if (!(itemStack0.func_77973_b() instanceof ITemplate) || !allowedItemsRight.contains(itemStack1.func_77973_b())) {
            return;
        }
        ITemplate template = (ITemplate)itemStack0.func_77973_b();
        World world = player.field_70170_p;
        if (itemStack1.func_77973_b().equals(Items.field_151121_aF)) {
            templateStack = new ItemStack((Item)ModItems.template, 1);
            container.func_75141_a(1, templateStack);
        }
        if (!container.func_75139_a(1).func_75211_c().func_77973_b().equals(ModItems.template)) {
            return;
        }
        templateStack = container.func_75139_a(1).func_75211_c();
        WorldSave worldSave = WorldSave.getWorldSave(world);
        WorldSave templateWorldSave = WorldSave.getTemplateWorldSave(world);
        String UUID = template.getUUID(itemStack0);
        String UUIDTemplate = ModItems.template.getUUID(templateStack);
        if (UUID == null) {
            return;
        }
        if (UUIDTemplate == null) {
            return;
        }
        boolean isTool = itemStack0.func_77973_b().equals(ModItems.copyPasteTool);
        NBTTagCompound tagCompound = isTool ? worldSave.getCompoundFromUUID(UUID) : templateWorldSave.getCompoundFromUUID(UUID);
        NBTTagCompound templateTagCompound = tagCompound.func_74737_b();
        template.incrementCopyCounter(templateStack);
        templateTagCompound.func_74768_a("copycounter", template.getCopyCounter(templateStack));
        templateTagCompound.func_74778_a("UUID", ModItems.template.getUUID(templateStack));
        templateWorldSave.addToMap(UUIDTemplate, templateTagCompound);
        BlockPos startPos = template.getStartPos(itemStack0);
        BlockPos endPos = template.getEndPos(itemStack0);
        Map<UniqueItem, Integer> tagMap = template.getItemCountMap(itemStack0);
        template.setStartPos(templateStack, startPos);
        template.setEndPos(templateStack, endPos);
        template.setItemCountMap(templateStack, tagMap);
        if (isTool) {
            Template.setName(templateStack, templateName);
        } else if (templateName.equals("")) {
            Template.setName(templateStack, Template.getName(itemStack0));
        } else {
            Template.setName(templateStack, templateName);
        }
        container.func_75141_a(1, templateStack);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(templateTagCompound), (EntityPlayerMP)player);
    }

    public static void pasteTemplate(TemplateManagerContainer container, EntityPlayer player, NBTTagCompound sentTagCompound, String templateName) {
        ItemStack templateStack;
        ItemStack itemStack1 = container.func_75139_a(1).func_75211_c();
        if (!allowedItemsRight.contains(itemStack1.func_77973_b())) {
            return;
        }
        World world = player.field_70170_p;
        if (itemStack1.func_77973_b().equals(Items.field_151121_aF)) {
            templateStack = new ItemStack((Item)ModItems.template, 1);
            container.func_75141_a(1, templateStack);
        }
        if (!container.func_75139_a(1).func_75211_c().func_77973_b().equals(ModItems.template)) {
            return;
        }
        templateStack = container.func_75139_a(1).func_75211_c();
        WorldSave templateWorldSave = WorldSave.getTemplateWorldSave(world);
        Template template = ModItems.template;
        String UUIDTemplate = template.getUUID(templateStack);
        if (UUIDTemplate == null) {
            return;
        }
        NBTTagCompound templateTagCompound = sentTagCompound.func_74737_b();
        BlockPos startPos = GadgetUtils.getPOSFromNBT(templateTagCompound, "startPos");
        BlockPos endPos = GadgetUtils.getPOSFromNBT(templateTagCompound, "endPos");
        template.incrementCopyCounter(templateStack);
        templateTagCompound.func_74768_a("copycounter", template.getCopyCounter(templateStack));
        templateTagCompound.func_74778_a("UUID", template.getUUID(templateStack));
        NBTTagList MapIntStateTag = (NBTTagList)templateTagCompound.func_74781_a("mapIntState");
        BlockMapIntState mapIntState = new BlockMapIntState();
        mapIntState.getIntStateMapFromNBT(MapIntStateTag);
        mapIntState.makeStackMapFromStateMap(player);
        templateTagCompound.func_74782_a("mapIntStack", (NBTBase)mapIntState.putIntStackMapIntoNBT());
        templateTagCompound.func_74778_a("owner", player.func_70005_c_());
        HashMap itemCountMap = new HashMap();
        Map<IBlockState, UniqueItem> intStackMap = mapIntState.intStackMap;
        List<BlockMap> blockMapList = CopyPasteTool.getBlockMapList(templateTagCompound);
        for (BlockMap blockMap : blockMapList) {
            UniqueItem uniqueItem = intStackMap.get(blockMap.state);
            if (uniqueItem == null) continue;
            NonNullList drops = NonNullList.func_191196_a();
            blockMap.state.func_177230_c().getDrops(drops, (IBlockAccess)world, new BlockPos(0, 0, 0), blockMap.state, 0);
            int neededItems = 0;
            for (ItemStack drop : drops) {
                if (!drop.func_77973_b().equals(uniqueItem.item)) continue;
                ++neededItems;
            }
            if (neededItems == 0) {
                neededItems = 1;
            }
            if (uniqueItem.item == Items.field_190931_a) continue;
            boolean found = false;
            for (Map.Entry entry : itemCountMap.entrySet()) {
                if (!((UniqueItem)entry.getKey()).equals(uniqueItem)) continue;
                itemCountMap.put(entry.getKey(), (Integer)itemCountMap.get(entry.getKey()) + neededItems);
                found = true;
                break;
            }
            if (found) continue;
            itemCountMap.put(uniqueItem, neededItems);
        }
        templateWorldSave.addToMap(UUIDTemplate, templateTagCompound);
        template.setStartPos(templateStack, startPos);
        template.setEndPos(templateStack, endPos);
        template.setItemCountMap(templateStack, itemCountMap);
        Template.setName(templateStack, templateName);
        container.func_75141_a(1, templateStack);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(templateTagCompound), (EntityPlayerMP)player);
    }

    public static void copyTemplate(TemplateManagerContainer container) {
        ItemStack itemStack0 = container.func_75139_a(0).func_75211_c();
        if (itemStack0.func_77973_b() instanceof CopyPasteTool) {
            NBTTagCompound tagCompound = PasteToolBufferBuilder.getTagFromUUID(ModItems.copyPasteTool.getUUID(itemStack0));
            if (tagCompound == null) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.copyfailed", new Object[0]).func_150261_e()), false);
                return;
            }
            NBTTagCompound newCompound = new NBTTagCompound();
            newCompound.func_74783_a("stateIntArray", tagCompound.func_74759_k("stateIntArray"));
            newCompound.func_74783_a("posIntArray", tagCompound.func_74759_k("posIntArray"));
            newCompound.func_74782_a("mapIntState", tagCompound.func_74781_a("mapIntState"));
            GadgetUtils.writePOSToNBT(newCompound, GadgetUtils.getPOSFromNBT(tagCompound, "startPos"), "startPos", (Integer)0);
            GadgetUtils.writePOSToNBT(newCompound, GadgetUtils.getPOSFromNBT(tagCompound, "endPos"), "endPos", (Integer)0);
            String jsonTag = newCompound.toString();
            GuiScreen.func_146275_d((String)jsonTag);
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.copysuccess", new Object[0]).func_150261_e()), false);
        }
    }
}

