/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import cofh.api.fluid.IFluidContainerItem;
import cofh.api.item.IColorableItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.RayTracer;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.BaublesHelper;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.render.item.ModelReservoir;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemMaterial;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemReservoir
extends ItemMulti
implements IInitializer,
IBauble,
IColorableItem,
IEnchantableItem,
IFluidContainerItem,
IMultiModeItem,
IBakeryProvider {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int BUCKET_FILL = 0;
    public static final int BUCKET_EMPTY = 1;
    public static final int CAPACITY_BASE = 10000;
    public static final int CREATIVE = 32000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static boolean enable = true;
    public static ItemStack reservoirBasic;
    public static ItemStack reservoirHardened;
    public static ItemStack reservoirReinforced;
    public static ItemStack reservoirSignalum;
    public static ItemStack reservoirResonant;
    public static ItemStack reservoirCreative;

    public ItemReservoir() {
        super("thermalexpansion");
        this.func_77655_b("reservoir");
        this.func_77637_a(ThermalExpansion.tabTools);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.reservoir.a.0"));
        tooltip.add(StringHelper.localizeFormat((String)("info.thermalexpansion.reservoir.a." + (this.getMode(stack) + 1)), (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        if (this.isActive(stack)) {
            tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.reservoir.d.2"));
            tooltip.add(StringHelper.getDeactivationText((String)"info.thermalexpansion.reservoir.c.1"));
        } else {
            tooltip.add(StringHelper.getActivationText((String)"info.thermalexpansion.reservoir.c.0"));
        }
        tooltip.add(StringHelper.localizeFormat((String)"info.thermalexpansion.reservoir.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null) {
            String color = "\u00a77";
            if (fluid.getFluid().getRarity() == EnumRarity.UNCOMMON) {
                color = "\u00a7e";
            } else if (fluid.getFluid().getRarity() == EnumRarity.RARE) {
                color = "\u00a7b";
            } else if (fluid.getFluid().getRarity() == EnumRarity.EPIC) {
                color = "\u00a7d";
            }
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + color + fluid.getFluid().getLocalizedName(fluid) + "\u00a77");
            if (ItemReservoir.isCreative((ItemStack)stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": " + StringHelper.formatNumber((long)fluid.amount) + " / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (ItemReservoir.isCreative((ItemStack)stack)) {
                tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable && this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)new ItemStack((Item)this, 1, metadata));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)new ItemStack((Item)this, 1, metadata));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (ServerHelper.isClientWorld((World)world) || CoreUtils.isFakePlayer((Entity)entity) || !this.isActive(stack)) {
            return;
        }
        Iterable equipment = Iterables.concat((Iterable)entity.func_184209_aF(), (Iterable)BaublesHelper.getBaubles((Entity)entity));
        for (ItemStack equipmentStack : equipment) {
            IFluidHandlerItem handler;
            if (equipmentStack.equals(stack) || equipmentStack.func_77973_b() == Items.field_151133_ar || !FluidHelper.isFluidHandler((ItemStack)equipmentStack) || (handler = FluidUtil.getFluidHandler((ItemStack)equipmentStack)) == null || this.getFluid(stack) == null) continue;
            this.drain(stack, handler.fill(new FluidStack(this.getFluid(stack), Math.min(this.getFluidAmount(stack), 1000)), true), true);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return ItemHelper.getItemDamage((ItemStack)stack) != 32000;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Fluid"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !ItemReservoir.isCreative((ItemStack)stack) && this.getFluidAmount(stack) > 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp((double)(1.0 - (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack)), (double)0.0, (double)1.0);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_70093_af()) {
            if (this.setActiveState(stack, !this.isActive(stack))) {
                if (this.isActive(stack)) {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.8f);
                } else {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.5f);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (this.getMode(stack) == 0) {
            return this.doBucketFill(stack, world, player, hand);
        }
        if (this.getMode(stack) == 1) {
            return this.doBucketEmpty(stack, world, player, hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    ActionResult<ItemStack> doBucketFill(ItemStack stack, @Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        FluidActionResult result;
        if (this.getSpace(stack) < 1000) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)true);
        if (traceResult == null || traceResult.field_178784_b == null || traceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = traceResult.func_178782_a();
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, traceResult.field_178784_b, stack) && (result = FluidUtil.tryPickUpFluid((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)traceResult.field_178784_b)).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)result.getResult());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    ActionResult<ItemStack> doBucketEmpty(ItemStack stack, @Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        if (this.getFluidAmount(stack) < 1000) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult traceResult = this.func_77621_a(world, player, false);
        if (traceResult == null || traceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = traceResult.func_178782_a();
        if (world.func_175660_a(player, pos) && player.func_175151_a(targetPos = pos.func_177972_a(traceResult.field_178784_b), traceResult.field_178784_b.func_176734_d(), stack) && (result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)stack, (FluidStack)new FluidStack(this.getFluid(stack), 1000))).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)result.getResult());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean setActiveState(ItemStack stack, boolean state) {
        if (this.getFluid(stack) != null) {
            stack.func_77978_p().func_74757_a("Active", state);
            return true;
        }
        stack.func_77978_p().func_74757_a("Active", false);
        return false;
    }

    public int getFluidAmount(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        return fluid == null ? 0 : fluid.amount;
    }

    public int getSpace(ItemStack stack) {
        return this.getCapacity(stack) - this.getFluidAmount(stack);
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.TRINKET;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        World world = player.field_70170_p;
        if (ServerHelper.isClientWorld((World)world) || !this.isActive(stack)) {
            return;
        }
        Iterable equipment = Iterables.concat((Iterable)player.func_184209_aF(), (Iterable)BaublesHelper.getBaubles((Entity)player));
        for (ItemStack equipmentStack : equipment) {
            IFluidHandlerItem handler;
            if (equipmentStack.equals(stack) || equipmentStack.func_77973_b() == Items.field_151133_ar || !FluidHelper.isFluidHandler((ItemStack)equipmentStack) || (handler = FluidUtil.getFluidHandler((ItemStack)equipmentStack)) == null || this.getFluid(stack) == null) continue;
            this.drain(stack, handler.fill(new FluidStack(this.getFluid(stack), Math.min(this.getFluidAmount(stack), 1000)), true), true);
        }
    }

    public boolean willAutoSync(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemReservoir.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (ItemHelper.getItemDamage((ItemStack)container) == 32000) {
            if (doFill) {
                NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
                fluidTag.func_74768_a("Amount", capacity - 1000);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            }
            return resource.amount;
        }
        if (!doFill) {
            if (!container.func_77978_p().func_74764_b("Fluid")) {
                return Math.min(capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", capacity);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.amount);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        container.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        int drained;
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        boolean creative = ItemReservoir.isCreative((ItemStack)container);
        int n = drained = creative ? maxDrain : Math.min(stack.amount, maxDrain);
        if (doDrain && !creative) {
            if (maxDrain >= stack.amount) {
                container.func_77978_p().func_82580_o("Fluid");
                return stack;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        stack.amount = drained;
        return stack;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        switch (this.getMode(stack)) {
            case 0: {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.6f, 1.0f);
                break;
            }
            case 1: {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.6f, 1.0f);
            }
        }
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalexpansion.reservoir.d." + this.getMode(stack), new Object[0]));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper(stack, (IFluidContainerItem)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation loc = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> loc);
        ModelRegistryHelper.register((ModelResourceLocation)loc, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerItemKeyGenerator((Item)this, stack -> {
            FluidStack fluid;
            int colour = ColorHelper.hasColor0((ItemStack)stack) ? 1 : 0;
            int active = this.isActive(stack) ? 1 : 0;
            int mode = this.getMode(stack);
            String fluid_hash = "none";
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid") && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"))) != null) {
                fluid_hash = Integer.toString(FluidHelper.getFluidHash((FluidStack)fluid));
            }
            return String.format("%s|%s,color0=%s,mode=%s_%s,fluid=%s", this.getRegistryName(), stack.func_77960_j(), colour, active, mode, fluid_hash);
        });
    }

    public IBakery getBakery() {
        return ModelReservoir.INSTANCE;
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("reservoir"));
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        ItemReservoir.config();
        reservoirBasic = this.addEntryItem(0, "standard0", CAPACITY[0], EnumRarity.COMMON);
        reservoirHardened = this.addEntryItem(1, "standard1", CAPACITY[1], EnumRarity.COMMON);
        reservoirReinforced = this.addEntryItem(2, "standard2", CAPACITY[2], EnumRarity.UNCOMMON);
        reservoirSignalum = this.addEntryItem(3, "standard3", CAPACITY[3], EnumRarity.UNCOMMON);
        reservoirResonant = this.addEntryItem(4, "standard4", CAPACITY[4], EnumRarity.RARE);
        reservoirCreative = this.addEntryItem(32000, "creative", CAPACITY[4], EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)reservoirBasic, (Object[])new Object[]{" R ", "IXI", " Y ", Character.valueOf('I'), "ingotCopper", Character.valueOf('R'), "ingotTin", Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), ItemMaterial.redstoneServo});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)reservoirHardened, (Object[])new Object[]{" R ", "IXI", " Y ", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "blockGlass", Character.valueOf('X'), reservoirBasic, Character.valueOf('Y'), "ingotCopper"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)reservoirReinforced, (Object[])new Object[]{" R ", "IXI", " Y ", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "blockGlassHardened", Character.valueOf('X'), reservoirHardened, Character.valueOf('Y'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)reservoirSignalum, (Object[])new Object[]{" R ", "IXI", " Y ", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "dustCryotheum", Character.valueOf('X'), reservoirReinforced, Character.valueOf('Y'), "ingotElectrum"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)reservoirResonant, (Object[])new Object[]{" R ", "IXI", " Y ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "dustPyrotheum", Character.valueOf('X'), reservoirSignalum, Character.valueOf('Y'), "ingotSignalum"});
        RecipeHelper.addColorRecipe((ItemStack)reservoirBasic, (Object[])new Object[]{reservoirBasic, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)reservoirHardened, (Object[])new Object[]{reservoirHardened, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)reservoirReinforced, (Object[])new Object[]{reservoirReinforced, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)reservoirSignalum, (Object[])new Object[]{reservoirSignalum, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)reservoirResonant, (Object[])new Object[]{reservoirResonant, "dye"});
        RecipeHelper.addColorRemoveRecipe((ItemStack)reservoirBasic, (Object[])new Object[]{reservoirBasic});
        RecipeHelper.addColorRemoveRecipe((ItemStack)reservoirHardened, (Object[])new Object[]{reservoirHardened});
        RecipeHelper.addColorRemoveRecipe((ItemStack)reservoirReinforced, (Object[])new Object[]{reservoirReinforced});
        RecipeHelper.addColorRemoveRecipe((ItemStack)reservoirSignalum, (Object[])new Object[]{reservoirSignalum});
        RecipeHelper.addColorRemoveRecipe((ItemStack)reservoirResonant, (Object[])new Object[]{reservoirResonant});
        return true;
    }

    private static void config() {
        String category = "Item.Reservoir";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        int capacity = 10000;
        String comment = "Adjust this value to change the amount of Fluid (in mB) stored by a Basic Reservoir. This base value will scale with item level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, 2000, capacity * 10, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    private void addEntry(int metadata, String name, int capacity) {
        typeMap.put(metadata, (Object)new TypeEntry(name, capacity));
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, EnumRarity rarity) {
        this.addEntry(metadata, name, capacity);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int capacity;

        TypeEntry(String name, int capacity) {
            this.name = name;
            this.capacity = capacity;
        }
    }
}

