/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.tile.module;

import epicsquid.mysticallib.LibEvents;
import epicsquid.mysticallib.handlers.MysticalItemHandler;
import epicsquid.mysticallib.tile.TileModular;
import epicsquid.mysticallib.tile.module.FaceConfig;
import epicsquid.mysticallib.tile.module.IModule;
import epicsquid.mysticallib.util.InventoryUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ModuleItem
implements IModule<IItemHandler> {
    @Nonnull
    public static final String ITEM_MODULE = "ITEM_MODULE";
    @Nonnull
    private MysticalItemHandler inventory;
    @Nonnull
    private TileModular tile;
    private Set<Integer> inputSlots = new TreeSet<Integer>();
    private Set<Integer> outputSlots = new TreeSet<Integer>();
    private Map<EnumFacing, ItemIOProxy> ioProxies = new HashMap<EnumFacing, ItemIOProxy>();
    @Nonnull
    private FaceConfig faceConfig;

    public ModuleItem(@Nonnull TileModular tile, int slotCount, @Nonnull Collection<Integer> inputSlots, @Nonnull Collection<Integer> outputSlots) {
        this.inventory = new MysticalItemHandler(slotCount);
        this.tile = tile;
        this.inputSlots.addAll(inputSlots);
        this.outputSlots.addAll(outputSlots);
        this.faceConfig = tile.getFaceConfig();
        for (EnumFacing dir : EnumFacing.values()) {
            this.ioProxies.put(dir, this.constructIOProxy(dir, slotCount));
        }
    }

    @Nonnull
    private ItemIOProxy constructIOProxy(@Nonnull EnumFacing dir, int capacity) {
        return new ItemIOProxy(dir, this.faceConfig.getIO(dir), capacity);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<IItemHandler> capability, @Nullable EnumFacing face) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    @Nonnull
    public IItemHandler getCapability(@Nullable Capability<IItemHandler> capability, @Nullable EnumFacing face) {
        if (face != null) {
            return (IItemHandler)this.ioProxies.get(face);
        }
        return this.inventory;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    @Override
    public void onBroken(@Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.inventory.getStackInSlot(i)));
            }
        }
    }

    @Override
    public void onUpdate(@Nonnull BlockPos pos, @Nonnull World world) {
        for (EnumFacing dir : EnumFacing.values()) {
            IItemHandler adjInv;
            TileEntity adjTile;
            if (this.faceConfig.getIO(dir) != FaceConfig.FaceIO.OUT || !world.field_72995_K || (adjTile = world.func_175625_s(pos.func_177972_a(dir))) == null || !adjTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) || (adjInv = (IItemHandler)adjTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) == null) continue;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                int amountInserted;
                int amount;
                if (this.inventory.getStackInSlot(i).func_190926_b() || !this.outputSlots.contains(i) || (amount = InventoryUtil.attemptInsert(this.inventory.getStackInSlot(i), adjInv, true)) <= 0 || (amountInserted = InventoryUtil.attemptInsert(this.inventory.getStackInSlot(i), adjInv, false)) <= 0) continue;
                this.inventory.getStackInSlot(i).func_190918_g(amountInserted);
                this.tile.func_70296_d();
                adjTile.func_70296_d();
                LibEvents.markForUpdate(this.tile.func_174877_v().func_177972_a(dir), adjTile);
            }
        }
    }

    @Override
    @Nonnull
    public String getModuleName() {
        return ITEM_MODULE;
    }

    @Override
    @Nonnull
    public Capability<IItemHandler> getCapabilityType() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public class ItemIOProxy
    extends ItemStackHandler {
        @Nonnull
        private EnumFacing dir;
        @Nonnull
        private FaceConfig.FaceIO ioMode;

        public ItemIOProxy(@Nonnull EnumFacing dir, FaceConfig.FaceIO faceIO, int size) {
            super(size);
            this.dir = dir;
            this.ioMode = faceIO;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if ((this.ioMode == FaceConfig.FaceIO.IN || this.ioMode == FaceConfig.FaceIO.INOUT) && ModuleItem.this.inputSlots.contains(slot)) {
                ModuleItem.this.tile.func_70296_d();
                return ModuleItem.this.inventory.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if ((this.ioMode == FaceConfig.FaceIO.OUT || this.ioMode == FaceConfig.FaceIO.NEUTRAL || this.ioMode == FaceConfig.FaceIO.INOUT) && ModuleItem.this.outputSlots.contains(slot)) {
                ModuleItem.this.tile.func_70296_d();
                return ModuleItem.this.inventory.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ModuleItem.this.inventory.getStackInSlot(slot);
        }

        public int getSlotLimit(int slot) {
            return ModuleItem.this.inventory.getSlotLimit(slot);
        }
    }
}

